/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.loader.ast.spi.SingleUniqueKeyEntityLoader;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class SingleUniqueKeyEntityLoaderStandard<T>
implements SingleUniqueKeyEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final ModelPart uniqueKeyAttribute;
    private final String uniqueKeyAttributePath;
    private final JdbcParametersList jdbcParameters;
    private final JdbcOperationQuerySelect jdbcSelect;

    public SingleUniqueKeyEntityLoaderStandard(EntityMappingType entityDescriptor, SingularAttributeMapping uniqueKeyMapping, LoadQueryInfluencers loadQueryInfluencers) {
        ValuedModelPart valuedModelPart;
        this.entityDescriptor = entityDescriptor;
        this.uniqueKeyAttributePath = SingleUniqueKeyEntityLoaderStandard.getAttributePath(uniqueKeyMapping);
        if (uniqueKeyMapping instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)uniqueKeyMapping;
            valuedModelPart = toOneAttributeMapping.getForeignKeyDescriptor();
        } else {
            valuedModelPart = uniqueKeyMapping;
        }
        this.uniqueKeyAttribute = valuedModelPart;
        SessionFactoryImplementor factory = entityDescriptor.getEntityPersister().getFactory();
        JdbcParametersList.Builder builder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectByUniqueKey(entityDescriptor, Collections.emptyList(), uniqueKeyMapping, null, loadQueryInfluencers, LockOptions.NONE, builder::add, factory);
        this.jdbcParameters = builder.build();
        this.jdbcSelect = SingleUniqueKeyEntityLoaderStandard.getJdbcSelect(factory, sqlAst, JdbcParameterBindings.NO_BINDINGS);
    }

    private static String getAttributePath(AttributeMapping attribute) {
        ManagedMappingType declaringType = attribute.getDeclaringType();
        if (declaringType instanceof EmbeddableMappingType) {
            EmbeddableValuedModelPart embeddedValueMapping;
            StringBuilder path = new StringBuilder();
            path.append(attribute.getAttributeName());
            while ((attribute = (embeddedValueMapping = ((EmbeddableMappingType)declaringType).getEmbeddedValueMapping()).asAttributeMapping()) != null) {
                path.insert(0, '.');
                path.insert(0, attribute.getAttributeName());
                declaringType = attribute.getDeclaringType();
                if (declaringType instanceof EmbeddableMappingType) continue;
            }
            return path.toString();
        }
        return attribute.getAttributeName();
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object ukValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        JdbcParameterBindings bindings = this.jdbcParameterBindings(ukValue, this.jdbcParameters, session);
        List<T> list = SingleUniqueKeyEntityLoaderStandard.list(this.jdbcSelect, bindings, new SingleUKEntityLoaderExecutionContext(this.uniqueKeyAttributePath, ukValue, session, readOnly));
        return switch (list.size()) {
            case 0 -> null;
            case 1 -> list.get(0);
            default -> throw new HibernateException("More than one row with the given identifier was found: " + String.valueOf(ukValue) + ", for class: " + this.entityDescriptor.getEntityName());
        };
    }

    @Override
    public Object resolveId(Object ukValue, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        JdbcParametersList.Builder builder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectByUniqueKey(this.entityDescriptor, Collections.singletonList(this.entityDescriptor.getIdentifierMapping()), this.uniqueKeyAttribute, null, new LoadQueryInfluencers(factory), LockOptions.NONE, builder::add, factory);
        JdbcParameterBindings bindings = this.jdbcParameterBindings(ukValue, builder.build(), session);
        JdbcOperationQuerySelect jdbcSelect = SingleUniqueKeyEntityLoaderStandard.getJdbcSelect(factory, sqlAst, bindings);
        List<T> list = SingleUniqueKeyEntityLoaderStandard.list(jdbcSelect, bindings, new NoCallbackExecutionContext(session));
        assert (list.size() == 1);
        return list.get(0);
    }

    private JdbcParameterBindings jdbcParameterBindings(Object ukValue, JdbcParametersList parameters, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl bindings = new JdbcParameterBindingsImpl(parameters.size());
        int offset = bindings.registerParametersForEachJdbcValue(ukValue, this.uniqueKeyAttribute, parameters, session);
        assert (offset == parameters.size());
        return bindings;
    }

    private static <T> List<T> list(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        return executionContext.getSession().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, executionContext, RowTransformerSingularReturnImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, 1);
    }

    private static JdbcOperationQuerySelect getJdbcSelect(SessionFactoryImplementor factory, SelectStatement sqlAst, JdbcParameterBindings jdbcParameterBindings) {
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
    }

    private static class SingleUKEntityLoaderExecutionContext
    extends BaseExecutionContext {
        private final String uniqueKeyAttributePath;
        private final Object uniqueKey;
        private final Callback callback;
        private final QueryOptions queryOptions;

        public SingleUKEntityLoaderExecutionContext(String uniqueKeyAttributePath, Object uniqueKey, SharedSessionContractImplementor session, Boolean readOnly) {
            super(session);
            this.uniqueKeyAttributePath = uniqueKeyAttributePath;
            this.uniqueKey = uniqueKey;
            this.queryOptions = readOnly == null ? QueryOptions.NONE : (readOnly != false ? QueryOptions.READ_ONLY : QueryOptions.READ_WRITE);
            this.callback = new CallbackImpl();
        }

        @Override
        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        @Override
        public Callback getCallback() {
            return this.callback;
        }

        @Override
        public String getEntityUniqueKeyAttributePath() {
            return this.uniqueKeyAttributePath;
        }

        @Override
        public Object getEntityUniqueKey() {
            return this.uniqueKey;
        }
    }
}

