/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.CollectionCacheEntry;
import org.hibernate.cache.spi.entry.ReferenceCacheEntryImpl;
import org.hibernate.cache.spi.entry.StandardCacheEntryImpl;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.sql.results.LoadingLogger;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class CacheLoadHelper {
    private CacheLoadHelper() {
    }

    public static PersistenceContextEntry loadFromSessionCache(EntityKey keyToLoad, LockOptions lockOptions, LoadEventListener.LoadType options, SharedSessionContractImplementor session) {
        Object old = session.getEntityUsingInterceptor(keyToLoad);
        if (old != null) {
            EntityPersister persister;
            EntityEntry oldEntry = session.getPersistenceContext().getEntry(old);
            if (options.isCheckDeleted() && oldEntry.getStatus().isDeletedOrGone()) {
                LoadingLogger.LOADING_LOGGER.foundEntityScheduledForRemoval();
                return new PersistenceContextEntry(old, PersistenceContextEntry.EntityStatus.REMOVED_ENTITY_MARKER);
            }
            if (options.isAllowNulls() && !(persister = session.getFactory().getMappingMetamodel().getEntityDescriptor(keyToLoad.getEntityName())).isInstance(old)) {
                LoadingLogger.LOADING_LOGGER.foundEntityWrongType();
                return new PersistenceContextEntry(old, PersistenceContextEntry.EntityStatus.INCONSISTENT_RTN_CLASS_MARKER);
            }
            LoaderHelper.upgradeLock(old, oldEntry, lockOptions, session);
        }
        return new PersistenceContextEntry(old, PersistenceContextEntry.EntityStatus.MANAGED);
    }

    public static Object loadFromSecondLevelCache(SharedSessionContractImplementor source, Object entity, LockMode lockMode, EntityPersister persister, EntityKey entityKey) {
        boolean useCache;
        boolean bl = useCache = persister.canReadFromCache() && source.getCacheMode().isGetEnabled() && lockMode.lessThan(LockMode.READ);
        if (useCache) {
            Object ce = CacheLoadHelper.getFromSharedCache(entityKey.getIdentifier(), persister, source);
            return ce == null ? null : CacheLoadHelper.processCachedEntry(entity, persister, ce, source, entityKey);
        }
        return null;
    }

    private static Object getFromSharedCache(Object entityId, EntityPersister persister, SharedSessionContractImplementor source) {
        EntityDataAccess cache = persister.getCacheAccessStrategy();
        SessionFactoryImplementor factory = source.getFactory();
        Object cacheKey = cache.generateCacheKey(entityId, persister, factory, source.getTenantIdentifier());
        Object ce = CacheHelper.fromSharedCache(source, cacheKey, persister, (CachedDomainDataAccess)persister.getCacheAccessStrategy());
        StatisticsImplementor statistics = factory.getStatistics();
        if (statistics.isStatisticsEnabled()) {
            NavigableRole rootEntityRole = StatsHelper.getRootEntityRole(persister);
            String regionName = cache.getRegion().getName();
            if (ce == null) {
                statistics.entityCacheMiss(rootEntityRole, regionName);
            } else {
                statistics.entityCacheHit(rootEntityRole, regionName);
            }
        }
        return ce;
    }

    private static Object processCachedEntry(Object instanceToLoad, EntityPersister persister, Object ce, SharedSessionContractImplementor source, EntityKey entityKey) {
        CacheEntry entry = (CacheEntry)persister.getCacheEntryStructure().destructure(ce, source.getFactory());
        if (entry.isReferenceEntry()) {
            if (instanceToLoad != null) {
                throw new HibernateException("Attempt to load entity from cache using provided object instance, but cache is storing references: " + String.valueOf(entityKey.getIdentifier()));
            }
            return CacheLoadHelper.convertCacheReferenceEntryToEntity((ReferenceCacheEntryImpl)entry, source, entityKey);
        }
        Object entity = CacheLoadHelper.convertCacheEntryToEntity(entry, entityKey.getIdentifier(), source, persister, instanceToLoad, entityKey);
        if (!persister.isInstance(entity)) {
            PersistenceContext persistenceContext = source.getPersistenceContext();
            persistenceContext.removeEntry(entity);
            persistenceContext.removeEntity(entityKey);
            return null;
        }
        return entity;
    }

    private static Object convertCacheReferenceEntryToEntity(ReferenceCacheEntryImpl referenceCacheEntry, SharedSessionContractImplementor session, EntityKey entityKey) {
        Object entity = referenceCacheEntry.getReference();
        if (entity == null) {
            throw new IllegalStateException("Reference cache entry contained null: " + String.valueOf(referenceCacheEntry));
        }
        CacheLoadHelper.makeEntityCircularReferenceSafe(referenceCacheEntry, session, entity, entityKey);
        return entity;
    }

    private static void makeEntityCircularReferenceSafe(ReferenceCacheEntryImpl referenceCacheEntry, SharedSessionContractImplementor session, Object entity, EntityKey entityKey) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (ManagedTypeHelper.isManagedEntity(entity)) {
            EntityHolder entityHolder = persistenceContext.addEntityHolder(entityKey, entity);
            EntityEntry entityEntry = persistenceContext.addReferenceEntry(entity, Status.READ_ONLY);
            entityHolder.setEntityEntry(entityEntry);
        } else {
            TwoPhaseLoad.addUninitializedCachedEntity(entityKey, entity, referenceCacheEntry.getSubclassPersister(), LockMode.NONE, referenceCacheEntry.getVersion(), session);
        }
        persistenceContext.initializeNonLazyCollections();
    }

    private static Object convertCacheEntryToEntity(CacheEntry entry, Object entityId, SharedSessionContractImplementor source, EntityPersister persister, Object instanceToLoad, EntityKey entityKey) {
        boolean isReadOnly;
        EntityHolder holder;
        Object proxy;
        PersistentAttributeInterceptor persistentAttributeInterceptor;
        EntityPersister subclassPersister = source.getFactory().getMappingMetamodel().getEntityDescriptor(entry.getSubclass());
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityHolder oldHolder = persistenceContext.getEntityHolder(entityKey);
        Object entity = instanceToLoad != null ? instanceToLoad : (oldHolder != null && oldHolder.getEntity() != null ? oldHolder.getEntity() : source.instantiate(subclassPersister, entityId));
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity) && ((persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor()) == null || persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
            persister.getBytecodeEnhancementMetadata().injectInterceptor(entity, entityId, source);
        }
        if ((proxy = (holder = persistenceContext.addEntityHolder(entityKey, entity)).getProxy()) != null) {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
            assert (lazyInitializer != null);
            lazyInitializer.setImplementation(entity);
            isReadOnly = lazyInitializer.isReadOnly();
        } else {
            isReadOnly = source.isDefaultReadOnly();
        }
        holder.setEntityEntry(persistenceContext.addEntry(entity, Status.LOADING, null, null, entityKey.getIdentifier(), entry.getVersion(), LockMode.NONE, true, persister, false));
        Type[] types = subclassPersister.getPropertyTypes();
        StandardCacheEntryImpl standardCacheEntry = (StandardCacheEntryImpl)entry;
        Object[] values = standardCacheEntry.assemble(entity, entityId, subclassPersister, source.getInterceptor(), source);
        if (standardCacheEntry.isDeepCopyNeeded()) {
            TypeHelper.deepCopy(values, types, subclassPersister.getPropertyUpdateability(), values, source);
        }
        Object version = Versioning.getVersion(values, subclassPersister);
        holder.setEntityEntry(persistenceContext.addEntry(entity, isReadOnly ? Status.READ_ONLY : Status.MANAGED, values, null, entityId, version, LockMode.NONE, true, subclassPersister, false));
        subclassPersister.afterInitialize(entity, source);
        persistenceContext.initializeNonLazyCollections();
        return entity;
    }

    public static boolean initializeCollectionFromCache(Object key, CollectionPersister persister, PersistentCollection<?> collection, SharedSessionContractImplementor source) {
        if (persister.hasCache() && source.getCacheMode().isGetEnabled()) {
            SessionFactoryImplementor factory = source.getFactory();
            CollectionDataAccess cacheAccessStrategy = persister.getCacheAccessStrategy();
            Object ck = cacheAccessStrategy.generateCacheKey(key, persister, factory, source.getTenantIdentifier());
            Object ce = CacheHelper.fromSharedCache(source, ck, persister, (CachedDomainDataAccess)cacheAccessStrategy);
            StatisticsImplementor statistics = factory.getStatistics();
            if (statistics.isStatisticsEnabled()) {
                NavigableRole navigableRole = persister.getNavigableRole();
                String regionName = cacheAccessStrategy.getRegion().getName();
                if (ce == null) {
                    statistics.collectionCacheMiss(navigableRole, regionName);
                } else {
                    statistics.collectionCacheHit(navigableRole, regionName);
                }
            }
            if (ce == null) {
                return false;
            }
            CollectionCacheEntry cacheEntry = (CollectionCacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
            PersistenceContext persistenceContext = source.getPersistenceContextInternal();
            cacheEntry.assemble(collection, persister, persistenceContext.getCollectionOwner(key, persister));
            persistenceContext.getCollectionEntry(collection).postInitialize(collection, source);
            return true;
        }
        return false;
    }

    public record PersistenceContextEntry(Object entity, EntityStatus status) {
        public boolean isManaged() {
            return EntityStatus.MANAGED == this.status;
        }

        static enum EntityStatus {
            MANAGED,
            REMOVED_ENTITY_MARKER,
            INCONSISTENT_RTN_CLASS_MARKER;

        }
    }
}

