/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.model.internal.DelayedParameterizedTypeBean;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Property;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ProvidedInstanceManagedBeanImpl;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserCollectionType;

@Internal
public final class MappingHelper {
    private static final Properties EMPTY_PROPERTIES = new Properties();

    private MappingHelper() {
    }

    public static ManagedBean<? extends UserCollectionType> createUserTypeBean(String role, Class<? extends UserCollectionType> userCollectionTypeClass, Map<String, ?> parameters, BootstrapContext bootstrapContext, boolean allowExtensionsInCdi) {
        return allowExtensionsInCdi ? MappingHelper.createSharedUserTypeBean(role, userCollectionTypeClass, parameters, bootstrapContext) : MappingHelper.createLocalUserTypeBean(role, userCollectionTypeClass, parameters);
    }

    private static ManagedBean<? extends UserCollectionType> createSharedUserTypeBean(String role, Class<? extends UserCollectionType> userCollectionTypeClass, Map<String, ?> parameters, BootstrapContext bootstrapContext) {
        ManagedBean<? extends UserCollectionType> managedBean = bootstrapContext.getManagedBeanRegistry().getBean(userCollectionTypeClass);
        if (CollectionHelper.isNotEmpty(parameters)) {
            if (ParameterizedType.class.isAssignableFrom(managedBean.getBeanClass())) {
                Properties copy = new Properties();
                copy.putAll(parameters);
                return new DelayedParameterizedTypeBean<UserCollectionType>(managedBean, copy);
            }
            MappingHelper.throwIgnoredCollectionTypeParameters(role, userCollectionTypeClass);
        }
        return managedBean;
    }

    private static void throwIgnoredCollectionTypeParameters(String role, Class<?> implementation) {
        throw new MappingException("'@CollectionType' [" + role + "] specified parameters, but the implementation '" + implementation.getName() + "' does not implement 'ParameterizedType' which is used to inject them");
    }

    public static void injectParameters(Object type, Properties parameters) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            parameterizedType.setParameterValues(parameters == null ? EMPTY_PROPERTIES : parameters);
        } else if (parameters != null && !parameters.isEmpty()) {
            throw new MappingException("'UserType' implementation '" + type.getClass().getName() + "' does not implement 'ParameterizedType' but parameters were provided");
        }
    }

    private static ManagedBean<UserCollectionType> createLocalUserTypeBean(String role, Class<? extends UserCollectionType> implementation, Map<String, ?> parameters) {
        UserCollectionType userCollectionType = FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(implementation);
        if (CollectionHelper.isNotEmpty(parameters)) {
            if (userCollectionType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)((Object)userCollectionType);
                Properties properties = new Properties();
                properties.putAll(parameters);
                parameterizedType.setParameterValues(properties);
            } else {
                MappingHelper.throwIgnoredCollectionTypeParameters(role, implementation);
            }
        }
        return new ProvidedInstanceManagedBeanImpl<UserCollectionType>(userCollectionType);
    }

    public static void checkPropertyColumnDuplication(Set<String> distinctColumns, List<Property> properties, String owner) throws MappingException {
        for (Property prop : properties) {
            if (!prop.isUpdateable() && !prop.isInsertable()) continue;
            prop.getValue().checkColumnDuplication(distinctColumns, owner);
        }
    }

    static Class<?> classForName(String typeName, BootstrapContext bootstrapContext) {
        return bootstrapContext.getClassLoaderAccess().classForName(typeName);
    }

    static <T> Class<? extends T> classForName(Class<T> supertype, String typeName, BootstrapContext bootstrapContext) {
        Class<?> clazz = MappingHelper.classForName(typeName, bootstrapContext);
        if (supertype.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new MappingException("Class '" + typeName + "' does not implement '" + supertype.getName() + "'");
    }
}

