/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.model.relational.ContributableDatabaseObject;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.UniqueKey;
import org.jboss.logging.Logger;

public class Table
implements Serializable,
ContributableDatabaseObject {
    private static final Logger log = Logger.getLogger(Table.class);
    private static final Column[] EMPTY_COLUMN_ARRAY = new Column[0];
    private final String contributor;
    private Identifier catalog;
    private Identifier schema;
    private Identifier name;
    private final Map<String, Column> columns = new LinkedHashMap<String, Column>();
    private PrimaryKey primaryKey;
    private final Map<ForeignKeyKey, ForeignKey> foreignKeys = new LinkedHashMap<ForeignKeyKey, ForeignKey>();
    private final Map<String, Index> indexes = new LinkedHashMap<String, Index>();
    private final Map<String, UniqueKey> uniqueKeys = new LinkedHashMap<String, UniqueKey>();
    private int uniqueInteger;
    private final List<CheckConstraint> checkConstraints = new ArrayList<CheckConstraint>();
    private String rowId;
    private String subselect;
    private boolean isAbstract;
    private boolean hasDenormalizedTables;
    private String comment;
    private String viewQuery;
    private String options;
    private List<Function<SqlStringGenerationContext, InitCommand>> initCommandProducers;
    private int sizeOfUniqueKeyMapOnLastCleanse;

    @Deprecated(since="6.2", forRemoval=true)
    public Table() {
        this("orm");
    }

    public Table(String contributor) {
        this(contributor, null);
    }

    public Table(String contributor, String name) {
        this.contributor = contributor;
        this.setName(name);
    }

    public Table(String contributor, Namespace namespace, Identifier physicalTableName, boolean isAbstract) {
        this.contributor = contributor;
        this.catalog = namespace.getPhysicalName().catalog();
        this.schema = namespace.getPhysicalName().schema();
        this.name = physicalTableName;
        this.isAbstract = isAbstract;
    }

    public Table(String contributor, Namespace namespace, Identifier physicalTableName, String subselect, boolean isAbstract) {
        this.contributor = contributor;
        this.catalog = namespace.getPhysicalName().catalog();
        this.schema = namespace.getPhysicalName().schema();
        this.name = physicalTableName;
        this.subselect = subselect;
        this.isAbstract = isAbstract;
    }

    public Table(String contributor, Namespace namespace, String subselect, boolean isAbstract) {
        this.contributor = contributor;
        this.catalog = namespace.getPhysicalName().catalog();
        this.schema = namespace.getPhysicalName().schema();
        this.subselect = subselect;
        this.isAbstract = isAbstract;
    }

    @Override
    public String getContributor() {
        return this.contributor;
    }

    public String getQualifiedName(SqlStringGenerationContext context) {
        return this.subselect != null ? "( " + this.subselect + " )" : context.format(new QualifiedTableName(this.catalog, this.schema, this.name));
    }

    @Deprecated
    public static String qualify(String catalog, String schema, String table) {
        StringBuilder qualifiedName = new StringBuilder();
        if (catalog != null) {
            qualifiedName.append(catalog).append('.');
        }
        if (schema != null) {
            qualifiedName.append(schema).append('.');
        }
        return qualifiedName.append(table).toString();
    }

    public void setName(String name) {
        this.name = Identifier.toIdentifier(name);
    }

    public String getName() {
        return this.name == null ? null : this.name.getText();
    }

    public Identifier getNameIdentifier() {
        return this.name;
    }

    public Identifier getSchemaIdentifier() {
        return this.schema;
    }

    public Identifier getCatalogIdentifier() {
        return this.catalog;
    }

    public String getQuotedName() {
        return this.name == null ? null : this.name.toString();
    }

    public String getQuotedName(Dialect dialect) {
        return this.name == null ? null : this.name.render(dialect);
    }

    public QualifiedTableName getQualifiedTableName() {
        return this.name == null ? null : new QualifiedTableName(this.catalog, this.schema, this.name);
    }

    public boolean isQuoted() {
        return this.name.isQuoted();
    }

    public void setQuoted(boolean quoted) {
        if (quoted != this.name.isQuoted()) {
            this.name = new Identifier(this.name.getText(), quoted);
        }
    }

    public void setSchema(String schema) {
        this.schema = Identifier.toIdentifier(schema);
    }

    public String getSchema() {
        return this.schema == null ? null : this.schema.getText();
    }

    public String getQuotedSchema() {
        return this.schema == null ? null : this.schema.toString();
    }

    public String getQuotedSchema(Dialect dialect) {
        return this.schema == null ? null : this.schema.render(dialect);
    }

    public boolean isSchemaQuoted() {
        return this.schema != null && this.schema.isQuoted();
    }

    public void setCatalog(String catalog) {
        this.catalog = Identifier.toIdentifier(catalog);
    }

    public String getCatalog() {
        return this.catalog == null ? null : this.catalog.getText();
    }

    public String getQuotedCatalog() {
        return this.catalog == null ? null : this.catalog.render();
    }

    public String getQuotedCatalog(Dialect dialect) {
        return this.catalog == null ? null : this.catalog.render(dialect);
    }

    public boolean isCatalogQuoted() {
        return this.catalog != null && this.catalog.isQuoted();
    }

    public Column getColumn(Column column) {
        if (column == null) {
            return null;
        }
        Column existing = this.columns.get(column.getCanonicalName());
        return column.equals(existing) ? existing : null;
    }

    public Column getColumn(Identifier name) {
        if (name == null) {
            return null;
        }
        return this.columns.get(name.getCanonicalName());
    }

    @Internal
    public Column getColumn(InFlightMetadataCollector collector, String logicalName) {
        if (this.name == null) {
            return null;
        }
        return this.getColumn(new Column(collector.getPhysicalColumnName(this, logicalName)));
    }

    public Column getColumn(int n) {
        Iterator<Column> iter = this.columns.values().iterator();
        for (int i = 0; i < n - 1; ++i) {
            iter.next();
        }
        return iter.next();
    }

    public void addColumn(Column column) {
        Column old = this.getColumn(column);
        if (old == null) {
            if (this.primaryKey != null) {
                for (Column pkColumn : this.primaryKey.getColumns()) {
                    if (!pkColumn.getCanonicalName().equals(column.getCanonicalName())) continue;
                    column.setNullable(false);
                    if (!log.isDebugEnabled()) continue;
                    log.debugf("Forcing column [%s] to be non-null as it is part of the primary key for table [%s]", (Object)column.getCanonicalName(), (Object)this.getNameIdentifier().getCanonicalName());
                }
            }
            this.columns.put(column.getCanonicalName(), column);
            column.uniqueInteger = this.columns.size();
        } else {
            column.uniqueInteger = old.uniqueInteger;
        }
    }

    @Internal
    public void columnRenamed(Column column) {
        for (Map.Entry<String, Column> entry : this.columns.entrySet()) {
            if (entry.getValue() != column) continue;
            this.columns.remove(entry.getKey());
            this.columns.put(column.getCanonicalName(), column);
            break;
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Collection<Column> getColumns() {
        return this.columns.values();
    }

    public Map<String, Index> getIndexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    @Incubating
    public Collection<ForeignKey> getForeignKeyCollection() {
        return Collections.unmodifiableCollection(this.foreignKeys.values());
    }

    @Deprecated(since="7", forRemoval=true)
    public Map<ForeignKeyKey, ForeignKey> getForeignKeys() {
        return Collections.unmodifiableMap(this.foreignKeys);
    }

    public Map<String, UniqueKey> getUniqueKeys() {
        this.cleanseUniqueKeyMapIfNeeded();
        return Collections.unmodifiableMap(this.uniqueKeys);
    }

    private void cleanseUniqueKeyMapIfNeeded() {
        if (this.uniqueKeys.size() != this.sizeOfUniqueKeyMapOnLastCleanse) {
            this.cleanseUniqueKeyMap();
            this.sizeOfUniqueKeyMapOnLastCleanse = this.uniqueKeys.size();
        }
    }

    private void cleanseUniqueKeyMap() {
        if (!this.uniqueKeys.isEmpty()) {
            if (this.uniqueKeys.size() == 1) {
                Map.Entry<String, UniqueKey> uniqueKeyEntry = this.uniqueKeys.entrySet().iterator().next();
                if (this.isSameAsPrimaryKeyColumns(uniqueKeyEntry.getValue())) {
                    this.uniqueKeys.remove(uniqueKeyEntry.getKey());
                }
            } else {
                this.uniqueKeys.entrySet().removeIf(entry -> this.isRedundantUniqueKey((UniqueKey)entry.getValue()));
            }
        }
    }

    public boolean isRedundantUniqueKey(UniqueKey uniqueKey) {
        if (!uniqueKey.isExplicit()) {
            for (UniqueKey otherUniqueKey : this.uniqueKeys.values()) {
                if (uniqueKey == otherUniqueKey || !otherUniqueKey.getColumns().containsAll(uniqueKey.getColumns()) || !uniqueKey.getColumns().containsAll(otherUniqueKey.getColumns())) continue;
                return true;
            }
        }
        if (this.isSameAsPrimaryKeyColumns(uniqueKey)) {
            this.primaryKey.setOrderingUniqueKey(uniqueKey);
            return true;
        }
        return false;
    }

    private boolean isSameAsPrimaryKeyColumns(UniqueKey uniqueKey) {
        return this.primaryKey != null && !this.primaryKey.getColumns().isEmpty() && this.primaryKey.getColumns().size() == uniqueKey.getColumns().size() && this.primaryKey.getColumns().containsAll(uniqueKey.getColumns());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        Table table;
        return object instanceof Table && this.equals(table = (Table)object);
    }

    public boolean equals(Table table) {
        if (null == table) {
            return false;
        }
        if (this == table) {
            return true;
        }
        return Identifier.areEqual(this.name, table.name) && Identifier.areEqual(this.schema, table.schema) && Identifier.areEqual(this.catalog, table.catalog);
    }

    public boolean isPrimaryKey(Column column) {
        return this.hasPrimaryKey() && this.getPrimaryKey().getColumnSpan() == 1 && this.getPrimaryKey().containsColumn(column);
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey() != null;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        this.checkPrimaryKeyUniqueKey();
    }

    public Index getOrCreateIndex(String indexName) {
        Index index = this.indexes.get(indexName);
        if (index == null) {
            index = new Index();
            index.setName(indexName);
            index.setTable(this);
            this.indexes.put(indexName, index);
        }
        return index;
    }

    public Index getIndex(String indexName) {
        return this.indexes.get(indexName);
    }

    public Index addIndex(Index index) {
        Index current = this.indexes.get(index.getName());
        if (current != null) {
            throw new MappingException("Index " + index.getName() + " already exists");
        }
        this.indexes.put(index.getName(), index);
        return index;
    }

    public UniqueKey addUniqueKey(UniqueKey uniqueKey) {
        UniqueKey current = this.uniqueKeys.get(uniqueKey.getName());
        if (current != null) {
            throw new MappingException("UniqueKey " + uniqueKey.getName() + " already exists");
        }
        this.uniqueKeys.put(uniqueKey.getName(), uniqueKey);
        return uniqueKey;
    }

    public void createUniqueKey(final Column column, final MetadataBuildingContext context) {
        String keyName = context.getBuildingOptions().getImplicitNamingStrategy().determineUniqueKeyName(new ImplicitUniqueKeyNameSource(){

            @Override
            public Identifier getTableName() {
                return Table.this.name;
            }

            @Override
            public List<Identifier> getColumnNames() {
                return Collections.singletonList(column.getNameIdentifier(context));
            }

            @Override
            public Identifier getUserProvidedIdentifier() {
                return null;
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return context;
            }
        }).render(context.getMetadataCollector().getDatabase().getDialect());
        column.setUniqueKeyName(keyName);
        column.setUnique(true);
    }

    public void createUniqueKey(final List<Column> keyColumns, final MetadataBuildingContext context) {
        if (keyColumns.size() == 1) {
            this.createUniqueKey(keyColumns.get(0), context);
        } else {
            String keyName = context.getBuildingOptions().getImplicitNamingStrategy().determineUniqueKeyName(new ImplicitUniqueKeyNameSource(){

                @Override
                public Identifier getTableName() {
                    return Table.this.name;
                }

                @Override
                public List<Identifier> getColumnNames() {
                    return keyColumns.stream().map(column -> column.getNameIdentifier(context)).collect(Collectors.toList());
                }

                @Override
                public Identifier getUserProvidedIdentifier() {
                    return null;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return context;
                }
            }).render(context.getMetadataCollector().getDatabase().getDialect());
            UniqueKey uniqueKey = this.getOrCreateUniqueKey(keyName);
            for (Column keyColumn : keyColumns) {
                uniqueKey.addColumn(keyColumn);
            }
        }
    }

    public UniqueKey getUniqueKey(String keyName) {
        return this.uniqueKeys.get(keyName);
    }

    public UniqueKey getOrCreateUniqueKey(String keyName) {
        UniqueKey uniqueKey = this.uniqueKeys.get(keyName);
        if (uniqueKey == null) {
            uniqueKey = new UniqueKey(this);
            uniqueKey.setName(keyName);
            this.uniqueKeys.put(keyName, uniqueKey);
        }
        return uniqueKey;
    }

    public void createForeignKeys(MetadataBuildingContext context) {
    }

    @Deprecated(since="7.0", forRemoval=true)
    public ForeignKey createForeignKey(String keyName, List<Column> keyColumns, String referencedEntityName, String keyDefinition) {
        return this.createForeignKey(keyName, keyColumns, referencedEntityName, keyDefinition, null, null);
    }

    public ForeignKey createForeignKey(String keyName, List<Column> keyColumns, String referencedEntityName, String keyDefinition, String options) {
        return this.createForeignKey(keyName, keyColumns, referencedEntityName, keyDefinition, options, null);
    }

    public ForeignKey createForeignKey(String keyName, List<Column> keyColumns, String referencedEntityName, String keyDefinition, String options, List<Column> referencedColumns) {
        ForeignKeyKey key = new ForeignKeyKey(keyColumns, referencedEntityName, referencedColumns);
        ForeignKey foreignKey = this.foreignKeys.get(key);
        if (foreignKey == null) {
            foreignKey = new ForeignKey(this);
            foreignKey.setReferencedEntityName(referencedEntityName);
            foreignKey.setKeyDefinition(keyDefinition);
            foreignKey.setOptions(options);
            for (Column keyColumn : keyColumns) {
                foreignKey.addColumn(keyColumn);
            }
            if (referencedColumns != null) {
                foreignKey.addReferencedColumns(referencedColumns);
            }
            foreignKey.setName(keyName);
            this.foreignKeys.put(key, foreignKey);
        }
        if (keyName != null) {
            foreignKey.setName(keyName);
        }
        return foreignKey;
    }

    private void checkPrimaryKeyUniqueKey() {
        Iterator<Map.Entry<String, UniqueKey>> uniqueKeyEntries = this.uniqueKeys.entrySet().iterator();
        while (uniqueKeyEntries.hasNext()) {
            Map.Entry<String, UniqueKey> uniqueKeyEntry = uniqueKeyEntries.next();
            UniqueKey uniqueKey = uniqueKeyEntry.getValue();
            if (!this.isSameAsPrimaryKeyColumns(uniqueKey)) continue;
            this.primaryKey.setOrderingUniqueKey(uniqueKey);
            uniqueKeyEntries.remove();
        }
    }

    public void setUniqueInteger(int uniqueInteger) {
        this.uniqueInteger = uniqueInteger;
    }

    public int getUniqueInteger() {
        return this.uniqueInteger;
    }

    @Deprecated(since="6.2")
    public void addCheckConstraint(String constraint) {
        this.addCheck(new CheckConstraint(constraint));
    }

    public void addCheck(CheckConstraint check) {
        this.checkConstraints.add(check);
    }

    public boolean containsColumn(Column column) {
        return this.columns.containsValue(column);
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String toString() {
        StringBuilder string = new StringBuilder().append(this.getClass().getSimpleName()).append('(');
        if (this.getCatalog() != null) {
            string.append(this.getCatalog()).append(".");
        }
        if (this.getSchema() != null) {
            string.append(this.getSchema()).append(".");
        }
        string.append(this.getName()).append(')');
        return string.toString();
    }

    public String getSubselect() {
        return this.subselect;
    }

    public void setSubselect(String subselect) {
        this.subselect = subselect;
    }

    public boolean isSubselect() {
        return this.subselect != null;
    }

    public boolean isAbstractUnionTable() {
        return this.hasDenormalizedTables() && this.isAbstract;
    }

    public boolean hasDenormalizedTables() {
        return this.hasDenormalizedTables;
    }

    void setHasDenormalizedTables() {
        this.hasDenormalizedTables = true;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isPhysicalTable() {
        return !this.isSubselect() && !this.isAbstractUnionTable();
    }

    public boolean isView() {
        return this.viewQuery != null;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<CheckConstraint> getChecks() {
        return Collections.unmodifiableList(this.checkConstraints);
    }

    @Override
    public String getExportIdentifier() {
        return Table.qualify(this.render(this.catalog), this.render(this.schema), this.name.render());
    }

    private String render(Identifier identifier) {
        return identifier == null ? null : identifier.render();
    }

    @Internal
    public void reorderColumns(List<Column> columns) {
        assert (this.columns.size() == columns.size() && this.columns.values().containsAll(columns));
        this.columns.clear();
        for (Column column : columns) {
            this.columns.put(column.getCanonicalName(), column);
        }
    }

    public String getViewQuery() {
        return this.viewQuery;
    }

    public void setViewQuery(String viewQuery) {
        this.viewQuery = viewQuery;
    }

    @Deprecated
    public void addInitCommand(InitCommand command) {
        this.addInitCommand((SqlStringGenerationContext ignored) -> command);
    }

    public void addInitCommand(Function<SqlStringGenerationContext, InitCommand> commandProducer) {
        if (this.initCommandProducers == null) {
            this.initCommandProducers = new ArrayList<Function<SqlStringGenerationContext, InitCommand>>();
        }
        this.initCommandProducers.add(commandProducer);
    }

    public List<InitCommand> getInitCommands(SqlStringGenerationContext context) {
        if (this.initCommandProducers == null) {
            return Collections.emptyList();
        }
        ArrayList<InitCommand> initCommands = new ArrayList<InitCommand>();
        for (Function<SqlStringGenerationContext, InitCommand> producer : this.initCommandProducers) {
            initCommands.add(producer.apply(context));
        }
        return Collections.unmodifiableList(initCommands);
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    @Deprecated(since="7")
    public static class ForeignKeyKey
    implements Serializable {
        private final String referencedClassName;
        private final Column[] columns;
        private final Column[] referencedColumns;

        ForeignKeyKey(List<Column> columns, String referencedClassName, List<Column> referencedColumns) {
            Objects.requireNonNull(columns);
            Objects.requireNonNull(referencedClassName);
            this.referencedClassName = referencedClassName;
            this.columns = columns.toArray(EMPTY_COLUMN_ARRAY);
            this.referencedColumns = referencedColumns != null ? referencedColumns.toArray(EMPTY_COLUMN_ARRAY) : EMPTY_COLUMN_ARRAY;
        }

        public int hashCode() {
            return Arrays.hashCode(this.columns) + Arrays.hashCode(this.referencedColumns);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (!(other instanceof ForeignKeyKey)) return false;
            ForeignKeyKey foreignKeyKey = (ForeignKeyKey)other;
            if (!Arrays.equals(foreignKeyKey.columns, this.columns)) return false;
            if (!Arrays.equals(foreignKeyKey.referencedColumns, this.referencedColumns)) return false;
            return true;
        }

        public String toString() {
            return "ForeignKeyKey{columns=" + Arrays.toString(this.columns) + ", referencedClassName='" + this.referencedClassName + "', referencedColumns=" + Arrays.toString(this.referencedColumns) + "}";
        }
    }
}

