/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.internal.AbstractPojoInstantiator;
import org.hibernate.metamodel.spi.EntityInstantiator;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractEntityInstantiatorPojo
extends AbstractPojoInstantiator
implements EntityInstantiator {
    private final EntityMetamodel entityMetamodel;
    private final Class<?> proxyInterface;
    private final boolean applyBytecodeInterception;

    public AbstractEntityInstantiatorPojo(EntityMetamodel entityMetamodel, PersistentClass persistentClass, JavaType<?> javaType) {
        super(javaType.getJavaTypeClass());
        this.entityMetamodel = entityMetamodel;
        this.proxyInterface = persistentClass.getProxyInterface();
        this.applyBytecodeInterception = ManagedTypeHelper.isPersistentAttributeInterceptableType(persistentClass.getMappedClass());
    }

    protected Object applyInterception(Object entity) {
        if (this.applyBytecodeInterception) {
            ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_setInterceptor(new LazyAttributeLoadingInterceptor(this.entityMetamodel.getName(), null, this.entityMetamodel.getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getLazyAttributeNames(), null));
        }
        return entity;
    }

    @Override
    public boolean isInstance(Object object) {
        return super.isInstance(object) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }
}

