/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import org.hibernate.AssertionFailure;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.ValueClassification;
import org.hibernate.metamodel.internal.AttributeContext;
import org.hibernate.metamodel.internal.AttributeMetadata;
import org.hibernate.metamodel.internal.MemberResolver;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.internal.PluralAttributeMetadata;
import org.hibernate.metamodel.internal.PluralAttributeMetadataImpl;
import org.hibernate.metamodel.internal.SingularAttributeMetadata;
import org.hibernate.metamodel.internal.SingularAttributeMetadataImpl;
import org.hibernate.metamodel.internal.ValueContext;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.internal.AnyMappingDomainTypeImpl;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MapMember;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.metamodel.model.domain.internal.SingularAttributeImpl;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessMapImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.EmbeddableAggregateJavaType;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class AttributeFactory {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(AttributeFactory.class);
    private final MetadataContext context;
    private static final MemberResolver embeddedMemberResolver = (attributeContext, metadataContext) -> {
        EmbeddableDomainType ownerType = (EmbeddableDomainType)attributeContext.getOwnerType();
        return AttributeFactory.resolveEmbeddedMember(attributeContext.getPropertyMapping(), ownerType, metadataContext);
    };
    private static final MemberResolver virtualIdentifierMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister declaringEntity = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
        return AttributeFactory.resolveVirtualIdentifierMember(attributeContext.getPropertyMapping(), declaringEntity);
    };
    private static final MemberResolver normalMemberResolver = (attributeContext, metadataContext) -> {
        ManagedDomainType ownerType = attributeContext.getOwnerType();
        Property property = attributeContext.getPropertyMapping();
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        return switch (persistenceType) {
            case Type.PersistenceType.ENTITY -> AttributeFactory.resolveEntityMember(property, AttributeFactory.getDeclaringEntity((AbstractIdentifiableType)ownerType, metadataContext));
            case Type.PersistenceType.MAPPED_SUPERCLASS -> AttributeFactory.resolveMappedSuperclassMember(property, (MappedSuperclassDomainType)ownerType, metadataContext);
            case Type.PersistenceType.EMBEDDABLE -> embeddedMemberResolver.resolveMember(attributeContext, metadataContext);
            default -> throw new IllegalArgumentException("Unexpected owner type : " + String.valueOf(persistenceType));
        };
    };
    private final MemberResolver identifierMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister declaringEntityMapping = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
        EntityIdentifierMapping identifierMapping = declaringEntityMapping.getIdentifierMapping();
        Property propertyMapping = attributeContext.getPropertyMapping();
        return !propertyMapping.getName().equals(identifierMapping.getAttributeName()) ? virtualIdentifierMemberResolver.resolveMember(attributeContext, metadataContext) : AttributeFactory.getter(declaringEntityMapping, propertyMapping, identifierMapping.getAttributeName(), identifierMapping.getJavaType().getJavaTypeClass());
    };
    private final MemberResolver versionMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister entityPersister = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
        EntityVersionMapping versionMapping = entityPersister.getVersionMapping();
        assert (entityPersister.isVersioned());
        assert (versionMapping != null);
        String versionPropertyName = attributeContext.getPropertyMapping().getName();
        if (!versionPropertyName.equals(versionMapping.getVersionAttribute().getAttributeName())) {
            throw new IllegalArgumentException("Given property did not match declared version property");
        }
        return AttributeFactory.getter(entityPersister, attributeContext.getPropertyMapping(), versionPropertyName, versionMapping.getJavaType().getJavaTypeClass());
    };

    public AttributeFactory(MetadataContext context) {
        this.context = context;
    }

    public <X, Y> PersistentAttribute<X, Y> buildAttribute(ManagedDomainType<X> ownerType, Property property) {
        return AttributeFactory.buildAttribute(ownerType, property, this.context);
    }

    public static <X, Y> PersistentAttribute<X, Y> buildAttribute(ManagedDomainType<X> ownerType, Property property, MetadataContext metadataContext) {
        if (property.isSynthetic()) {
            log.tracef("Skipping synthetic property %s(%s)", ownerType.getTypeName(), property.getName());
            return null;
        }
        log.tracef("Building attribute [%s.%s]", ownerType.getTypeName(), property.getName());
        AttributeContext<X> attributeContext = AttributeFactory.wrap(ownerType, property);
        AttributeMetadata<X, Y> attributeMetadata = AttributeFactory.determineAttributeMetadata(attributeContext, normalMemberResolver, metadataContext);
        if (attributeMetadata instanceof PluralAttributeMetadata) {
            return PluralAttributeBuilder.build((PluralAttributeMetadata)attributeMetadata, property.isGeneric(), metadataContext);
        }
        ValueContext valueContext = ((SingularAttributeMetadata)attributeMetadata).getValueContext();
        DomainType<Y> domainType = AttributeFactory.determineSimpleType(valueContext, metadataContext);
        JavaType<?> relationalJavaType = AttributeFactory.determineRelationalJavaType(valueContext, domainType, metadataContext);
        return new SingularAttributeImpl(ownerType, attributeMetadata.getName(), attributeMetadata.getAttributeClassification(), (SqmDomainType)domainType, relationalJavaType, attributeMetadata.getMember(), false, false, property.isOptional(), property.isGeneric(), metadataContext);
    }

    private static <X> AttributeContext<X> wrap(final ManagedDomainType<X> ownerType, final Property property) {
        return new AttributeContext<X>(){

            @Override
            public ManagedDomainType<X> getOwnerType() {
                return ownerType;
            }

            @Override
            public Property getPropertyMapping() {
                return property;
            }
        };
    }

    public <X, Y> SingularPersistentAttribute<X, Y> buildIdAttribute(IdentifiableDomainType<X> ownerType, Property property) {
        log.tracef("Building identifier attribute [%s.%s]", ownerType.getTypeName(), property.getName());
        AttributeMetadata<X, Y> attributeMetadata = this.determineAttributeMetadata(AttributeFactory.wrap(ownerType, property), this.identifierMemberResolver);
        SingularAttributeMetadata singularAttributeMetadata = (SingularAttributeMetadata)attributeMetadata;
        DomainType<Y> domainType = this.determineSimpleType(singularAttributeMetadata.getValueContext());
        return new SingularAttributeImpl.Identifier(ownerType, property.getName(), (SqmDomainType)domainType, attributeMetadata.getMember(), attributeMetadata.getAttributeClassification(), property.isGeneric(), this.context);
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildVersionAttribute(IdentifiableDomainType<X> ownerType, Property property) {
        log.tracef("Building version attribute [%s.%s]", ownerType.getTypeName(), property.getName());
        AttributeMetadata<X, Y> attributeMetadata = this.determineAttributeMetadata(AttributeFactory.wrap(ownerType, property), this.versionMemberResolver);
        SingularAttributeMetadata singularAttributeMetadata = (SingularAttributeMetadata)attributeMetadata;
        DomainType<Y> domainType = this.determineSimpleType(singularAttributeMetadata.getValueContext());
        return new SingularAttributeImpl.Version(ownerType, property.getName(), attributeMetadata.getAttributeClassification(), (SqmDomainType)domainType, attributeMetadata.getMember(), this.context);
    }

    private <Y> DomainType<Y> determineSimpleType(ValueContext typeContext) {
        return AttributeFactory.determineSimpleType(typeContext, this.context);
    }

    public static <Y> DomainType<Y> determineSimpleType(ValueContext typeContext, MetadataContext context) {
        return switch (typeContext.getValueClassification()) {
            case ValueClassification.BASIC -> AttributeFactory.basicDomainType(typeContext, context);
            case ValueClassification.ENTITY -> AttributeFactory.entityDomainType(typeContext, context);
            case ValueClassification.EMBEDDABLE -> AttributeFactory.embeddableDomainType(typeContext, context);
            default -> throw new AssertionFailure("Unknown type : " + String.valueOf((Object)typeContext.getValueClassification()));
        };
    }

    private static <Y> EmbeddableDomainType<Y> embeddableDomainType(ValueContext typeContext, MetadataContext context) {
        Component component = (Component)typeContext.getHibernateValue();
        return component.isDynamic() ? AttributeFactory.dynamicEmbeddableType(context, component) : AttributeFactory.classEmbeddableType(context, component);
    }

    private static <Y> EmbeddableDomainType<Y> classEmbeddableType(MetadataContext context, Component component) {
        EmbeddableDomainType<?> cached;
        assert (component.getComponentClassName() != null);
        Class<?> embeddableClass = component.getComponentClass();
        if (!component.isGeneric() && (cached = context.locateEmbeddable(embeddableClass, component)) != null) {
            return cached;
        }
        MappedSuperclass mappedSuperclass = component.getMappedSuperclass();
        MappedSuperclassDomainType<?> superType = mappedSuperclass != null ? context.locateMappedSuperclassType(mappedSuperclass) : null;
        DiscriminatorType<?> discriminatorType = component.isPolymorphic() ? component.getDiscriminatorType() : null;
        EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(context.getJavaTypeRegistry().resolveManagedTypeDescriptor(embeddableClass), superType, discriminatorType, false, context.getJpaMetamodel());
        context.registerEmbeddableType(embeddableType, component);
        if (component.isPolymorphic()) {
            Collection<String> embeddableSubclasses = component.getDiscriminatorValues().values();
            HashMap domainTypes = new HashMap();
            domainTypes.put(embeddableType.getTypeName(), embeddableType);
            ClassLoaderService classLoaderService = context.getRuntimeModelCreationContext().getBootstrapContext().getClassLoaderService();
            for (String subclassName : embeddableSubclasses) {
                if (domainTypes.containsKey(subclassName)) {
                    assert (subclassName.equals(embeddableType.getTypeName()));
                    continue;
                }
                Class subclass = classLoaderService.classForName(subclassName);
                EmbeddableTypeImpl subType = new EmbeddableTypeImpl(context.getJavaTypeRegistry().resolveManagedTypeDescriptor(subclass), (ManagedDomainType)domainTypes.get(component.getSuperclass(subclassName)), discriminatorType, false, context.getJpaMetamodel());
                domainTypes.put(subclassName, subType);
                context.registerEmbeddableType(subType, component);
            }
        }
        return embeddableType;
    }

    private static <Y> EmbeddableTypeImpl<Y> dynamicEmbeddableType(MetadataContext context, Component component) {
        EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(context.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)java.util.Map.class)), null, null, true, context.getJpaMetamodel());
        context.registerComponentByEmbeddable(embeddableType, component);
        AttributeContainer.InFlightAccess inFlightAccess = embeddableType.getInFlightAccess();
        for (Property property : component.getProperties()) {
            PersistentAttribute attribute = AttributeFactory.buildAttribute(embeddableType, property, context);
            if (attribute == null) continue;
            inFlightAccess.addAttribute(attribute);
        }
        inFlightAccess.finishUp();
        return embeddableType;
    }

    private static <Y> DomainType<Y> entityDomainType(ValueContext typeContext, MetadataContext context) {
        Type type = typeContext.getHibernateValue().getType();
        if (type instanceof EntityType) {
            EntityType entityType = (EntityType)type;
            IdentifiableDomainType domainType = context.locateIdentifiableType(entityType.getAssociatedEntityName());
            if (domainType == null) {
                JavaType domainJavaType = context.getJavaTypeRegistry().resolveDescriptor(typeContext.getJpaBindableType());
                return new EntityTypeImpl(domainJavaType, context.getJpaMetamodel());
            }
            return domainType;
        }
        assert (type instanceof AnyType);
        AnyType anyType = (AnyType)type;
        return new AnyMappingDomainTypeImpl((Any)typeContext.getHibernateValue(), anyType, context.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(anyType.getReturnedClass()), context.getRuntimeModelCreationContext().getSessionFactory().getMappingMetamodel());
    }

    private static <Y> DomainType<Y> basicDomainType(ValueContext typeContext, MetadataContext context) {
        BasicPluralType pluralType;
        Value hibernateValue = typeContext.getHibernateValue();
        if (typeContext.getJpaBindableType().isPrimitive() && ((SimpleValue)hibernateValue).getJpaAttributeConverterDescriptor() == null) {
            Class<?> type = typeContext.getJpaBindableType();
            return context.resolveBasicType(type);
        }
        Type type = hibernateValue.getType();
        if (type instanceof BasicPluralType && (pluralType = (BasicPluralType)type).getElementType().getJavaTypeDescriptor() instanceof EmbeddableAggregateJavaType) {
            AggregateColumn aggregateColumn = (AggregateColumn)hibernateValue.getColumns().get(0);
            AttributeFactory.classEmbeddableType(context, aggregateColumn.getComponent());
        }
        return (DomainType)((Object)type);
    }

    private static JavaType<?> determineRelationalJavaType(ValueContext typeContext, DomainType<?> metaModelType, MetadataContext context) {
        ConverterDescriptor<?, ?> descriptor;
        if (typeContext.getValueClassification() == ValueClassification.BASIC && (descriptor = ((SimpleValue)typeContext.getHibernateValue()).getJpaAttributeConverterDescriptor()) != null) {
            return context.getJavaTypeRegistry().resolveDescriptor(descriptor.getRelationalValueResolvedType().getErasedType());
        }
        return metaModelType.getExpressibleJavaType();
    }

    private static EntityPersister getDeclaringEntity(AbstractIdentifiableType<?> ownerType, MetadataContext metadataContext) {
        return AttributeFactory.getDeclarerEntityPersister(ownerType, metadataContext);
    }

    private static EntityPersister getDeclarerEntityPersister(AbstractIdentifiableType<?> ownerType, MetadataContext metadataContext) {
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (persistenceType == Type.PersistenceType.ENTITY) {
            return metadataContext.getMetamodel().getEntityDescriptor(ownerType.getTypeName());
        }
        if (persistenceType == Type.PersistenceType.MAPPED_SUPERCLASS) {
            PersistentClass persistentClass = metadataContext.getPersistentClassHostingProperties((MappedSuperclassTypeImpl)ownerType);
            return persistentClass != null ? metadataContext.getMetamodel().findEntityDescriptor(persistentClass.getClassName()) : null;
        }
        throw new AssertionFailure("Cannot get the metamodel for PersistenceType: " + String.valueOf(persistenceType));
    }

    private <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver) {
        return AttributeFactory.determineAttributeMetadata(attributeContext, memberResolver, this.context);
    }

    private static <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver, MetadataContext context) {
        Property propertyMapping = attributeContext.getPropertyMapping();
        String propertyName = propertyMapping.getName();
        log.tracef("Starting attribute metadata determination [%s]", propertyName);
        Member member = memberResolver.resolveMember(attributeContext, context);
        log.tracef("    Determined member [%s]", member);
        Value value = propertyMapping.getValue();
        Type type = value.getType();
        log.tracef("    Determined type [name=%s, class=%s]", type.getName(), type.getClass().getName());
        if (type instanceof AnyType) {
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.ANY);
        }
        if (type instanceof EntityType) {
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeFactory.determineSingularAssociationClassification(member));
        }
        if (type instanceof CollectionType) {
            if (value instanceof org.hibernate.mapping.Collection) {
                org.hibernate.mapping.Collection collection = (org.hibernate.mapping.Collection)value;
                Type elementType = collection.getElement().getType();
                boolean isManyToMany = AttributeFactory.isManyToMany(member);
                return new PluralAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeFactory.collectionClassification(elementType, isManyToMany), AttributeFactory.elementClassification(elementType, isManyToMany), AttributeFactory.indexClassification(value));
            }
            if (value instanceof OneToMany) {
                throw new AssertionFailure("Unexpected OneToMany");
            }
        } else {
            if (type instanceof ComponentType) {
                return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.EMBEDDED);
            }
            assert (type instanceof BasicType);
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.BASIC);
        }
        throw new UnsupportedMappingException("oops, we are missing something: " + String.valueOf(propertyMapping));
    }

    private static AttributeClassification indexClassification(Value value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return AttributeFactory.keyClassification(map.getIndex().getType());
        }
        if (value instanceof List) {
            return AttributeClassification.BASIC;
        }
        return null;
    }

    private static AttributeClassification elementClassification(Type elementType, boolean isManyToMany) {
        if (elementType instanceof AnyType) {
            return AttributeClassification.ANY;
        }
        if (elementType instanceof ComponentType) {
            return AttributeClassification.EMBEDDED;
        }
        if (elementType instanceof EntityType) {
            return isManyToMany ? AttributeClassification.MANY_TO_MANY : AttributeClassification.ONE_TO_MANY;
        }
        return AttributeClassification.BASIC;
    }

    private static AttributeClassification collectionClassification(Type elementType, boolean isManyToMany) {
        if (elementType instanceof EntityType) {
            return isManyToMany ? AttributeClassification.MANY_TO_MANY : AttributeClassification.ONE_TO_MANY;
        }
        return AttributeClassification.ELEMENT_COLLECTION;
    }

    private static AttributeClassification keyClassification(Type keyType) {
        if (keyType instanceof AnyType) {
            return AttributeClassification.ANY;
        }
        if (keyType instanceof ComponentType) {
            return AttributeClassification.EMBEDDED;
        }
        if (keyType instanceof EntityType) {
            return AttributeClassification.MANY_TO_ONE;
        }
        return AttributeClassification.BASIC;
    }

    public static AttributeClassification determineSingularAssociationClassification(Member member) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return field.getAnnotation(OneToOne.class) != null ? AttributeClassification.ONE_TO_ONE : AttributeClassification.MANY_TO_ONE;
        }
        if (member instanceof MapMember) {
            return AttributeClassification.MANY_TO_ONE;
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            return method.getAnnotation(OneToOne.class) != null ? AttributeClassification.ONE_TO_ONE : AttributeClassification.MANY_TO_ONE;
        }
        throw new AssertionFailure("Unexpected member type");
    }

    public static ParameterizedType getSignatureType(Member member) {
        Class<?> type;
        if (member instanceof Field) {
            Field field = (Field)member;
            type = field.getGenericType();
        } else if (member instanceof Method) {
            Method method = (Method)member;
            type = method.getGenericReturnType();
        } else if (member instanceof MapMember) {
            MapMember mapMember = (MapMember)member;
            type = mapMember.getType();
        } else {
            throw new AssertionFailure("Unexpected member type");
        }
        return type instanceof Class ? null : (ParameterizedType)((Object)type);
    }

    public static boolean isManyToMany(Member member) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return field.getAnnotation(ManyToMany.class) != null;
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            return method.getAnnotation(ManyToMany.class) != null;
        }
        return false;
    }

    private static Member resolveEmbeddedMember(Property property, EmbeddableDomainType<?> ownerType, MetadataContext metadataContext) {
        Component ownerBootDescriptor = metadataContext.getEmbeddableBootDescriptor(ownerType);
        CompositeTypeImplementor ownerComponentType = (CompositeTypeImplementor)ownerBootDescriptor.getType();
        EmbeddableValuedModelPart ownerMappingModelDescriptor = ownerComponentType.getMappingModelPart();
        EmbeddableRepresentationStrategy ownerRepStrategy = AttributeFactory.ownerRepresentationStrategy(metadataContext, ownerMappingModelDescriptor, ownerBootDescriptor);
        if (ownerRepStrategy.getMode() == RepresentationMode.MAP) {
            return new MapMember(property.getName(), property.getType().getReturnedClass());
        }
        return ownerRepStrategy.resolvePropertyAccess(property).getGetter().getMember();
    }

    private static EmbeddableRepresentationStrategy ownerRepresentationStrategy(MetadataContext metadataContext, EmbeddableValuedModelPart ownerMappingModelDescriptor, Component ownerBootDescriptor) {
        if (ownerMappingModelDescriptor == null) {
            return ownerBootDescriptor.getBuildingContext().getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(ownerBootDescriptor, null, metadataContext.getRuntimeModelCreationContext());
        }
        return ownerMappingModelDescriptor.getEmbeddableTypeDescriptor().getRepresentationStrategy();
    }

    private static Member resolveVirtualIdentifierMember(Property property, EntityPersister entityPersister) {
        String attributeName;
        EntityIdentifierMapping identifierMapping = entityPersister.getIdentifierMapping();
        if (identifierMapping.getNature() != EntityIdentifierMapping.Nature.VIRTUAL) {
            throw new IllegalArgumentException("expecting IdClass mapping");
        }
        CompositeIdentifierMapping cid = (CompositeIdentifierMapping)identifierMapping;
        EmbeddableMappingType embeddable = cid.getPartMappingType();
        AttributeMapping attributeMapping = embeddable.findAttributeMapping(attributeName = property.getName());
        if (attributeMapping == null) {
            throw new PropertyNotFoundException("Could not resolve attribute '" + attributeName + "' of '" + embeddable.getJavaType().getJavaTypeClass().getName() + "'");
        }
        Getter getter = attributeMapping.getPropertyAccess().getGetter();
        return getter instanceof PropertyAccessMapImpl.GetterImpl ? new MapMember(attributeName, property.getType().getReturnedClass()) : getter.getMember();
    }

    private static Member resolveEntityMember(Property property, EntityPersister declaringEntity) {
        String propertyName = property.getName();
        AttributeMapping attributeMapping = declaringEntity.findAttributeMapping(propertyName);
        return attributeMapping == null ? AttributeFactory.resolveVirtualIdentifierMember(property, declaringEntity) : AttributeFactory.getter(declaringEntity, property, propertyName, property.getType().getReturnedClass());
    }

    private static Member resolveMappedSuperclassMember(Property property, MappedSuperclassDomainType<?> ownerType, MetadataContext context) {
        EntityPersister declaringEntity = AttributeFactory.getDeclaringEntity((AbstractIdentifiableType)((Object)ownerType), context);
        if (declaringEntity != null) {
            return AttributeFactory.resolveEntityMember(property, declaringEntity);
        }
        ManagedDomainType subType = ownerType.getSubTypes().iterator().next();
        Type.PersistenceType persistenceType = subType.getPersistenceType();
        return switch (persistenceType) {
            case Type.PersistenceType.ENTITY -> AttributeFactory.resolveEntityMember(property, AttributeFactory.getDeclaringEntity((AbstractIdentifiableType)subType, context));
            case Type.PersistenceType.MAPPED_SUPERCLASS -> AttributeFactory.resolveMappedSuperclassMember(property, (MappedSuperclassDomainType)subType, context);
            case Type.PersistenceType.EMBEDDABLE -> AttributeFactory.resolveEmbeddedMember(property, (EmbeddableDomainType)subType, context);
            default -> throw new IllegalArgumentException("Unexpected PersistenceType: " + String.valueOf(persistenceType));
        };
    }

    private static Member getter(EntityPersister persister, Property property, String name, Class<?> type) {
        Getter getter = AttributeFactory.getter(persister, property);
        return getter instanceof PropertyAccessMapImpl.GetterImpl ? new MapMember(name, type) : getter.getMember();
    }

    private static Getter getter(EntityPersister persister, Property property) {
        return persister.getRepresentationStrategy().resolvePropertyAccess(property).getGetter();
    }
}

