/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Field;
import org.hibernate.AssertionFailure;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.query.NamedQueryDefinition;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.JpaMetamodel;

public class InjectionHelper {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(MetadataContext.class);

    public static void injectEntityGraph(NamedEntityGraphDefinition definition, Class<?> metamodelClass, JpaMetamodel jpaMetamodel) {
        if (metamodelClass != null) {
            try {
                InjectionHelper.injectField(metamodelClass, "_" + InjectionHelper.javaIdentifier(definition.name()), jpaMetamodel.findEntityGraphByName(definition.name()), false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    public static void injectTypedQueryReference(NamedQueryDefinition<?> definition, Class<?> metamodelClass) {
        if (metamodelClass != null) {
            try {
                InjectionHelper.injectField(metamodelClass, "_" + InjectionHelper.javaIdentifier(definition.getRegistrationName()) + "_", definition, false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    public static String javaIdentifier(String name) {
        int codePoint;
        StringBuilder result = new StringBuilder();
        for (int position = 0; position < name.length(); position += Character.charCount(codePoint)) {
            codePoint = name.codePointAt(position);
            if (Character.isJavaIdentifierPart(codePoint)) {
                result.appendCodePoint(codePoint);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    public static void injectField(Class<?> metamodelClass, String name, Object model, boolean allowNonDeclaredFieldReference) throws NoSuchFieldException {
        Field field = allowNonDeclaredFieldReference ? metamodelClass.getField(name) : metamodelClass.getDeclaredField(name);
        try {
            ReflectHelper.ensureAccessibility(field);
            field.set(null, model);
        }
        catch (IllegalAccessException e) {
            throw new AssertionFailure("Unable to inject static metamodel attribute : " + metamodelClass.getName() + "#" + name, e);
        }
        catch (IllegalArgumentException e) {
            log.illegalArgumentOnStaticMetamodelFieldInjection(metamodelClass.getName(), name, model.getClass().getName(), field.getType().getName());
        }
    }
}

