/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.internal.UnsavedValueFactory;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicEntityIdentifierMappingImpl
implements BasicEntityIdentifierMapping,
FetchOptions {
    private final NavigableRole idRole;
    private final String attributeName;
    private final IdentifierValue unsavedStrategy;
    private final PropertyAccess propertyAccess;
    private final EntityPersister entityPersister;
    private final String rootTable;
    private final String pkColumnName;
    private final String columnDefinition;
    private final Long length;
    private final Integer precision;
    private final Integer scale;
    private final boolean insertable;
    private final boolean updateable;
    private final BasicType<Object> idType;
    private final SessionFactoryImplementor sessionFactory;

    public BasicEntityIdentifierMappingImpl(EntityPersister entityPersister, Supplier<?> instanceCreator, String attributeName, String rootTable, String pkColumnName, String columnDefinition, Long length, Integer precision, Integer scale, boolean insertable, boolean updateable, BasicType<?> idType, MappingModelCreationProcess creationProcess) {
        this.columnDefinition = columnDefinition;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.insertable = insertable;
        this.updateable = updateable;
        assert (attributeName != null);
        this.attributeName = attributeName;
        this.rootTable = rootTable;
        this.pkColumnName = pkColumnName;
        this.idType = idType;
        this.entityPersister = entityPersister;
        PersistentClass bootEntityDescriptor = creationProcess.getCreationContext().getBootModel().getEntityBinding(entityPersister.getEntityName());
        this.propertyAccess = entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getIdentifierProperty());
        this.idRole = entityPersister.getNavigableRole().append("{id}");
        this.sessionFactory = creationProcess.getCreationContext().getSessionFactory();
        this.unsavedStrategy = UnsavedValueFactory.getUnsavedIdentifierValue(bootEntityDescriptor.getIdentifier(), this.getJavaType(), this.propertyAccess.getGetter(), instanceCreator);
    }

    public String toString() {
        return "EntityIdentifierMapping(" + this.idRole.getFullPath() + ")";
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public EntityIdentifierMapping.Nature getNature() {
        return EntityIdentifierMapping.Nature.SIMPLE;
    }

    @Override
    public IdentifierValue getUnsavedStrategy() {
        return this.unsavedStrategy;
    }

    @Override
    public Object getIdentifier(Object entity) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(entity);
        if (lazyInitializer != null) {
            return lazyInitializer.getIdentifier();
        }
        return this.propertyAccess.getGetter().get(entity);
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        this.propertyAccess.getSetter().set(entity, id);
    }

    @Override
    public Object instantiate() {
        return this.entityPersister.getRepresentationStrategy().getInstantiator().instantiate();
    }

    @Override
    public MappingType getPartMappingType() {
        return this.getJdbcMapping()::getJavaTypeDescriptor;
    }

    @Override
    public MappingType getMappedType() {
        return this.getJdbcMapping()::getJavaTypeDescriptor;
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, domainValue, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.entityPersister;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.idType);
        return this.getJdbcTypeCount();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.getMappedType().getMappedJavaType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.idRole;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, null, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.entityPersister.getIdentifierMapping().getSingleJdbcMapping(), navigablePath, false, !sqlSelection.isVirtual());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, tableGroup, null, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, tableGroup, null, creationState), this.getJdbcMapping());
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, TableGroup tableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        TableReference rootTableReference;
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        try {
            rootTableReference = tableGroup.resolveTableReference(navigablePath, this.rootTable);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Could not resolve table reference `%s` relative to TableGroup `%s` related with NavigablePath `%s`", this.rootTable, tableGroup, navigablePath), e);
        }
        Expression expression = expressionResolver.resolveSqlExpression(rootTableReference, this);
        return expressionResolver.resolveSqlSelection(expression, this.idType.getJdbcJavaType(), fetchParent, this.sessionFactory.getTypeConfiguration());
    }

    @Override
    public String getContainingTableExpression() {
        return this.rootTable;
    }

    @Override
    public String getSelectionExpression() {
        return this.pkColumnName;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getTemporalPrecision() {
        return null;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.idType;
    }

    @Override
    public String getFetchableName() {
        return this.entityPersister.getIdentifierPropertyName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.idType.disassemble(value, session);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        this.idType.addToCacheKey(cacheKey, value, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.idType.forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(fetchablePath, tableGroup, fetchParent, creationState);
        JdbcMappingContainer selectionType = sqlSelection.getExpressionType();
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, this.getJdbcMapping().getValueConverter(), FetchTiming.IMMEDIATE, true, creationState, selectionType != null && selectionType.getSingleJdbcMapping().getJdbcJavaType() != this.getJdbcMapping().getJdbcJavaType(), !sqlSelection.isVirtual());
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }
}

