/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicValuedCollectionPart
implements CollectionPart,
BasicValuedModelPart,
FetchOptions {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final CollectionPart.Nature nature;
    private final SelectableMapping selectableMapping;

    public BasicValuedCollectionPart(CollectionPersister collectionDescriptor, CollectionPart.Nature nature, SelectableMapping selectableMapping) {
        this.navigableRole = collectionDescriptor.getNavigableRole().append(nature.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.nature = nature;
        this.selectableMapping = selectableMapping;
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public PluralAttributeMapping getCollectionAttribute() {
        return this.collectionDescriptor.getAttributeMapping();
    }

    @Override
    public MappingType getPartMappingType() {
        return this.selectableMapping.getJdbcMapping()::getJavaTypeDescriptor;
    }

    @Override
    public String getContainingTableExpression() {
        return this.selectableMapping.getContainingTableExpression();
    }

    @Override
    public String getSelectionExpression() {
        return this.selectableMapping.getSelectionExpression();
    }

    @Override
    public boolean isFormula() {
        return this.selectableMapping.isFormula();
    }

    @Override
    public boolean isNullable() {
        return this.selectableMapping.isNullable();
    }

    @Override
    public boolean isInsertable() {
        return this.selectableMapping.isInsertable();
    }

    @Override
    public boolean isPartitioned() {
        return this.selectableMapping.isPartitioned();
    }

    @Override
    public boolean isUpdateable() {
        return this.selectableMapping.isUpdateable();
    }

    @Override
    public String getCustomReadExpression() {
        return this.selectableMapping.getCustomReadExpression();
    }

    @Override
    public String getCustomWriteExpression() {
        return this.selectableMapping.getCustomWriteExpression();
    }

    @Override
    public String getColumnDefinition() {
        return this.selectableMapping.getColumnDefinition();
    }

    @Override
    public Long getLength() {
        return this.selectableMapping.getLength();
    }

    @Override
    public Integer getPrecision() {
        return this.selectableMapping.getPrecision();
    }

    @Override
    public Integer getTemporalPrecision() {
        return this.selectableMapping.getTemporalPrecision();
    }

    @Override
    public Integer getScale() {
        return this.selectableMapping.getScale();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.selectableMapping.getJdbcMapping().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    public String toString() {
        return "BasicValuedCollectionPart(" + String.valueOf(this.navigableRole) + ")@" + System.identityHashCode(this);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, null, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.selectableMapping.getJdbcMapping(), navigablePath, false, !sqlSelection.isVirtual());
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, TableGroup tableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        SqlExpressionResolver exprResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TableGroup targetTableGroup = this.nature == CollectionPart.Nature.INDEX && this.collectionDescriptor.getAttributeMapping().getIndexMetadata().getIndexPropertyName() != null ? ((PluralTableGroup)tableGroup).getElementTableGroup() : tableGroup;
        TableReference tableReference = targetTableGroup.resolveTableReference(navigablePath, this.getContainingTableExpression());
        return exprResolver.resolveSqlSelection(exprResolver.resolveSqlExpression(tableReference, this.selectableMapping), this.getJdbcMapping().getJdbcJavaType(), fetchParent, creationState.getSqlAstCreationState().getCreationContext().getTypeConfiguration());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, tableGroup, null, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, tableGroup, null, creationState), this.getJdbcMapping());
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.selectableMapping.getJdbcMapping();
    }

    @Override
    public MappingType getMappedType() {
        return this::getJavaType;
    }

    @Override
    public String getFetchableName() {
        return this.nature.getName();
    }

    @Override
    public int getFetchableKey() {
        return this.nature == CollectionPart.Nature.INDEX || !this.collectionDescriptor.hasIndex() ? 0 : 1;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        NavigablePath parentNavigablePath;
        if (ResultsLogger.RESULTS_LOGGER.isDebugEnabled()) {
            ResultsLogger.RESULTS_LOGGER.debugf("Generating Fetch for collection-part : `%s` -> `%s`", (Object)this.collectionDescriptor.getRole(), (Object)this.nature.getName());
        }
        if ((parentNavigablePath = fetchablePath.getParent()) instanceof EntityIdentifierNavigablePath) {
            parentNavigablePath = parentNavigablePath.getParent();
        }
        TableGroup tableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(parentNavigablePath);
        SqlSelection sqlSelection = this.resolveSqlSelection(fetchablePath, tableGroup, fetchParent, creationState);
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, FetchTiming.IMMEDIATE, creationState, !sqlSelection.isVirtual());
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.getJdbcMapping();
    }

    @Override
    public JdbcMapping getSingleJdbcMapping() {
        return this.getJdbcMapping();
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.selectableMapping.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this.selectableMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, this.disassemble(domainValue, session), this);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int decompose(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, this.disassemble(domainValue, session), this);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }
}

