/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.graph.RootGraph;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.internal.JpaMetamodelPopulationSetting;
import org.hibernate.metamodel.internal.JpaStaticMetamodelPopulationSetting;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.CompositeSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EntityPersisterConcurrentMap;
import org.hibernate.metamodel.model.domain.internal.JpaMetamodelImpl;
import org.hibernate.metamodel.model.domain.internal.TupleMappingModelExpressible;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.spi.QueryParameterBindingTypeResolver;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tuple.TupleType;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleSimpleSqmPathSource;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleSqmPathSource;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindableType;
import org.hibernate.type.BindingContext;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class MappingMetamodelImpl
implements MappingMetamodelImplementor,
JpaMetamodel,
Metamodel,
QueryParameterBindingTypeResolver,
BindingContext,
Serializable {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(MappingMetamodelImpl.class);
    private final JpaMetamodelImpl jpaMetamodel;
    private final Map<Class<?>, String> entityProxyInterfaceMap = new ConcurrentHashMap();
    private final EntityPersisterConcurrentMap entityPersisterMap = new EntityPersisterConcurrentMap();
    private final Map<String, CollectionPersister> collectionPersisterMap = new ConcurrentHashMap<String, CollectionPersister>();
    private final Map<String, Set<String>> collectionRolesByEntityParticipant = new ConcurrentHashMap<String, Set<String>>();
    private final Map<NavigableRole, EmbeddableValuedModelPart> embeddableValuedModelPart = new ConcurrentHashMap<NavigableRole, EmbeddableValuedModelPart>();
    private final Set<EntityNameResolver> entityNameResolvers = new HashSet<EntityNameResolver>();
    private final Map<TupleType<?>, MappingModelExpressible<?>> tupleTypeCache = new ConcurrentHashMap();

    public MappingMetamodelImpl(TypeConfiguration typeConfiguration, ServiceRegistry serviceRegistry) {
        this.jpaMetamodel = new JpaMetamodelImpl(typeConfiguration, this, serviceRegistry);
    }

    @Override
    public JpaMetamodelImplementor getJpaMetamodel() {
        return this.jpaMetamodel;
    }

    public void finishInitialization(RuntimeModelCreationContext context) {
        MetadataImplementor bootModel = context.getBootModel();
        bootModel.visitRegisteredComponents(Component::prepareForMappingModel);
        bootModel.getMappedSuperclassMappingsCopy().forEach(MappedSuperclass::prepareForMappingModel);
        bootModel.getEntityBindings().forEach(persistentClass -> persistentClass.prepareForMappingModel(context));
        PersisterFactory persisterFactory = this.jpaMetamodel.getServiceRegistry().requireService(PersisterFactory.class);
        CacheImplementor cache = context.getCache();
        this.processBootEntities(bootModel.getEntityBindings(), cache, persisterFactory, context);
        this.processBootCollections(bootModel.getCollectionBindings(), cache, persisterFactory, context);
        MappingModelCreationProcess.process(this.entityPersisterMap, this.collectionPersisterMap, context);
        for (EntityPersister persister : this.entityPersisterMap.values()) {
            persister.postInstantiate();
            MappingMetamodelImpl.registerEntityNameResolvers(persister, this.entityNameResolvers);
        }
        for (EntityPersister persister : this.entityPersisterMap.values()) {
            persister.prepareLoaders();
        }
        this.collectionPersisterMap.values().forEach(CollectionPersister::postInstantiate);
        this.registerEmbeddableMappingType(bootModel);
        Map<String, Object> settings = context.getSettings();
        this.jpaMetamodel.processJpa(bootModel, this, this.entityProxyInterfaceMap, JpaStaticMetamodelPopulationSetting.determineJpaStaticMetaModelPopulationSetting(settings), JpaMetamodelPopulationSetting.determineJpaMetaModelPopulationSetting(settings), bootModel.getNamedEntityGraphs().values(), context);
    }

    private void registerEmbeddableMappingType(MetadataImplementor bootModel) {
        bootModel.visitRegisteredComponents(composite -> {
            ComponentType compositeType = (ComponentType)composite.getType();
            EmbeddableValuedModelPart mappingModelPart = compositeType.getMappingModelPart();
            this.embeddableValuedModelPart.put(mappingModelPart.getNavigableRole(), mappingModelPart);
        });
    }

    private void processBootEntities(Collection<PersistentClass> entityBindings, CacheImplementor cacheImplementor, PersisterFactory persisterFactory, RuntimeModelCreationContext modelCreationContext) {
        for (PersistentClass model : entityBindings) {
            NavigableRole rootEntityRole = new NavigableRole(model.getRootClass().getEntityName());
            EntityPersister entityPersister = persisterFactory.createEntityPersister(model, cacheImplementor.getEntityRegionAccess(rootEntityRole), cacheImplementor.getNaturalIdCacheRegionAccessStrategy(rootEntityRole), modelCreationContext);
            this.entityPersisterMap.put(model.getEntityName(), entityPersister);
            if (model.getClassName() != null && !model.getClassName().equals(model.getEntityName())) {
                this.entityPersisterMap.putIfAbsent(model.getClassName(), entityPersister);
            }
            if (entityPersister.getConcreteProxyClass() == null || !entityPersister.getConcreteProxyClass().isInterface() || Map.class.isAssignableFrom(entityPersister.getConcreteProxyClass()) || entityPersister.getMappedClass() == entityPersister.getConcreteProxyClass()) continue;
            if (entityPersister.getMappedClass().equals(entityPersister.getConcreteProxyClass())) {
                if (!log.isDebugEnabled()) continue;
                log.debugf("Entity [%s] mapped same interface [%s] as class and proxy", entityPersister.getEntityName(), entityPersister.getMappedClass());
                continue;
            }
            String existing = this.entityProxyInterfaceMap.put(entityPersister.getConcreteProxyClass(), entityPersister.getEntityName());
            if (existing == null) continue;
            throw new HibernateException(String.format(Locale.ENGLISH, "Multiple entities [%s, %s] named the same interface [%s] as their proxy which is not supported", existing, entityPersister.getEntityName(), entityPersister.getConcreteProxyClass().getName()));
        }
    }

    private void processBootCollections(Collection<org.hibernate.mapping.Collection> collectionBindings, CacheImplementor cacheImplementor, PersisterFactory persisterFactory, RuntimeModelCreationContext modelCreationContext) {
        for (org.hibernate.mapping.Collection model : collectionBindings) {
            EntityType entityType;
            NavigableRole navigableRole = new NavigableRole(model.getRole());
            CollectionPersister persister = persisterFactory.createCollectionPersister(model, cacheImplementor.getCollectionRegionAccess(navigableRole), modelCreationContext);
            this.collectionPersisterMap.put(model.getRole(), persister);
            Type type = persister.getIndexType();
            if (type instanceof EntityType) {
                entityType = (EntityType)type;
                this.registerEntityParticipant(entityType, persister);
            }
            if (!((type = persister.getElementType()) instanceof EntityType)) continue;
            entityType = (EntityType)type;
            this.registerEntityParticipant(entityType, persister);
        }
    }

    private void registerEntityParticipant(EntityType entityType, CollectionPersister persister) {
        String entityName = entityType.getAssociatedEntityName();
        this.collectionRolesByEntityParticipant.computeIfAbsent(entityName, k -> new HashSet()).add(persister.getRole());
    }

    private static void registerEntityNameResolvers(EntityPersister persister, Set<EntityNameResolver> entityNameResolvers) {
        if (persister.getRepresentationStrategy() != null) {
            MappingMetamodelImpl.registerEntityNameResolvers(persister.getRepresentationStrategy(), entityNameResolvers);
        }
    }

    private static void registerEntityNameResolvers(EntityRepresentationStrategy representationStrategy, Set<EntityNameResolver> entityNameResolvers) {
        representationStrategy.visitEntityNameResolvers(entityNameResolvers::add);
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.jpaMetamodel.getTypeConfiguration();
    }

    @Override
    public MappingMetamodel getMappingMetamodel() {
        return this;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.jpaMetamodel.getServiceRegistry();
    }

    @Override
    public void forEachEntityDescriptor(Consumer<EntityPersister> action) {
        for (EntityPersister value : this.entityPersisterMap.values()) {
            action.accept(value);
        }
    }

    @Override
    @Deprecated(forRemoval=true)
    public Stream<EntityPersister> streamEntityDescriptors() {
        return Arrays.stream(this.entityPersisterMap.values());
    }

    @Override
    public EntityPersister getEntityDescriptor(String entityName) {
        EntityPersister entityPersister = this.entityPersisterMap.get(entityName);
        if (entityPersister == null) {
            throw new UnknownEntityTypeException(entityName);
        }
        return entityPersister;
    }

    @Override
    public EntityPersister getEntityDescriptor(NavigableRole name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddableValuedModelPart(NavigableRole role) {
        EmbeddableValuedModelPart embeddableMappingType = this.embeddableValuedModelPart.get(role);
        if (embeddableMappingType == null) {
            throw new IllegalArgumentException("Unable to locate EmbeddableValuedModelPart: " + String.valueOf(role));
        }
        return embeddableMappingType;
    }

    @Override
    public EntityPersister findEntityDescriptor(String entityName) {
        return this.entityPersisterMap.get(entityName);
    }

    @Override
    public EntityPersister findEntityDescriptor(Class<?> entityJavaType) {
        return this.findEntityDescriptor(entityJavaType.getName());
    }

    @Override
    public boolean isEntityClass(Class<?> entityJavaType) {
        return this.entityPersisterMap.containsKey(entityJavaType.getName());
    }

    @Override
    public EntityPersister getEntityDescriptor(Class<?> entityJavaType) {
        String mappedEntityName;
        EntityPersister entityPersister = this.entityPersisterMap.get(entityJavaType.getName());
        if (entityPersister == null && (mappedEntityName = this.entityProxyInterfaceMap.get(entityJavaType)) != null) {
            entityPersister = this.entityPersisterMap.get(mappedEntityName);
        }
        if (entityPersister == null) {
            throw new UnknownEntityTypeException(entityJavaType);
        }
        return entityPersister;
    }

    @Override
    @Deprecated(forRemoval=true)
    public EntityPersister locateEntityDescriptor(Class<?> byClass) {
        String mappedEntityName;
        EntityPersister entityPersister = this.entityPersisterMap.get(byClass.getName());
        if (entityPersister == null && (mappedEntityName = this.entityProxyInterfaceMap.get(byClass)) != null) {
            entityPersister = this.entityPersisterMap.get(mappedEntityName);
        }
        if (entityPersister == null) {
            throw new UnknownEntityTypeException(byClass);
        }
        return entityPersister;
    }

    @Override
    public <X> EntityDomainType<X> entity(Class<X> cls) {
        return this.jpaMetamodel.entity((Class)cls);
    }

    @Override
    public <X> ManagedDomainType<X> managedType(Class<X> cls) {
        return this.jpaMetamodel.managedType((Class)cls);
    }

    @Override
    public <X> EmbeddableDomainType<X> embeddable(Class<X> cls) {
        return this.jpaMetamodel.embeddable((Class)cls);
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return this.jpaMetamodel.getManagedTypes();
    }

    public Set<jakarta.persistence.metamodel.EntityType<?>> getEntities() {
        return this.jpaMetamodel.getEntities();
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return this.jpaMetamodel.getEmbeddables();
    }

    @Override
    public <X> @Nullable ManagedDomainType<X> findManagedType(@Nullable String typeName) {
        return this.jpaMetamodel.findManagedType(typeName);
    }

    @Override
    public <X> ManagedDomainType<X> managedType(String typeName) {
        return this.jpaMetamodel.managedType(typeName);
    }

    @Override
    public @Nullable EntityDomainType<?> findEntityType(@Nullable String entityName) {
        return this.jpaMetamodel.findEntityType(entityName);
    }

    @Override
    public EntityDomainType<?> entity(String entityName) {
        return this.jpaMetamodel.entity(entityName);
    }

    @Override
    public @Nullable EmbeddableDomainType<?> findEmbeddableType(@Nullable String embeddableName) {
        return this.jpaMetamodel.findEmbeddableType(embeddableName);
    }

    @Override
    public EmbeddableDomainType<?> embeddable(String embeddableName) {
        return this.jpaMetamodel.embeddable(embeddableName);
    }

    @Override
    public <X> EntityDomainType<X> getHqlEntityReference(String entityName) {
        return this.jpaMetamodel.getHqlEntityReference(entityName);
    }

    @Override
    public <X> EntityDomainType<X> resolveHqlEntityReference(String entityName) {
        return this.jpaMetamodel.resolveHqlEntityReference(entityName);
    }

    @Override
    public <X> ManagedDomainType<X> findManagedType(Class<X> cls) {
        return this.jpaMetamodel.findManagedType(cls);
    }

    @Override
    public <X> EntityDomainType<X> findEntityType(Class<X> cls) {
        return this.jpaMetamodel.findEntityType(cls);
    }

    @Override
    public <X> @Nullable EmbeddableDomainType<X> findEmbeddableType(Class<X> cls) {
        return this.jpaMetamodel.findEmbeddableType(cls);
    }

    @Override
    public String qualifyImportableName(String queryName) {
        return this.jpaMetamodel.qualifyImportableName(queryName);
    }

    @Override
    public Set<String> getEnumTypesForValue(String enumValue) {
        return this.jpaMetamodel.getEnumTypesForValue(enumValue);
    }

    @Override
    public JavaType<?> getJavaConstantType(String className, String fieldName) {
        return this.jpaMetamodel.getJavaConstantType(className, fieldName);
    }

    @Override
    public <T> T getJavaConstant(String className, String fieldName) {
        return this.jpaMetamodel.getJavaConstant(className, fieldName);
    }

    @Override
    public EnumJavaType<?> getEnumType(String className) {
        return this.jpaMetamodel.getEnumType(className);
    }

    @Override
    public <E extends Enum<E>> E enumValue(EnumJavaType<E> enumType, String enumValueName) {
        return this.jpaMetamodel.enumValue(enumType, enumValueName);
    }

    @Override
    public String getImportedName(String name) {
        String qualifiedName = this.jpaMetamodel.qualifyImportableName(name);
        return qualifiedName == null ? name : qualifiedName;
    }

    @Override
    public void forEachCollectionDescriptor(Consumer<CollectionPersister> action) {
        this.collectionPersisterMap.values().forEach(action);
    }

    @Override
    @Deprecated(forRemoval=true)
    public Stream<CollectionPersister> streamCollectionDescriptors() {
        return this.collectionPersisterMap.values().stream();
    }

    @Override
    public CollectionPersister getCollectionDescriptor(String role) {
        CollectionPersister collectionPersister = this.collectionPersisterMap.get(role);
        if (collectionPersister == null) {
            throw new IllegalArgumentException("Unable to locate persister: " + role);
        }
        return collectionPersister;
    }

    @Override
    public CollectionPersister getCollectionDescriptor(NavigableRole role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CollectionPersister findCollectionDescriptor(NavigableRole role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CollectionPersister findCollectionDescriptor(String role) {
        return this.collectionPersisterMap.get(role);
    }

    @Override
    public void addNamedEntityGraph(String graphName, RootGraph<?> entityGraph) {
        this.jpaMetamodel.addNamedEntityGraph(graphName, entityGraph);
    }

    @Override
    public RootGraph<?> findEntityGraphByName(String name) {
        return this.jpaMetamodel.findEntityGraphByName(name);
    }

    @Override
    public <T> Map<String, EntityGraph<? extends T>> getNamedEntityGraphs(Class<T> entityType) {
        return this.jpaMetamodel.getNamedEntityGraphs(entityType);
    }

    @Override
    public <T> List<RootGraph<? super T>> findEntityGraphsByJavaType(Class<T> entityClass) {
        return this.jpaMetamodel.findEntityGraphsByJavaType(entityClass);
    }

    @Override
    public RootGraph<?> findNamedGraph(String name) {
        return this.findEntityGraphByName(name);
    }

    @Override
    public void forEachNamedGraph(Consumer<RootGraph<?>> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RootGraph<?> defaultGraph(String entityName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RootGraph<?> defaultGraph(Class<?> entityJavaType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RootGraph<?> defaultGraph(EntityPersister entityDescriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RootGraph<?> defaultGraph(EntityDomainType<?> entityDomainType) {
        return null;
    }

    @Override
    public List<RootGraph<?>> findRootGraphsForType(Class<?> baseEntityJavaType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RootGraph<?>> findRootGraphsForType(String baseEntityName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RootGraph<?>> findRootGraphsForType(EntityPersister baseEntityDescriptor) {
        return null;
    }

    @Override
    public MappingModelExpressible<?> resolveMappingExpressible(SqmExpressible<?> sqmExpressible, Function<NavigablePath, TableGroup> tableGroupLocator) {
        if (sqmExpressible instanceof SqmPath) {
            SqmPath sqmPath = (SqmPath)((Object)sqmExpressible);
            DomainType domainType = sqmPath.getResolvedModel().getPathType();
            if (domainType instanceof MappingModelExpressible) {
                MappingModelExpressible mappingExpressible = (MappingModelExpressible)((Object)domainType);
                return mappingExpressible;
            }
            NavigablePath navigablePath = sqmPath.getNavigablePath();
            if (navigablePath.getParent() != null) {
                TableGroup parentTableGroup = tableGroupLocator.apply(navigablePath.getParent());
                return parentTableGroup.getModelPart().findSubPart(navigablePath.getLocalName(), null);
            }
            return tableGroupLocator.apply(navigablePath.getParent()).getModelPart();
        }
        if (sqmExpressible instanceof BasicType) {
            BasicType basicType = (BasicType)sqmExpressible;
            return basicType;
        }
        if (sqmExpressible instanceof BasicDomainType) {
            return this.getTypeConfiguration().getBasicTypeForJavaType(sqmExpressible.getRelationalJavaType().getJavaType());
        }
        if (sqmExpressible instanceof BasicSqmPathSource || sqmExpressible instanceof AnonymousTupleSimpleSqmPathSource) {
            return this.resolveMappingExpressible(sqmExpressible.getSqmType(), tableGroupLocator);
        }
        if (sqmExpressible instanceof SqmFieldLiteral) {
            SqmFieldLiteral sqmFieldLiteral = (SqmFieldLiteral)sqmExpressible;
            return this.getTypeConfiguration().getBasicTypeForJavaType(sqmFieldLiteral.getJavaType());
        }
        if (sqmExpressible instanceof CompositeSqmPathSource) {
            throw new UnsupportedOperationException("Resolution of embedded-valued SqmExpressible nodes not yet implemented");
        }
        if (sqmExpressible instanceof AnonymousTupleSqmPathSource) {
            AnonymousTupleSqmPathSource anonymousTupleSqmPathSource = (AnonymousTupleSqmPathSource)sqmExpressible;
            return this.resolveMappingExpressible(this.resolveExpressible((jakarta.persistence.metamodel.Type)anonymousTupleSqmPathSource.getPathType()), tableGroupLocator);
        }
        if (sqmExpressible instanceof EmbeddableTypeImpl) {
            return (MappingModelExpressible)((Object)sqmExpressible);
        }
        if (sqmExpressible instanceof EntityDomainType) {
            EntityDomainType entityDomainType = (EntityDomainType)((Object)sqmExpressible);
            return this.getEntityDescriptor(entityDomainType.getHibernateEntityName());
        }
        if (sqmExpressible instanceof TupleType) {
            TupleType tupleType = (TupleType)((Object)sqmExpressible);
            MappingModelExpressible<?> mappingModelExpressible = this.tupleTypeCache.get(sqmExpressible);
            if (mappingModelExpressible != null) {
                return mappingModelExpressible;
            }
            MappingModelExpressible[] components = new MappingModelExpressible[tupleType.componentCount()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = this.resolveMappingExpressible(tupleType.get(i), tableGroupLocator);
            }
            TupleMappingModelExpressible createdMappingModelExpressible = new TupleMappingModelExpressible(components);
            MappingModelExpressible existingMappingModelExpressible = this.tupleTypeCache.putIfAbsent(tupleType, createdMappingModelExpressible);
            return existingMappingModelExpressible == null ? createdMappingModelExpressible : existingMappingModelExpressible;
        }
        return null;
    }

    @Override
    public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.collectionRolesByEntityParticipant.get(entityName);
    }

    @Override
    public Collection<EntityNameResolver> getEntityNameResolvers() {
        return this.entityNameResolvers;
    }

    @Override
    public String[] getAllEntityNames() {
        return this.entityPersisterMap.keys();
    }

    @Override
    public String[] getAllCollectionRoles() {
        return ArrayHelper.toStringArray(this.collectionPersisterMap.keySet());
    }

    @Override
    public <T> BindableType<T> resolveParameterBindType(Class<T> javaType) {
        JavaType resolvedJavaType;
        JdbcType recommendedJdbcType;
        JdbcType recommendedJdbcType2;
        TypeConfiguration typeConfiguration = this.getTypeConfiguration();
        BasicType<T> basicType = typeConfiguration.getBasicTypeForJavaType(javaType);
        if (basicType != null || javaType.isEnum()) {
            return basicType;
        }
        ManagedDomainType<T> managedType = this.jpaMetamodel.findManagedType(javaType);
        if (managedType != null) {
            return (BindableType)((Object)managedType);
        }
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        JavaType javaType1 = javaTypeRegistry.findDescriptor(javaType);
        if (javaType1 != null && (recommendedJdbcType2 = javaType1.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators())) != null) {
            return typeConfiguration.getBasicTypeRegistry().resolve(javaType1, recommendedJdbcType2);
        }
        if (javaType.isArray() && javaTypeRegistry.findDescriptor(javaType.getComponentType()) != null && (recommendedJdbcType = (resolvedJavaType = javaTypeRegistry.resolveDescriptor(javaType)).getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators())) != null) {
            return typeConfiguration.getBasicTypeRegistry().resolve(resolvedJavaType, recommendedJdbcType);
        }
        return null;
    }

    @Override
    public <T> BindableType<? super T> resolveParameterBindType(T bindValue) {
        Class<T> clazz;
        if (bindValue == null) {
            return null;
        }
        Class<T> c = clazz = MappingMetamodelImpl.unproxiedClass(bindValue);
        do {
            BindableType<Class<T>> type;
            if ((type = this.resolveParameterBindType((T)c)) == null) continue;
            return type;
        } while ((c = c.getSuperclass()) != Object.class);
        if (clazz.isEnum()) {
            return null;
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            BindableType<Class<Serializable>> parameterBindType = this.resolveParameterBindType((T)Serializable.class);
            return parameterBindType;
        }
        return null;
    }

    private static <T> Class<T> unproxiedClass(T bindValue) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(bindValue);
        Class<?> result = lazyInitializer != null ? lazyInitializer.getPersistentClass() : bindValue.getClass();
        return result;
    }
}

