/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Internal;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

@Internal
public final class MessageHelper {
    private MessageHelper() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized String entityName, @Nullable @UnknownKeyFor @Initialized Object id) {
        StringBuilder info = new StringBuilder();
        info.append('[');
        if (entityName == null) {
            info.append("unknown entity name");
        } else {
            info.append(entityName);
        }
        if (id == null) {
            info.append(" with null id");
        } else {
            info.append(" with id '").append(id).append("'");
        }
        info.append(']');
        return info.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized EntityPersister persister, @Nullable @UnknownKeyFor @Initialized Object id, @Nullable @UnknownKeyFor @Initialized SessionFactoryImplementor factory) {
        Type idType;
        StringBuilder info = new StringBuilder();
        info.append('[');
        if (persister == null) {
            info.append("unknown entity");
            idType = null;
        } else {
            info.append(persister.getEntityName());
            idType = persister.getIdentifierType();
        }
        if (id == null) {
            info.append(" with null id");
        } else {
            info.append(" with id '");
            if (idType == null) {
                info.append(id);
            } else if (factory != null) {
                info.append(idType.toLoggableString(id, factory));
            } else {
                info.append("<not loggable>");
            }
            info.append("'");
        }
        info.append(']');
        return info.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized EntityPersister persister, @Nullable @UnknownKeyFor @Initialized Object id, @UnknownKeyFor @NonNull @Initialized Type identifierType, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        StringBuilder info = new StringBuilder();
        info.append('[');
        if (persister == null) {
            info.append("unknown entity");
        } else {
            info.append(persister.getEntityName());
        }
        if (id == null) {
            info.append(" with null id");
        } else {
            info.append(" with id '").append(identifierType.toLoggableString(id, factory)).append("'");
        }
        info.append(']');
        return info.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized EntityPersister persister, @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] ids, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        StringBuilder info = new StringBuilder();
        info.append('[');
        if (persister == null) {
            info.append("unknown entity");
        } else {
            info.append(persister.getEntityName());
            info.append(" with ids ");
            for (int i = 0; i < ids.length; ++i) {
                info.append("'").append(persister.getIdentifierType().toLoggableString(ids[i], factory)).append("'");
                if (i >= ids.length - 1) continue;
                info.append(", ");
            }
        }
        info.append(']');
        return info.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized EntityPersister persister) {
        StringBuilder info = new StringBuilder();
        info.append('[');
        if (persister == null) {
            info.append("unknown entity");
        } else {
            info.append(persister.getEntityName());
        }
        info.append(']');
        return info.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String propertyName, @Nullable @UnknownKeyFor @Initialized Object key) {
        StringBuilder info = new StringBuilder().append('[').append(entityName).append('.').append(propertyName);
        if (key == null) {
            info.append(" with null owner id");
        } else {
            info.append(" with owner id '").append(key).append("'");
        }
        info.append(']');
        return info.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String collectionInfoString(@Nullable @UnknownKeyFor @Initialized CollectionPersister persister, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection, @UnknownKeyFor @NonNull @Initialized Object collectionKey, @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor session) {
        StringBuilder info = new StringBuilder();
        info.append('[');
        if (persister == null) {
            info.append("unreferenced collection");
        } else {
            Object ownerKey;
            info.append(persister.getRole());
            Type ownerIdentifierType = persister.getOwnerEntityPersister().getIdentifierType();
            if (collectionKey.getClass().isAssignableFrom(ownerIdentifierType.getReturnedClass())) {
                ownerKey = collectionKey;
            } else {
                Object collectionOwner = collection == null ? null : collection.getOwner();
                EntityEntry entry = collectionOwner == null ? null : session.getPersistenceContextInternal().getEntry(collectionOwner);
                ownerKey = entry == null ? null : entry.getId();
            }
            info.append(" with owner id '").append(ownerIdentifierType.toLoggableString(ownerKey, session.getFactory())).append("'");
        }
        info.append(']');
        return info.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String collectionInfoString(@Nullable @UnknownKeyFor @Initialized CollectionPersister persister, @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] ids, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        StringBuilder info = new StringBuilder();
        info.append('[');
        if (persister == null) {
            info.append("unreferenced collection");
        } else {
            info.append(persister.getRole());
            info.append(" with owner ids ");
            for (int i = 0; i < ids.length; ++i) {
                info.append("'");
                MessageHelper.addIdToCollectionInfoString(persister, ids[i], factory, info);
                info.append("'");
                if (i >= ids.length - 1) continue;
                info.append(", ");
            }
        }
        info.append(']');
        return info.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String collectionInfoString(@Nullable @UnknownKeyFor @Initialized CollectionPersister persister, @Nullable @UnknownKeyFor @Initialized Object id, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        StringBuilder info = new StringBuilder();
        info.append('[');
        if (persister == null) {
            info.append("unreferenced collection");
        } else {
            info.append(persister.getRole());
            if (id == null) {
                info.append(" with null owner id");
            } else {
                info.append(" with owner id '");
                MessageHelper.addIdToCollectionInfoString(persister, id, factory, info);
                info.append("'");
            }
        }
        info.append(']');
        return info.toString();
    }

    private static void addIdToCollectionInfoString(@UnknownKeyFor @NonNull @Initialized CollectionPersister persister, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory, @UnknownKeyFor @NonNull @Initialized StringBuilder s) {
        Type ownerIdentifierType = persister.getOwnerEntityPersister().getIdentifierType();
        if (id.getClass().isAssignableFrom(ownerIdentifierType.getReturnedClass())) {
            s.append(ownerIdentifierType.toLoggableString(id, factory));
        } else {
            s.append(id);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String collectionInfoString(@Nullable @UnknownKeyFor @Initialized String role, @Nullable @UnknownKeyFor @Initialized Object id) {
        StringBuilder info = new StringBuilder();
        info.append('[');
        if (role == null) {
            info.append("unreferenced collection");
        } else {
            info.append(role);
            if (id == null) {
                info.append(" with null owner id");
            } else {
                info.append(" with owner id '").append(id).append("'");
            }
        }
        info.append(']');
        return info.toString();
    }
}

