/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TemporalType;
import jakarta.persistence.metamodel.Type;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.NoSuchParameterException;
import org.hibernate.procedure.ParameterStrategyException;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.procedure.ProcedureParameter;
import org.hibernate.procedure.internal.FunctionReturnImpl;
import org.hibernate.procedure.internal.NamedCallableQueryMementoImpl;
import org.hibernate.procedure.internal.ProcedureOutputsImpl;
import org.hibernate.procedure.internal.ProcedureParamBindings;
import org.hibernate.procedure.internal.ProcedureParameterImpl;
import org.hibernate.procedure.internal.ProcedureParameterMetadataImpl;
import org.hibernate.procedure.internal.ScalarDomainResultBuilder;
import org.hibernate.procedure.internal.Util;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.KeyedPage;
import org.hibernate.query.KeyedResultList;
import org.hibernate.query.Query;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.spi.AbstractQuery;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.result.Output;
import org.hibernate.result.ResultSetOutput;
import org.hibernate.result.UpdateCountOutput;
import org.hibernate.result.internal.OutputsExecutionContext;
import org.hibernate.result.spi.ResultContext;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcCallRefCursorExtractor;
import org.hibernate.sql.exec.spi.JdbcOperationQueryCall;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.results.NoMoreOutputsException;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindableType;
import org.hibernate.type.OutputableType;

public class ProcedureCallImpl<R>
extends AbstractQuery<R>
implements ProcedureCallImplementor<R>,
ResultContext {
    private final String procedureName;
    private FunctionReturnImpl<R> functionReturn;
    private final ProcedureParameterMetadataImpl parameterMetadata;
    private final ProcedureParamBindings parameterBindings;
    private final ResultSetMapping resultSetMapping;
    private Set<String> synchronizedQuerySpaces;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();
    private ProcedureOutputsImpl outputs;
    private ProcedureOutputs procedureResult;

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName) {
        super(session);
        this.procedureName = procedureName;
        this.parameterMetadata = new ProcedureParameterMetadataImpl();
        this.parameterBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.resultSetMapping = ResultSetMapping.resolveResultSetMapping(procedureName, true, session.getSessionFactory());
        this.synchronizedQuerySpaces = null;
    }

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName, Class<?> ... resultClasses) {
        super(session);
        assert (resultClasses != null && resultClasses.length > 0);
        this.procedureName = procedureName;
        this.parameterMetadata = new ProcedureParameterMetadataImpl();
        this.parameterBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = new HashSet<String>();
        String mappingId = procedureName + ":" + StringHelper.join(",", resultClasses);
        this.resultSetMapping = ResultSetMapping.resolveResultSetMapping(mappingId, session.getSessionFactory());
        Util.resolveResultSetMappingClasses(resultClasses, this.resultSetMapping, this.synchronizedQuerySpaces::add, this::getSessionFactory);
    }

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName, String ... resultSetMappingNames) {
        super(session);
        assert (resultSetMappingNames != null && resultSetMappingNames.length > 0);
        this.procedureName = procedureName;
        this.parameterMetadata = new ProcedureParameterMetadataImpl();
        this.parameterBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = new HashSet<String>();
        String mappingId = procedureName + ":" + StringHelper.join(",", resultSetMappingNames);
        this.resultSetMapping = ResultSetMapping.resolveResultSetMapping(mappingId, session.getSessionFactory());
        Util.resolveResultSetMappingNames(resultSetMappingNames, this.resultSetMapping, this.synchronizedQuerySpaces::add, this::getSessionFactory);
    }

    ProcedureCallImpl(SharedSessionContractImplementor session, NamedCallableQueryMemento memento) {
        super(session);
        this.procedureName = memento.getCallableName();
        this.parameterMetadata = new ProcedureParameterMetadataImpl(memento, session);
        this.parameterBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = CollectionHelper.makeCopy(memento.getQuerySpaces());
        this.resultSetMapping = ResultSetMapping.resolveResultSetMapping(memento.getRegistrationName(), session.getSessionFactory());
        Util.resolveResultSetMappings(memento.getResultSetMappingNames(), memento.getResultSetMappingClasses(), this.resultSetMapping, this.synchronizedQuerySpaces::add, this::getSessionFactory);
        this.applyOptions(memento);
    }

    ProcedureCallImpl(SharedSessionContractImplementor session, NamedCallableQueryMemento memento, Class<?> ... resultTypes) {
        super(session);
        this.procedureName = memento.getCallableName();
        this.parameterMetadata = new ProcedureParameterMetadataImpl(memento, session);
        this.parameterBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = CollectionHelper.makeCopy(memento.getQuerySpaces());
        String mappingId = this.procedureName + ":" + StringHelper.join(",", resultTypes);
        this.resultSetMapping = ResultSetMapping.resolveResultSetMapping(mappingId, session.getSessionFactory());
        Util.resolveResultSetMappings(null, resultTypes, this.resultSetMapping, this.synchronizedQuerySpaces::add, this::getSessionFactory);
        this.applyOptions(memento);
    }

    public ProcedureCallImpl(SharedSessionContractImplementor session, NamedCallableQueryMementoImpl memento, String ... resultSetMappingNames) {
        super(session);
        this.procedureName = memento.getCallableName();
        this.parameterMetadata = new ProcedureParameterMetadataImpl(memento, session);
        this.parameterBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = CollectionHelper.makeCopy(memento.getQuerySpaces());
        String mappingId = this.procedureName + ":" + StringHelper.join(",", resultSetMappingNames);
        this.resultSetMapping = ResultSetMapping.resolveResultSetMapping(mappingId, session.getSessionFactory());
        Util.resolveResultSetMappings(resultSetMappingNames, null, this.resultSetMapping, this.synchronizedQuerySpaces::add, this::getSessionFactory);
        this.applyOptions(memento);
    }

    private void applyCallableFunctionHint() {
        ArrayList resultTypes = new ArrayList();
        this.resultSetMapping.visitResultBuilders((index, resultBuilder) -> resultTypes.add(resultBuilder.getJavaType()));
        if (resultTypes.size() == 1) {
            BasicType type = this.getTypeConfiguration().getBasicTypeForJavaType((Class)resultTypes.get(0));
            if (type != null) {
                this.markAsFunctionCall(type);
            } else {
                this.markAsFunctionCallRefRefCursor();
            }
        } else {
            this.markAsFunctionCallRefRefCursor();
        }
    }

    @Override
    public String getProcedureName() {
        return this.procedureName;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public ProcedureParameterMetadataImpl getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public ParameterStrategy getParameterStrategy() {
        return this.getParameterMetadata().getParameterStrategy();
    }

    @Override
    public boolean isFunctionCall() {
        return this.functionReturn != null;
    }

    @Override
    public FunctionReturnImplementor<R> getFunctionReturn() {
        return this.functionReturn;
    }

    @Override
    public ProcedureCallImplementor<R> markAsFunctionCall(int sqlType) {
        this.functionReturn = new FunctionReturnImpl(this, sqlType);
        return this;
    }

    private void markAsFunctionCallRefRefCursor() {
        this.functionReturn = new FunctionReturnImpl(this, 2012);
    }

    @Override
    public ProcedureCallImpl<R> markAsFunctionCall(Class<?> resultType) {
        BasicType<?> basicType = this.getTypeConfiguration().getBasicTypeForJavaType(resultType);
        if (basicType == null) {
            throw new IllegalArgumentException("Could not resolve a BasicType for the java type: " + resultType.getName());
        }
        this.markAsFunctionCall(basicType);
        return this;
    }

    @Override
    public ProcedureCall markAsFunctionCall(Type<?> typeReference) {
        if (!(typeReference instanceof OutputableType)) {
            throw new IllegalArgumentException("Given type is not an OutputableType: " + String.valueOf(typeReference));
        }
        OutputableType outputableType = (OutputableType)typeReference;
        if (this.resultSetMapping.getNumberOfResultBuilders() == 0) {
            SqmBindableType<?> expressible = this.resolveExpressible(typeReference);
            this.resultSetMapping.addResultBuilder(new ScalarDomainResultBuilder(expressible.getExpressibleJavaType()));
        }
        this.functionReturn = new FunctionReturnImpl(this, outputableType);
        return this;
    }

    private void markAsFunctionCall(BasicType<?> basicType) {
        if (this.resultSetMapping.getNumberOfResultBuilders() == 0) {
            this.resultSetMapping.addResultBuilder(new ScalarDomainResultBuilder(basicType.getExpressibleJavaType()));
        }
        this.functionReturn = new FunctionReturnImpl(this, basicType);
    }

    @Override
    public QueryParameterBindings getParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(int position, Class<?> type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(position, type, mode);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(String parameterName, Class<?> type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(parameterName, (Class)type, mode);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(int position, Type<?> type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(position, type, mode);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(String parameterName, Type<?> type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(parameterName, (Type)type, mode);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public <T> ProcedureParameter<T> registerParameter(int position, Class<T> javaType, ParameterMode mode) {
        BindableType parameterType = this.getSessionFactory().getMappingMetamodel().resolveParameterBindType(javaType);
        ProcedureParameterImpl<T> procedureParameter = new ProcedureParameterImpl<T>(position, mode, this.getExpressibleJavaType(parameterType), parameterType);
        this.registerParameter(procedureParameter);
        return procedureParameter;
    }

    @Override
    public <T> ProcedureParameter<T> registerParameter(int position, Type<T> typeReference, ParameterMode mode) {
        SqmBindableType<T> expressible = this.resolveExpressible(typeReference);
        ProcedureParameterImpl<T> procedureParameter = new ProcedureParameterImpl<T>(position, mode, typeReference.getJavaType(), expressible);
        this.registerParameter(procedureParameter);
        return procedureParameter;
    }

    private <T> SqmBindableType<T> resolveExpressible(Type<T> typeReference) {
        return this.getSessionFactory().getRuntimeMetamodels().resolveExpressible(typeReference);
    }

    private void registerParameter(ProcedureParameterImplementor<?> parameter) {
        this.getParameterMetadata().registerParameter(parameter);
    }

    public ProcedureParameterImplementor<?> getParameterRegistration(int position) {
        return this.getParameterMetadata().getQueryParameter(position);
    }

    public <T> ProcedureParameterImplementor<T> registerParameter(String name, Class<T> javaType, ParameterMode mode) {
        BindableType parameterType = this.getSessionFactory().getMappingMetamodel().resolveParameterBindType(javaType);
        ProcedureParameterImpl<T> parameter = new ProcedureParameterImpl<T>(name, mode, this.getExpressibleJavaType(parameterType), parameterType);
        this.registerParameter(parameter);
        return parameter;
    }

    private <T> Class<T> getExpressibleJavaType(Type<T> parameterType) {
        if (parameterType == null) {
            return null;
        }
        SqmBindableType sqmExpressible = this.getNodeBuilder().resolveExpressible(parameterType);
        assert (sqmExpressible != null);
        return sqmExpressible.getExpressibleJavaType().getJavaTypeClass();
    }

    private NodeBuilder getNodeBuilder() {
        return this.getSessionFactory().getQueryEngine().getCriteriaBuilder();
    }

    public <T> ProcedureParameterImplementor<T> registerParameter(String name, Type<T> typeReference, ParameterMode mode) {
        SqmBindableType<T> expressible = this.resolveExpressible(typeReference);
        ProcedureParameterImpl<T> parameter = new ProcedureParameterImpl<T>(name, mode, typeReference.getJavaType(), expressible);
        this.registerParameter(parameter);
        return parameter;
    }

    public ProcedureParameterImplementor<?> getParameterRegistration(String name) {
        return this.getParameterMetadata().getQueryParameter(name);
    }

    @Override
    public List<ProcedureParameter<?>> getRegisteredParameters() {
        return Collections.unmodifiableList(this.getParameterMetadata().getRegistrationsAsList());
    }

    @Override
    public ProcedureOutputs getOutputs() {
        if (this.outputs == null) {
            this.outputs = this.buildOutputs();
        }
        return this.outputs;
    }

    private ProcedureOutputsImpl buildOutputs() {
        JdbcServices jdbcServices = this.getSession().getJdbcServices();
        CallableStatementSupport callableStatementSupport = jdbcServices.getJdbcEnvironment().getDialect().getCallableStatementSupport();
        JdbcOperationQueryCall call = callableStatementSupport.interpretCall(this);
        IdentityHashMap parameterRegistrations = new IdentityHashMap();
        ArrayList<JdbcCallRefCursorExtractorImpl> refCursorExtractors = new ArrayList<JdbcCallRefCursorExtractorImpl>();
        if (call.getFunctionReturn() != null) {
            parameterRegistrations.put(this.functionReturn, call.getFunctionReturn());
            JdbcCallRefCursorExtractorImpl refCursorExtractor = call.getFunctionReturn().getRefCursorExtractor();
            if (refCursorExtractor != null) {
                refCursorExtractors.add(refCursorExtractor);
            }
        }
        List<ProcedureParameterImplementor<?>> registrations = this.getParameterMetadata().getRegistrationsAsList();
        List<JdbcCallParameterRegistration> jdbcParameters = call.getParameterRegistrations();
        for (int i = 0; i < registrations.size(); ++i) {
            JdbcCallParameterRegistration jdbcCallParameterRegistration = jdbcParameters.get(i);
            parameterRegistrations.put((ProcedureParameter)registrations.get(i), jdbcCallParameterRegistration);
            JdbcCallRefCursorExtractorImpl refCursorExtractor = jdbcCallParameterRegistration.getRefCursorExtractor();
            if (refCursorExtractor == null) continue;
            refCursorExtractors.add(refCursorExtractor);
        }
        JdbcCoordinator jdbcCoordinator = this.getSession().getJdbcCoordinator();
        String sqlString = call.getSqlString();
        CallableStatement statement = jdbcCoordinator.getStatementPreparer().prepareCallableStatement(sqlString);
        try {
            callableStatementSupport.registerParameters(this.procedureName, call, statement, this.parameterMetadata, (SharedSessionContractImplementor)this.getSession());
            JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(parameterRegistrations.size());
            for (Map.Entry entry : parameterRegistrations.entrySet()) {
                JdbcCallParameterRegistration registration = (JdbcCallParameterRegistration)entry.getValue();
                if (registration.getParameterBinder() == null) continue;
                ProcedureParameter parameter = (ProcedureParameter)entry.getKey();
                QueryParameterBinding binding = this.getParameterBindings().getBinding(parameter);
                if (!binding.isBound()) {
                    if (parameter.getPosition() == null) {
                        throw new IllegalArgumentException("The parameter named [" + String.valueOf(parameter) + "] was not set! You need to call the setParameter method.");
                    }
                    throw new IllegalArgumentException("The parameter at position [" + String.valueOf(parameter) + "] was not set! You need to call the setParameter method.");
                }
                JdbcMapping parameterType = (JdbcMapping)((Object)registration.getParameterType());
                jdbcParameterBindings.addBinding((JdbcParameter)((Object)registration.getParameterBinder()), new JdbcParameterBindingImpl(parameterType, parameterType.convertToRelationalValue(binding.getBindValue())));
            }
            OutputsExecutionContext executionContext = new OutputsExecutionContext((SharedSessionContractImplementor)this.getSession());
            int paramBindingPosition = call.getFunctionReturn() == null ? 1 : 2;
            for (JdbcParameterBinder parameterBinder : call.getParameterBinders()) {
                parameterBinder.bindParameterValue(statement, paramBindingPosition, jdbcParameterBindings, executionContext);
                ++paramBindingPosition;
            }
        }
        catch (SQLException e) {
            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(statement);
            this.getSession().getJdbcCoordinator().afterStatementExecution();
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Error registering CallableStatement parameters", this.procedureName);
        }
        return new ProcedureOutputsImpl(this, parameterRegistrations, refCursorExtractors.toArray(new JdbcCallRefCursorExtractor[0]), statement, sqlString);
    }

    @Override
    public String getQueryString() {
        return null;
    }

    protected Set<String> synchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            this.synchronizedQuerySpaces = new HashSet<String>();
        }
        return this.synchronizedQuerySpaces;
    }

    @Override
    public Set<String> getSynchronizedQuerySpaces() {
        return this.synchronizedQuerySpaces == null ? Collections.emptySet() : Collections.unmodifiableSet(this.synchronizedQuerySpaces);
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedQuerySpace(String querySpace) {
        this.synchronizedQuerySpaces().add(querySpace);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedEntityName(String entityName) {
        EntityPersister entityDescriptor = this.getSessionFactory().getMappingMetamodel().getEntityDescriptor(entityName);
        this.addSynchronizedQuerySpaces(entityDescriptor);
        return this;
    }

    protected void addSynchronizedQuerySpaces(EntityPersister persister) {
        this.synchronizedQuerySpaces().addAll(Arrays.asList((String[])persister.getQuerySpaces()));
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedEntityClass(Class entityClass) {
        EntityPersister entityDescriptor = this.getSessionFactory().getMappingMetamodel().getEntityDescriptor(entityClass);
        this.addSynchronizedQuerySpaces(entityDescriptor);
        return this;
    }

    @Override
    public NamedCallableQueryMemento toMemento(String name) {
        return new NamedCallableQueryMementoImpl(name, this.procedureName, this.getParameterStrategy(), ProcedureCallImpl.toParameterMementos(this.parameterMetadata), null, null, (Set<String>)this.getSynchronizedQuerySpaces(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getQueryOptions().getFlushMode(), this.isReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    private static List<NamedCallableQueryMemento.ParameterMemento> toParameterMementos(ProcedureParameterMetadataImpl parameterMetadata) {
        if (parameterMetadata.getParameterStrategy() == ParameterStrategy.UNKNOWN) {
            return Collections.emptyList();
        }
        ArrayList<NamedCallableQueryMemento.ParameterMemento> mementos = new ArrayList<NamedCallableQueryMemento.ParameterMemento>();
        parameterMetadata.visitRegistrations(queryParameter -> mementos.add(NamedCallableQueryMementoImpl.ParameterMementoImpl.fromRegistration((ProcedureParameterImplementor)queryParameter)));
        return mementos;
    }

    @Override
    protected void applyGraph(RootGraphImplementor<?> entityGraph, GraphSemantic graphSemantic) {
        throw new IllegalStateException("EntityGraph hints are not supported for ProcedureCall/StoredProcedureQuery");
    }

    @Override
    public Query<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        throw new IllegalStateException("EntityGraph hints are not supported for ProcedureCall/StoredProcedureQuery");
    }

    public boolean execute() {
        try {
            return this.outputs().getCurrent() instanceof ResultSetOutput;
        }
        catch (NoMoreOutputsException e) {
            return false;
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    protected ProcedureOutputs outputs() {
        if (this.procedureResult == null) {
            this.procedureResult = this.getOutputs();
        }
        return this.procedureResult;
    }

    @Override
    protected int doExecuteUpdate() {
        try {
            this.execute();
            int n = this.getUpdateCount();
            return n;
        }
        finally {
            this.outputs().release();
        }
    }

    public Object getOutputParameterValue(int position) {
        try {
            return this.outputs().getOutputParameterValue(position);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", (Throwable)((Object)e));
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public Object getOutputParameterValue(String parameterName) {
        try {
            return this.outputs().getOutputParameterValue(parameterName);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", (Throwable)((Object)e));
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public boolean hasMoreResults() {
        return this.outputs().goToNext() && this.outputs().getCurrent() instanceof ResultSetOutput;
    }

    public int getUpdateCount() {
        try {
            Output rtn = this.outputs().getCurrent();
            if (rtn == null) {
                return -1;
            }
            if (rtn instanceof UpdateCountOutput) {
                UpdateCountOutput updateCount = (UpdateCountOutput)rtn;
                return updateCount.getUpdateCount();
            }
            return -1;
        }
        catch (NoMoreOutputsException e) {
            return -1;
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    @Override
    protected List<R> doList() {
        if (this.getMaxResults() == 0) {
            return Collections.emptyList();
        }
        try {
            Output output = this.outputs().getCurrent();
            if (output instanceof ResultSetOutput) {
                ResultSetOutput resultSetOutput = (ResultSetOutput)output;
                return resultSetOutput.getResultList();
            }
            throw new IllegalStateException("Current CallableStatement was not a ResultSet, but getResultList was called");
        }
        catch (NoMoreOutputsException e) {
            return null;
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    @Override
    public long getResultCount() {
        throw new UnsupportedOperationException("getResultCount() not implemented for ProcedureCall/StoredProcedureQuery");
    }

    @Override
    public KeyedResultList<R> getKeyedResultList(KeyedPage<R> page) {
        throw new UnsupportedOperationException("getKeyedResultList() not implemented for ProcedureCall/StoredProcedureQuery");
    }

    @Override
    public ScrollableResultsImplementor<R> scroll(ScrollMode scrollMode) {
        throw new UnsupportedOperationException("scroll() is not implemented for ProcedureCall/StoredProcedureQuery");
    }

    @Override
    protected ScrollableResultsImplementor<R> doScroll(ScrollMode scrollMode) {
        throw new UnsupportedOperationException("scroll() is not implemented for ProcedureCall/StoredProcedureQuery");
    }

    @Override
    public List<R> getResultList() {
        return this.doList();
    }

    @Override
    public R getSingleResult() {
        List<R> resultList = this.getResultList();
        if (resultList == null || resultList.isEmpty()) {
            throw new NoResultException(String.format("Call to stored procedure [%s] returned no results", this.getProcedureName()));
        }
        if (resultList.size() > 1) {
            throw new NonUniqueResultException(String.format("Call to stored procedure [%s] returned multiple results", this.getProcedureName()));
        }
        return resultList.get(0);
    }

    @Override
    public R getSingleResultOrNull() {
        List<R> resultList = this.getResultList();
        if (resultList == null || resultList.isEmpty()) {
            return null;
        }
        if (resultList.size() > 1) {
            throw new NonUniqueResultException(String.format("Call to stored procedure [%s] returned multiple results", this.getProcedureName()));
        }
        return resultList.get(0);
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        if (type.isInstance(this.parameterMetadata)) {
            return type.cast(this.parameterMetadata);
        }
        if (type.isInstance(this.parameterBindings)) {
            return type.cast(this.parameterBindings);
        }
        if (type.isInstance(this.getQueryOptions())) {
            return type.cast(this.getQueryOptions());
        }
        if (type.isInstance(this.getQueryOptions().getAppliedGraph())) {
            return type.cast(this.getQueryOptions().getAppliedGraph());
        }
        if (type.isInstance(this.getSession())) {
            return type.cast(this.getSession());
        }
        if (type.isInstance(this.getOutputs())) {
            return type.cast(this.getOutputs());
        }
        throw new PersistenceException("Unrecognized unwrap type [" + type.getName() + "]");
    }

    @Override
    public QueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        throw new IllegalStateException("Illegal attempt to set lock mode for a procedure calls");
    }

    @Override
    public ProcedureCallImplementor<R> setLockMode(LockModeType lockMode) {
        throw new IllegalStateException("Illegal attempt to set lock mode for a procedure calls");
    }

    @Override
    public ProcedureCallImplementor<R> setTimeout(Integer timeout) {
        if (timeout == null) {
            timeout = -1;
        }
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public LockModeType getLockMode() {
        throw new IllegalStateException("Illegal attempt to get lock mode on a native-query");
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        throw new UnsupportedOperationException("setLockOptions does not apply to procedure calls");
    }

    @Override
    public ProcedureCallImplementor<R> setHint(String hintName, Object value) {
        switch (hintName) {
            case "org.hibernate.callableFunction": {
                if (value == null) break;
                if (value instanceof Boolean) {
                    Boolean bool = (Boolean)value;
                    if (!bool.booleanValue()) break;
                    this.applyCallableFunctionHint();
                    break;
                }
                if (!Boolean.parseBoolean(value.toString())) break;
                this.applyCallableFunctionHint();
                break;
            }
            case "hibernate.procedure.function_return_jdbc_type_code": {
                if (value == null) break;
                if (value instanceof Integer) {
                    Integer code = (Integer)value;
                    this.markAsFunctionCall(code);
                    break;
                }
                if (value instanceof Type) {
                    Type type = (Type)value;
                    this.markAsFunctionCall(type);
                    break;
                }
                if (value instanceof Class) {
                    Class type = (Class)value;
                    this.markAsFunctionCall(type);
                    break;
                }
                this.markAsFunctionCall(Integer.parseInt(value.toString()));
                break;
            }
            default: {
                super.setHint(hintName, value);
            }
        }
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value, Type<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Type)type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(String name, P value, Type<P> type) {
        super.setParameter(name, (Object)value, (Type)type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(int position, P value, Type<P> type) {
        super.setParameter(position, (Object)value, (Type)type);
        return this;
    }

    @Override
    @Deprecated
    public ProcedureCallImplementor<R> setParameter(Parameter<Calendar> parameter, Calendar value, TemporalType temporalPrecision) {
        super.setParameter((Parameter)parameter, value, temporalPrecision);
        return this;
    }

    @Override
    @Deprecated
    public ProcedureCallImplementor<R> setParameter(Parameter<Date> parameter, Date value, TemporalType temporalPrecision) {
        super.setParameter((Parameter)parameter, value, temporalPrecision);
        return this;
    }

    @Override
    @Deprecated
    public ProcedureCallImplementor<R> setParameter(String name, Calendar value, TemporalType temporalPrecision) {
        super.setParameter(name, value, temporalPrecision);
        return this;
    }

    @Override
    @Deprecated
    public ProcedureCallImplementor<R> setParameter(String name, Date value, TemporalType temporalPrecision) {
        super.setParameter(name, value, temporalPrecision);
        return this;
    }

    @Override
    @Deprecated
    public ProcedureCallImplementor<R> setParameter(int position, Calendar value, TemporalType temporalPrecision) {
        super.setParameter(position, value, temporalPrecision);
        return this;
    }

    @Override
    @Deprecated
    public ProcedureCallImplementor<R> setParameter(int position, Date value, TemporalType temporalPrecision) {
        super.setParameter(position, value, temporalPrecision);
        return this;
    }

    @Override
    public Stream<R> getResultStream() {
        return this.getResultList().stream();
    }

    @Override
    public Stream<R> stream() {
        return this.getResultStream();
    }

    public ResultSetMapping getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public ProcedureCallImplementor<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        return (ProcedureCallImplementor)super.setCacheRetrieveMode(cacheRetrieveMode);
    }

    @Override
    public ProcedureCallImplementor<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        return (ProcedureCallImplementor)super.setCacheStoreMode(cacheStoreMode);
    }
}

