/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Transient;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.ReflectHelper;

public class AccessStrategyHelper {
    public static final @UnknownKeyFor @NonNull @Initialized int COMPOSITE_TRACKER_MASK = 1;
    public static final @UnknownKeyFor @NonNull @Initialized int COMPOSITE_OWNER = 2;
    public static final @UnknownKeyFor @NonNull @Initialized int PERSISTENT_ATTRIBUTE_INTERCEPTABLE_MASK = 4;

    public static @Nullable @UnknownKeyFor @Initialized Field fieldOrNull(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        try {
            return ReflectHelper.findField(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized AccessType getAccessType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        Field field = AccessStrategyHelper.fieldOrNull(containerJavaType, propertyName);
        AccessType explicitAccessType = AccessStrategyHelper.getExplicitAccessType(containerJavaType, propertyName, field);
        if (explicitAccessType != null) {
            return explicitAccessType;
        }
        AccessType classAccessType = AccessStrategyHelper.getAccessTypeOrNull(containerJavaType);
        if (classAccessType != null) {
            return classAccessType;
        }
        return field != null ? AccessType.FIELD : AccessType.PROPERTY;
    }

    public static @Nullable @UnknownKeyFor @Initialized AccessType getExplicitAccessType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @Nullable @UnknownKeyFor @Initialized Field field) {
        if (ReflectHelper.isRecord(containerClass)) {
            try {
                containerClass.getMethod(propertyName, ReflectHelper.NO_PARAM_SIGNATURE);
                return AccessType.PROPERTY;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (field != null && field.isAnnotationPresent(Access.class) && !field.isAnnotationPresent(Transient.class) && !Modifier.isStatic(field.getModifiers())) {
            return AccessType.FIELD;
        }
        Method getter = ReflectHelper.getterMethodOrNull(containerClass, propertyName);
        if (getter != null && getter.isAnnotationPresent(Access.class)) {
            return AccessType.PROPERTY;
        }
        return null;
    }

    protected static @Nullable @UnknownKeyFor @Initialized AccessType getAccessTypeOrNull(@Nullable @UnknownKeyFor @Initialized AnnotatedElement element) {
        if (element == null) {
            return null;
        }
        Access elementAccess = element.getAnnotation(Access.class);
        return elementAccess == null ? null : elementAccess.value();
    }

    public static @UnknownKeyFor @NonNull @Initialized int determineEnhancementState(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> attributeType) {
        return (CompositeOwner.class.isAssignableFrom(containerClass) ? 2 : 0) | (CompositeTracker.class.isAssignableFrom(attributeType) ? 1 : 0) | (ManagedTypeHelper.isPersistentAttributeInterceptableType(containerClass) ? 4 : 0);
    }

    public static void handleEnhancedInjection(@UnknownKeyFor @NonNull @Initialized Object target, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized int enhancementState, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        PersistentAttributeInterceptor interceptor;
        if ((enhancementState & 2) != 0 && ((enhancementState & 1) != 0 && value != null || ManagedTypeHelper.isCompositeTracker(value))) {
            ManagedTypeHelper.asCompositeTracker(NullnessUtil.castNonNull(value)).$$_hibernate_setOwner(propertyName, ManagedTypeHelper.asCompositeOwner(target));
        }
        if ((enhancementState & 4) != 0 && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(target).$$_hibernate_getInterceptor()) instanceof BytecodeLazyAttributeInterceptor) {
            BytecodeLazyAttributeInterceptor lazyAttributeInterceptor = (BytecodeLazyAttributeInterceptor)interceptor;
            lazyAttributeInterceptor.attributeInitialized(propertyName);
        }
    }
}

