/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.AccessType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.AccessStrategyHelper;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessBuildingException;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class PropertyAccessGetterImpl
implements PropertyAccess {
    private final @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy strategy;
    private final @UnknownKeyFor @NonNull @Initialized Getter getter;

    public PropertyAccessGetterImpl(@UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy strategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        this.strategy = strategy;
        AccessType propertyAccessType = AccessStrategyHelper.getAccessType(containerJavaType, propertyName);
        switch (propertyAccessType) {
            case FIELD: {
                Field field = AccessStrategyHelper.fieldOrNull(containerJavaType, propertyName);
                if (field == null) {
                    throw new PropertyAccessBuildingException("Could not locate field for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                this.getter = PropertyAccessGetterImpl.fieldGetter(containerJavaType, propertyName, field);
                break;
            }
            case PROPERTY: {
                Method getterMethod = ReflectHelper.getterMethodOrNull(containerJavaType, propertyName);
                if (getterMethod == null) {
                    throw new PropertyAccessBuildingException("Could not locate getter for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                this.getter = PropertyAccessGetterImpl.propertyGetter(containerJavaType, propertyName, getterMethod);
                break;
            }
            default: {
                throw new PropertyAccessBuildingException("Invalid access type " + String.valueOf(propertyAccessType) + " for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Getter fieldGetter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Field field) {
        return new GetterFieldImpl(containerJavaType, propertyName, field);
    }

    private static @UnknownKeyFor @NonNull @Initialized Getter propertyGetter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method method) {
        return new GetterMethodImpl(containerJavaType, propertyName, method);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Getter getGetter() {
        return this.getter;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Setter getSetter() {
        return null;
    }
}

