/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Internal;
import org.hibernate.PropertyAccessException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccessSerializationException;

@Internal
public class GetterMethodImpl
implements Getter {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = CoreLogging.messageLogger(GetterMethodImpl.class);
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass;
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;
    private final @UnknownKeyFor @NonNull @Initialized Method getterMethod;

    public GetterMethodImpl(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method getterMethod) {
        this.containerClass = containerClass;
        this.propertyName = propertyName;
        this.getterMethod = getterMethod;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object get(@UnknownKeyFor @NonNull @Initialized Object owner) {
        try {
            return this.getterMethod.invoke(owner, ArrayHelper.EMPTY_OBJECT_ARRAY);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof Error) {
                Error error = (Error)cause;
                throw error;
            }
            throw new PropertyAccessException(cause, "Exception occurred inside", false, this.containerClass, this.propertyName);
        }
        catch (IllegalAccessException iae) {
            throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", false, this.containerClass, this.propertyName);
        }
        catch (IllegalArgumentException iae) {
            LOG.illegalPropertyGetterArgument(this.containerClass.getName(), this.propertyName);
            throw new PropertyAccessException(iae, "IllegalArgumentException occurred calling", false, this.containerClass, this.propertyName);
        }
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object getForInsert(@UnknownKeyFor @NonNull @Initialized Object owner, @UnknownKeyFor @NonNull @Initialized Map mergeMap, @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor session) {
        return this.get(owner);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getReturnTypeClass() {
        return this.getterMethod.getReturnType();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Type getReturnType() {
        return this.getterMethod.getGenericReturnType();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Member getMember() {
        return this.getterMethod;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMethodName() {
        return this.getterMethod.getName();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Method getMethod() {
        return this.getterMethod;
    }

    private @UnknownKeyFor @NonNull @Initialized Object writeReplace() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        return new SerialForm(this.containerClass, this.propertyName, this.getterMethod);
    }

    private static class SerialForm
    implements Serializable {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass;
        private final @UnknownKeyFor @NonNull @Initialized String propertyName;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> declaringClass;
        private final @UnknownKeyFor @NonNull @Initialized String methodName;

        private SerialForm(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method method) {
            this.containerClass = containerClass;
            this.propertyName = propertyName;
            this.declaringClass = method.getDeclaringClass();
            this.methodName = method.getName();
        }

        private @UnknownKeyFor @NonNull @Initialized Object readResolve() {
            return new GetterMethodImpl(this.containerClass, this.propertyName, this.resolveMethod());
        }

        private @UnknownKeyFor @NonNull @Initialized Method resolveMethod() {
            try {
                Method method = this.declaringClass.getDeclaredMethod(this.methodName, new Class[0]);
                ReflectHelper.ensureAccessibility(method);
                return method;
            }
            catch (NoSuchMethodException e) {
                throw new PropertyAccessSerializationException("Unable to resolve getter method on deserialization : " + this.declaringClass.getName() + "#" + this.methodName);
            }
        }
    }
}

