/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Internal;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertySetterAccessException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.property.access.internal.AbstractSetterMethodSerialForm;
import org.hibernate.property.access.spi.Setter;

@Internal
public class SetterMethodImpl
implements Setter {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = CoreLogging.messageLogger(SetterMethodImpl.class);
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass;
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;
    private final @UnknownKeyFor @NonNull @Initialized Method setterMethod;
    private final @UnknownKeyFor @NonNull @Initialized boolean isPrimitive;

    public SetterMethodImpl(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method setterMethod) {
        this.containerClass = containerClass;
        this.propertyName = propertyName;
        this.setterMethod = setterMethod;
        this.isPrimitive = setterMethod.getParameterTypes()[0].isPrimitive();
    }

    @Override
    public void set(@UnknownKeyFor @NonNull @Initialized Object target, @Nullable @UnknownKeyFor @Initialized Object value) {
        try {
            this.setterMethod.invoke(target, value);
        }
        catch (NullPointerException npe) {
            if (value == null && this.isPrimitive) {
                throw new PropertyAccessException(npe, "Null value was assigned to a property of primitive type", true, this.containerClass, this.propertyName);
            }
            throw new PropertyAccessException(npe, "NullPointerException occurred while calling", true, this.containerClass, this.propertyName);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof Error) {
                Error error = (Error)cause;
                throw error;
            }
            throw new PropertyAccessException(cause, "Exception occurred inside", true, this.containerClass, this.propertyName);
        }
        catch (IllegalAccessException iae) {
            throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", true, this.containerClass, this.propertyName);
        }
        catch (IllegalArgumentException iae) {
            if (value == null && this.isPrimitive) {
                throw new PropertyAccessException(iae, "Null value was assigned to a property of primitive type", true, this.containerClass, this.propertyName);
            }
            Class<?> expectedType = this.setterMethod.getParameterTypes()[0];
            LOG.illegalPropertySetterArgument(this.containerClass.getName(), this.propertyName);
            LOG.expectedType(expectedType.getName(), value == null ? null : value.getClass().getName());
            throw new PropertySetterAccessException(iae, this.containerClass, this.propertyName, expectedType, target, value);
        }
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getContainerClass() {
        return this.containerClass;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMethodName() {
        return this.setterMethod.getName();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Method getMethod() {
        return this.setterMethod;
    }

    private @UnknownKeyFor @NonNull @Initialized Object writeReplace() {
        return new SerialForm(this.containerClass, this.propertyName, this.setterMethod);
    }

    private static class SerialForm
    extends AbstractSetterMethodSerialForm
    implements Serializable {
        private SerialForm(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method method) {
            super(containerClass, propertyName, method);
        }

        private @UnknownKeyFor @NonNull @Initialized Object readResolve() {
            return new SetterMethodImpl(this.getContainerClass(), this.getPropertyName(), this.resolveMethod());
        }
    }
}

