/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.ModelPartResultMemento;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.internal.implicit.ImplicitModelPartResultBuilderBasic;
import org.hibernate.query.results.internal.implicit.ImplicitModelPartResultBuilderEmbeddable;
import org.hibernate.query.results.internal.implicit.ImplicitModelPartResultBuilderEntity;
import org.hibernate.spi.NavigablePath;

public class ImplicitModelPartResultMemento
implements ModelPartResultMemento {
    private final NavigablePath navigablePath;
    private final ModelPart referencedModelPart;

    public ImplicitModelPartResultMemento(NavigablePath navigablePath, ModelPart referencedModelPart) {
        this.navigablePath = navigablePath;
        this.referencedModelPart = referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ResultBuilder resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        BasicValuedModelPart basicPart = this.referencedModelPart.asBasicValuedModelPart();
        if (basicPart != null) {
            return new ImplicitModelPartResultBuilderBasic(this.navigablePath, basicPart);
        }
        ModelPart modelPart = this.referencedModelPart;
        if (modelPart instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)modelPart;
            return new ImplicitModelPartResultBuilderEmbeddable(this.navigablePath, embeddableValuedModelPart);
        }
        modelPart = this.referencedModelPart;
        if (modelPart instanceof EntityValuedModelPart) {
            EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)modelPart;
            return new ImplicitModelPartResultBuilderEntity(this.navigablePath, entityValuedModelPart);
        }
        throw new IllegalStateException("Unknown type of model part : " + String.valueOf(this.referencedModelPart));
    }
}

