/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.criteria.Nulls;
import org.hibernate.AssertionFailure;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.query.SortDirection;

public class NullPrecedenceHelper {
    public static boolean isDefaultOrdering(Nulls precedence, SortDirection sortOrder, NullOrdering nullOrdering) {
        switch (precedence) {
            case NONE: {
                return true;
            }
            case FIRST: {
                switch (nullOrdering) {
                    case FIRST: {
                        return true;
                    }
                    case LAST: {
                        return false;
                    }
                    case SMALLEST: {
                        return sortOrder == SortDirection.ASCENDING;
                    }
                    case GREATEST: {
                        return sortOrder == SortDirection.DESCENDING;
                    }
                }
                throw new AssertionFailure("Unrecognized NullOrdering");
            }
            case LAST: {
                switch (nullOrdering) {
                    case LAST: {
                        return true;
                    }
                    case FIRST: {
                        return false;
                    }
                    case SMALLEST: {
                        return sortOrder == SortDirection.DESCENDING;
                    }
                    case GREATEST: {
                        return sortOrder == SortDirection.ASCENDING;
                    }
                }
                throw new AssertionFailure("Unrecognized NullOrdering");
            }
        }
        throw new AssertionFailure("Unrecognized NullPrecedence");
    }

    public static Nulls parse(String name) {
        for (Nulls value : Nulls.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public static Nulls parse(String name, Nulls defaultValue) {
        Nulls value = NullPrecedenceHelper.parse(name);
        return value != null ? value : defaultValue;
    }

    private NullPrecedenceHelper() {
    }
}

