/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryPlan;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.spi.SimpleHqlInterpretationImpl;
import org.hibernate.query.sql.spi.ParameterInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class QueryInterpretationCacheStandardImpl
implements QueryInterpretationCache {
    private static final Logger log = QueryLogging.subLogger("plan.cache");
    private final BoundedConcurrentHashMap<QueryInterpretationCache.Key, QueryPlan> queryPlanCache;
    private final ServiceRegistry serviceRegistry;
    private final BoundedConcurrentHashMap<Object, HqlInterpretation<?>> hqlInterpretationCache;
    private final BoundedConcurrentHashMap<String, ParameterInterpretation> nativeQueryParamCache;
    private StatisticsImplementor statistics;

    public QueryInterpretationCacheStandardImpl(int maxQueryPlanCount, ServiceRegistry serviceRegistry) {
        log.debugf("Starting QueryInterpretationCache(%s)", maxQueryPlanCount);
        this.queryPlanCache = new BoundedConcurrentHashMap(maxQueryPlanCount, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.hqlInterpretationCache = new BoundedConcurrentHashMap(maxQueryPlanCount, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.nativeQueryParamCache = new BoundedConcurrentHashMap(maxQueryPlanCount, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public int getNumberOfCachedHqlInterpretations() {
        return this.hqlInterpretationCache.size();
    }

    @Override
    public int getNumberOfCachedQueryPlans() {
        return this.queryPlanCache.size();
    }

    private StatisticsImplementor getStatistics() {
        if (this.statistics == null) {
            this.statistics = this.serviceRegistry.requireService(StatisticsImplementor.class);
        }
        return this.statistics;
    }

    @Override
    public <R> SelectQueryPlan<R> resolveSelectQueryPlan(QueryInterpretationCache.Key key, Supplier<SelectQueryPlan<R>> creator) {
        log.tracef("QueryPlan#getSelectQueryPlan(%s)", (Object)key);
        StatisticsImplementor statistics = this.getStatistics();
        boolean stats = statistics.isStatisticsEnabled();
        SelectQueryPlan cached = (SelectQueryPlan)this.queryPlanCache.get(key);
        if (cached != null) {
            if (stats) {
                statistics.queryPlanCacheHit(key.getQueryString());
            }
            return cached;
        }
        SelectQueryPlan<R> plan = creator.get();
        this.queryPlanCache.put(key.prepareForStore(), plan);
        if (stats) {
            statistics.queryPlanCacheMiss(key.getQueryString());
        }
        return plan;
    }

    @Override
    public NonSelectQueryPlan getNonSelectQueryPlan(QueryInterpretationCache.Key key) {
        log.tracef("QueryPlan#getNonSelectQueryPlan(%s)", (Object)key);
        return null;
    }

    @Override
    public void cacheNonSelectQueryPlan(QueryInterpretationCache.Key key, NonSelectQueryPlan plan) {
        log.tracef("QueryPlan#cacheNonSelectQueryPlan(%s)", (Object)key);
    }

    @Override
    public <R> HqlInterpretation<R> resolveHqlInterpretation(String queryString, Class<R> expectedResultType, HqlTranslator translator) {
        HqlInterpretation<?> existingQueryOnly;
        log.tracef("QueryPlan#resolveHqlInterpretation( `%s` )", (Object)queryString);
        StatisticsImplementor statistics = this.getStatistics();
        Object cacheKey = expectedResultType != null ? new HqlInterpretationCacheKey(queryString, expectedResultType) : queryString;
        HqlInterpretation<?> existing = this.hqlInterpretationCache.get(cacheKey);
        if (existing != null) {
            if (statistics.isStatisticsEnabled()) {
                statistics.queryPlanCacheHit(queryString);
            }
            return existing;
        }
        if (expectedResultType != null && (existingQueryOnly = this.hqlInterpretationCache.get(queryString)) != null) {
            if (statistics.isStatisticsEnabled()) {
                statistics.queryPlanCacheHit(queryString);
            }
            return existingQueryOnly;
        }
        HqlInterpretation<R> hqlInterpretation = QueryInterpretationCacheStandardImpl.createHqlInterpretation(queryString, expectedResultType, translator, statistics);
        this.hqlInterpretationCache.put(cacheKey, hqlInterpretation);
        return hqlInterpretation;
    }

    @Override
    public <R> void cacheHqlInterpretation(Object cacheKey, HqlInterpretation<R> hqlInterpretation) {
        this.hqlInterpretationCache.put(cacheKey, hqlInterpretation);
    }

    protected static <R> HqlInterpretation<R> createHqlInterpretation(String queryString, Class<R> expectedResultType, HqlTranslator translator, StatisticsImplementor statistics) {
        ParameterMetadataImpl parameterMetadata;
        DomainParameterXref domainParameterXref;
        boolean stats = statistics.isStatisticsEnabled();
        long startTime = stats ? System.nanoTime() : 0L;
        SqmStatement<R> sqmStatement = translator.translate(queryString, expectedResultType);
        if (sqmStatement.getSqmParameters().isEmpty()) {
            domainParameterXref = DomainParameterXref.EMPTY;
            parameterMetadata = ParameterMetadataImpl.EMPTY;
        } else {
            domainParameterXref = DomainParameterXref.from(sqmStatement);
            parameterMetadata = new ParameterMetadataImpl(domainParameterXref.getQueryParameters());
        }
        if (stats) {
            long endTime = System.nanoTime();
            long microseconds = TimeUnit.MICROSECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            statistics.queryCompiled(queryString, microseconds);
        }
        return new SimpleHqlInterpretationImpl<R>(sqmStatement, parameterMetadata, domainParameterXref);
    }

    @Override
    public ParameterInterpretation resolveNativeQueryParameters(String queryString, Function<String, ParameterInterpretation> creator) {
        log.tracef("QueryPlan#resolveNativeQueryParameters(%s)", (Object)queryString);
        return this.nativeQueryParamCache.computeIfAbsent(queryString, s -> {
            ParameterInterpretation interpretation = (ParameterInterpretation)creator.apply(queryString);
            log.debugf("Creating and caching NativeQuery ParameterInterpretation - %s", (Object)interpretation);
            return interpretation;
        });
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
        log.debug((Object)"Closing QueryInterpretationCache");
        this.hqlInterpretationCache.clear();
        this.nativeQueryParamCache.clear();
        this.queryPlanCache.clear();
    }

    private record HqlInterpretationCacheKey(String queryString, Class<?> expectedResultType) {
    }
}

