/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.dynamic;

import jakarta.persistence.AttributeConverter;
import java.util.Objects;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.results.internal.ResultSetMappingSqlSelection;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderBasic;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.resource.beans.spi.ProvidedInstanceManagedBeanImpl;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.converter.internal.JpaAttributeConverterImpl;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DynamicResultBuilderBasicConverted<O, R>
implements DynamicResultBuilderBasic {
    private final String columnAlias;
    private final BasicValueConverter<O, R> basicValueConverter;

    public DynamicResultBuilderBasicConverted(String columnAlias, Class<O> domainJavaType, Class<R> jdbcJavaType, AttributeConverter<O, R> converter, SessionFactoryImplementor sessionFactory) {
        this.columnAlias = columnAlias;
        JavaTypeRegistry javaTypeRegistry = sessionFactory.getTypeConfiguration().getJavaTypeRegistry();
        this.basicValueConverter = new JpaAttributeConverterImpl<O, R>(new ProvidedInstanceManagedBeanImpl<AttributeConverter<O, R>>(converter), javaTypeRegistry.getDescriptor(converter.getClass()), javaTypeRegistry.getDescriptor(domainJavaType), javaTypeRegistry.getDescriptor(jdbcJavaType));
    }

    public DynamicResultBuilderBasicConverted(String columnAlias, Class<O> domainJavaType, Class<R> jdbcJavaType, Class<? extends AttributeConverter<O, R>> converterJavaType, SessionFactoryImplementor sessionFactory) {
        this.columnAlias = columnAlias;
        ManagedBeanRegistry beans = sessionFactory.getManagedBeanRegistry();
        JavaTypeRegistry javaTypeRegistry = sessionFactory.getTypeConfiguration().getJavaTypeRegistry();
        this.basicValueConverter = new JpaAttributeConverterImpl(beans.getBean(converterJavaType), javaTypeRegistry.getDescriptor(converterJavaType), javaTypeRegistry.getDescriptor(domainJavaType), javaTypeRegistry.getDescriptor(jdbcJavaType));
    }

    @Override
    public Class<?> getJavaType() {
        return this.basicValueConverter.getDomainJavaType().getJavaTypeClass();
    }

    @Override
    public DynamicResultBuilderBasicConverted<?, ?> cacheKeyInstance() {
        return this;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        SqlAstCreationState sqlAstCreationState = domainResultCreationState.getSqlAstCreationState();
        TypeConfiguration typeConfiguration = sqlAstCreationState.getCreationContext().getTypeConfiguration();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        String columnName = this.columnAlias != null ? this.columnAlias : jdbcResultsMetadata.resolveColumnName(resultPosition + 1);
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnName), state -> this.resultSetMappingSqlSelection(jdbcResultsMetadata, resultPosition, typeConfiguration)), this.basicValueConverter.getRelationalJavaType(), null, typeConfiguration);
        return new BasicResult<O>(sqlSelection.getValuesArrayPosition(), this.columnAlias, this.basicValueConverter.getDomainJavaType(), this.basicValueConverter, null, false, false);
    }

    private ResultSetMappingSqlSelection resultSetMappingSqlSelection(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, TypeConfiguration typeConfiguration) {
        int jdbcPosition = this.columnAlias != null ? jdbcResultsMetadata.resolveColumnPosition(this.columnAlias) : resultPosition + 1;
        BasicType<R> basicType = jdbcResultsMetadata.resolveType(jdbcPosition, this.basicValueConverter.getRelationalJavaType(), typeConfiguration);
        int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
        return new ResultSetMappingSqlSelection(valuesArrayPosition, basicType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicResultBuilderBasicConverted that = (DynamicResultBuilderBasicConverted)o;
        return Objects.equals(this.columnAlias, that.columnAlias) && this.basicValueConverter.equals(that.basicValueConverter);
    }

    public int hashCode() {
        int result = this.columnAlias != null ? this.columnAlias.hashCode() : 0;
        result = 31 * result + this.basicValueConverter.hashCode();
        return result;
    }
}

