/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.specification;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.query.Order;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.restriction.Path;
import org.hibernate.query.restriction.Restriction;
import org.hibernate.query.specification.QuerySpecification;
import org.hibernate.query.specification.internal.SelectionSpecificationImpl;

@Incubating
public interface SelectionSpecification<T>
extends QuerySpecification<T> {
    public SelectionSpecification<T> sort(Order<? super T> var1);

    public SelectionSpecification<T> resort(Order<? super T> var1);

    public SelectionSpecification<T> resort(List<Order<? super T>> var1);

    @Override
    public SelectionSpecification<T> restrict(Restriction<? super T> var1);

    public SelectionSpecification<T> fetch(Path<T, ?> var1);

    public SelectionSpecification<T> augment(Augmentation<T> var1);

    @Override
    public SelectionQuery<T> createQuery(Session var1);

    @Override
    public SelectionQuery<T> createQuery(StatelessSession var1);

    @Override
    public SelectionQuery<T> createQuery(EntityManager var1);

    public CriteriaQuery<T> buildCriteria(CriteriaBuilder var1);

    @Override
    public SelectionSpecification<T> validate(CriteriaBuilder var1);

    @Override
    public TypedQueryReference<T> reference();

    public static <T> SelectionSpecification<T> create(Class<T> rootEntityType) {
        return new SelectionSpecificationImpl<T>(rootEntityType);
    }

    public static <T> SelectionSpecification<T> create(Class<T> resultType, String hql) {
        return new SelectionSpecificationImpl<T>(hql, resultType);
    }

    public static <T> SelectionSpecification<T> create(CriteriaQuery<T> criteria) {
        return new SelectionSpecificationImpl<T>(criteria);
    }

    @FunctionalInterface
    public static interface Augmentation<T> {
        public void augment(CriteriaBuilder var1, CriteriaQuery<T> var2, Root<T> var3);
    }
}

