/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Type;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphParser;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.CommonQueryContract;
import org.hibernate.query.QueryArgumentException;
import org.hibernate.query.QueryFlushMode;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.TypedParameterValue;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.expression.NullSqmExpressible;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindableType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractCommonQueryContract
implements CommonQueryContract {
    private final SharedSessionContractImplementor session;
    private final QueryOptionsImpl queryOptions;

    public AbstractCommonQueryContract(SharedSessionContractImplementor session) {
        this.session = session;
        this.queryOptions = new QueryOptionsImpl();
    }

    protected AbstractCommonQueryContract(AbstractCommonQueryContract original) {
        this.session = original.session;
        this.queryOptions = original.queryOptions;
    }

    public final SharedSessionContractImplementor getSession() {
        return this.session;
    }

    public final SessionFactoryImplementor getSessionFactory() {
        return this.session.getFactory();
    }

    public final TypeConfiguration getTypeConfiguration() {
        return this.session.getFactory().getTypeConfiguration();
    }

    protected final ExceptionConverter getExceptionConverter() {
        return this.session.getExceptionConverter();
    }

    protected int getIntegerLiteral(JpaExpression<Number> expression, int defaultValue) {
        if (expression == null) {
            return defaultValue;
        }
        if (expression instanceof SqmLiteral) {
            return ((Number)((SqmLiteral)expression).getLiteralValue()).intValue();
        }
        if (expression instanceof Parameter) {
            Number parameterValue = (Number)this.getParameterValue((Parameter)expression);
            return parameterValue == null ? defaultValue : parameterValue.intValue();
        }
        throw new IllegalArgumentException("Can't get integer literal value from: " + String.valueOf(expression));
    }

    protected int getMaxRows(SqmSelectStatement<?> selectStatement, int size) {
        Number fetchValue;
        JpaExpression<Number> expression = selectStatement.getFetch();
        if (expression == null) {
            return -1;
        }
        if (expression instanceof SqmLiteral) {
            fetchValue = (Number)((SqmLiteral)expression).getLiteralValue();
        } else if (expression instanceof SqmParameter) {
            fetchValue = (Number)this.getParameterValue((Parameter)expression);
            if (fetchValue == null) {
                return -1;
            }
        } else {
            throw new IllegalArgumentException("Can't get max rows value from: " + String.valueOf(expression));
        }
        return switch (selectStatement.getFetchClauseType()) {
            default -> throw new IncompatibleClassChangeError();
            case FetchClauseType.ROWS_ONLY, FetchClauseType.ROWS_WITH_TIES -> fetchValue.intValue();
            case FetchClauseType.PERCENT_ONLY, FetchClauseType.PERCENT_WITH_TIES -> (int)Math.ceil((double)size * fetchValue.doubleValue() / 100.0);
        };
    }

    public Map<String, Object> getHints() {
        this.checkOpenNoRollback();
        HashMap<String, Object> hints = new HashMap<String, Object>();
        this.collectHints(hints);
        return hints;
    }

    protected void collectHints(Map<String, Object> hints) {
        LockOptions lockOptions;
        if (this.getQueryOptions().getTimeout() != null) {
            hints.put("org.hibernate.timeout", this.getQueryOptions().getTimeout());
            hints.put("jakarta.persistence.query.timeout", this.getQueryOptions().getTimeout() * 1000);
        }
        this.putIfNotNull(hints, "org.hibernate.comment", this.getComment());
        this.putIfNotNull(hints, "org.hibernate.flushMode", this.getQueryOptions().getFlushMode());
        this.putIfNotNull(hints, "org.hibernate.readOnly", this.getQueryOptions().isReadOnly());
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getQueryOptions().getFetchSize());
        this.putIfNotNull(hints, "org.hibernate.cacheable", this.getQueryOptions().isResultCachingEnabled());
        this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getQueryOptions().getResultCacheRegionName());
        this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getQueryOptions().getCacheMode());
        this.putIfNotNull(hints, "hibernate.query.plan.cacheable", this.getQueryOptions().getQueryPlanCachingEnabled());
        this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
        this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
        this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        AppliedGraph appliedGraph = this.getQueryOptions().getAppliedGraph();
        if (appliedGraph != null && appliedGraph.getSemantic() != null) {
            hints.put(appliedGraph.getSemantic().getJakartaHintName(), appliedGraph.getGraph());
            hints.put(appliedGraph.getSemantic().getJpaHintName(), appliedGraph.getGraph());
        }
        if (!(lockOptions = this.getLockOptions()).isEmpty()) {
            LockMode lockMode = lockOptions.getLockMode();
            if (lockMode != null && lockMode != LockMode.NONE) {
                hints.put("org.hibernate.lockMode", (Object)lockMode);
            }
            if (lockOptions.hasAliasSpecificLockModes()) {
                for (Map.Entry<String, LockMode> entry : lockOptions.getAliasSpecificLocks()) {
                    hints.put("org.hibernate.lockMode." + entry.getKey(), (Object)entry.getValue());
                }
            }
            if (lockOptions.getFollowOnLocking() == Boolean.TRUE) {
                hints.put("hibernate.query.followOnLocking", Boolean.TRUE);
            }
            if (lockOptions.getTimeOut() != -1) {
                hints.put("jakarta.persistence.lock.timeout", lockOptions.getTimeOut());
                hints.put("javax.persistence.lock.timeout", lockOptions.getTimeOut());
            }
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Enum<?> hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Object hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    @Override
    public CommonQueryContract setHint(String hintName, Object value) {
        if (!this.applyHint(hintName, value)) {
            QueryLogging.QUERY_MESSAGE_LOGGER.ignoringUnrecognizedQueryHint(hintName);
        }
        return this;
    }

    public final boolean applyHint(String hintName, Object value) {
        this.getSession().checkOpen(true);
        try {
            switch (hintName) {
                case "org.hibernate.flushMode": {
                    this.applyFlushModeHint(ConfigurationHelper.getFlushMode(value));
                    return true;
                }
                case "org.hibernate.timeout": {
                    this.applyTimeoutHint(ConfigurationHelper.getInteger(value));
                    return true;
                }
                case "javax.persistence.query.timeout": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.query.timeout", "jakarta.persistence.query.timeout");
                }
                case "jakarta.persistence.query.timeout": {
                    int timeout = (int)Math.round(ConfigurationHelper.getInteger(value).doubleValue() / 1000.0);
                    this.applyTimeoutHint(timeout);
                    return true;
                }
                case "org.hibernate.comment": {
                    this.applyCommentHint((String)value);
                    return true;
                }
                case "org.hibernate.query.native.spaces": {
                    this.applySynchronizeSpacesHint(value);
                    return true;
                }
                case "hibernate.query.database": {
                    this.applyDatabaseHint((String)value);
                    return true;
                }
            }
            return this.applySelectionHint(hintName, value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Incorrect value for query hint: " + hintName, e);
        }
    }

    protected void applySynchronizeSpacesHint(Object value) {
        throw new IllegalArgumentException("Query spaces hint was specified for non-native query");
    }

    protected final boolean applySelectionHint(String hintName, Object value) {
        if (this.applyLockingHint(hintName, value)) {
            return true;
        }
        MutableQueryOptions queryOptions = this.getQueryOptions();
        switch (hintName) {
            case "org.hibernate.readOnly": {
                queryOptions.setReadOnly(ConfigurationHelper.getBoolean(value));
                return true;
            }
            case "org.hibernate.fetchSize": {
                queryOptions.setFetchSize(ConfigurationHelper.getInteger(value));
                return true;
            }
            case "hibernate.query.plan.cacheable": {
                queryOptions.setQueryPlanCachingEnabled(ConfigurationHelper.getBoolean(value));
                return true;
            }
            case "org.hibernate.cacheable": {
                queryOptions.setResultCachingEnabled(ConfigurationHelper.getBoolean(value));
                return true;
            }
            case "org.hibernate.cacheRegion": {
                queryOptions.setResultCacheRegionName((String)value);
                return true;
            }
            case "org.hibernate.cacheMode": {
                queryOptions.setCacheMode(ConfigurationHelper.getCacheMode(value));
                return true;
            }
            case "javax.persistence.cache.retrieveMode": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.cache.retrieveMode", "jakarta.persistence.cache.retrieveMode");
            }
            case "jakarta.persistence.cache.retrieveMode": {
                CacheRetrieveMode retrieveMode = value == null ? null : CacheRetrieveMode.valueOf((String)value.toString());
                queryOptions.setCacheRetrieveMode(retrieveMode);
                return true;
            }
            case "javax.persistence.cache.storeMode": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.cache.storeMode", "jakarta.persistence.cache.storeMode");
            }
            case "jakarta.persistence.cache.storeMode": {
                CacheStoreMode storeMode = value == null ? null : CacheStoreMode.valueOf((String)value.toString());
                queryOptions.setCacheStoreMode(storeMode);
                return true;
            }
            case "javax.persistence.fetchgraph": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.fetchgraph", "jakarta.persistence.fetchgraph");
            }
            case "jakarta.persistence.fetchgraph": {
                this.applyEntityGraphHint(hintName, value);
                return true;
            }
            case "javax.persistence.loadgraph": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.loadgraph", "jakarta.persistence.loadgraph");
            }
            case "jakarta.persistence.loadgraph": {
                this.applyEntityGraphHint(hintName, value);
                return true;
            }
            case "org.hibernate.fetchProfile": {
                queryOptions.enableFetchProfile((String)value);
            }
        }
        return false;
    }

    protected void applyEntityGraphHint(String hintName, Object value) {
        GraphSemantic graphSemantic = GraphSemantic.fromHintName(hintName);
        if (value instanceof RootGraphImplementor) {
            RootGraphImplementor rootGraphImplementor = (RootGraphImplementor)value;
            this.applyGraph(rootGraphImplementor, graphSemantic);
        } else if (value instanceof String) {
            String string = (String)value;
            this.applyGraph(string, graphSemantic);
        } else {
            throw new IllegalArgumentException("The value of the hint '" + hintName + "' must be an instance of EntityGraph or the string name of a named EntityGraph");
        }
    }

    protected void applyGraph(String graphString, GraphSemantic graphSemantic) {
        int separatorPosition = graphString.indexOf(40);
        int terminatorPosition = graphString.lastIndexOf(41);
        if (separatorPosition < 0 || terminatorPosition < 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid entity-graph definition `%s`; expected form `${EntityName}( ${property1} ... )", graphString));
        }
        SessionFactoryImplementor factory = this.getSessionFactory();
        String entityName = factory.getMappingMetamodel().getImportedName(graphString.substring(0, separatorPosition).trim());
        String graphNodes = graphString.substring(separatorPosition + 1, terminatorPosition);
        RootGraphImpl rootGraph = new RootGraphImpl(null, factory.getJpaMetamodel().entity(entityName));
        GraphParser.parseInto(rootGraph, (CharSequence)graphNodes, (EntityManagerFactory)this.getSessionFactory());
        this.applyGraph(rootGraph, graphSemantic);
    }

    protected void applyGraph(RootGraphImplementor<?> entityGraph, GraphSemantic graphSemantic) {
        this.getQueryOptions().applyGraph(entityGraph, graphSemantic);
    }

    private boolean applyLockingHint(String hintName, Object value) {
        switch (hintName) {
            case "javax.persistence.lock.timeout": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.lock.timeout", "jakarta.persistence.lock.timeout");
            }
            case "jakarta.persistence.lock.timeout": {
                if (value != null) {
                    this.applyLockTimeoutHint(ConfigurationHelper.getInteger(value));
                    return true;
                }
                return false;
            }
            case "hibernate.query.followOnLocking": {
                this.applyFollowOnLockingHint(ConfigurationHelper.getBoolean(value));
                return true;
            }
            case "org.hibernate.lockMode": {
                this.applyLockModeHint(value);
                return true;
            }
        }
        if (hintName.startsWith("org.hibernate.lockMode")) {
            this.applyAliasSpecificLockModeHint(hintName, value);
            return true;
        }
        return false;
    }

    protected void applyLockTimeoutHint(Integer timeout) {
        if (timeout != null) {
            this.applyLockTimeoutHint((int)timeout);
        }
    }

    private LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    protected void applyLockTimeoutHint(int timeout) {
        this.getLockOptions().setTimeOut(timeout);
    }

    protected void applyHibernateLockMode(LockMode value) {
        this.getLockOptions().setLockMode(value);
    }

    protected void applyLockModeType(LockModeType value) {
        this.applyHibernateLockMode(LockMode.fromJpaLockMode(value));
    }

    protected final void applyLockModeHint(Object value) {
        if (value instanceof LockMode) {
            LockMode lockMode = (LockMode)((Object)value);
            this.applyHibernateLockMode(lockMode);
        } else if (value instanceof LockModeType) {
            LockModeType lockModeType = (LockModeType)value;
            this.applyLockModeType(lockModeType);
        } else if (value instanceof String) {
            String string = (String)value;
            this.applyHibernateLockMode(LockMode.fromExternalForm(string));
        } else {
            throw new IllegalArgumentException(String.format("Native lock-mode hint [%s] must specify %s or %s. Encountered type: %s", "org.hibernate.lockMode", LockMode.class.getName(), LockModeType.class.getName(), value.getClass().getName()));
        }
    }

    protected void applyAliasSpecificLockModeHint(String hintName, Object value) {
        String alias = hintName.substring("org.hibernate.lockMode".length() + 1);
        this.getLockOptions().setAliasSpecificLockMode(alias, LockModeTypeHelper.interpretLockMode(value));
    }

    protected void applyFollowOnLockingHint(Boolean followOnLocking) {
        this.getLockOptions().setFollowOnLocking(followOnLocking);
    }

    @Override
    public String getComment() {
        return this.getQueryOptions().getComment();
    }

    @Override
    public CommonQueryContract setComment(String comment) {
        this.getQueryOptions().setComment(comment);
        return this;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        FlushMode flushMode = this.getQueryOptions().getFlushMode();
        return flushMode == null ? this.getSession().getHibernateFlushMode() : flushMode;
    }

    @Override
    public CommonQueryContract setHibernateFlushMode(FlushMode flushMode) {
        this.getQueryOptions().setFlushMode(flushMode);
        return this;
    }

    @Override
    public QueryFlushMode getQueryFlushMode() {
        return FlushModeTypeHelper.getForcedFlushMode(this.getQueryOptions().getFlushMode());
    }

    @Override
    public CommonQueryContract setQueryFlushMode(QueryFlushMode queryFlushMode) {
        this.getQueryOptions().setFlushMode(FlushModeTypeHelper.getFlushMode(queryFlushMode));
        return this;
    }

    protected void applyTimeoutHint(int timeout) {
        this.setTimeout(timeout);
    }

    protected void applyCommentHint(String comment) {
        this.setComment(comment);
    }

    protected void applyFlushModeHint(FlushMode flushMode) {
        this.setHibernateFlushMode(flushMode);
    }

    protected void applyDatabaseHint(String hint) {
        this.getQueryOptions().addDatabaseHint(hint);
    }

    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public Integer getTimeout() {
        return this.getQueryOptions().getTimeout();
    }

    @Override
    public CommonQueryContract setTimeout(int timeout) {
        this.getQueryOptions().setTimeout(timeout);
        return this;
    }

    private void getCheckOpen() {
        this.getSession().checkOpen();
    }

    private void checkOpenNoRollback() {
        this.getSession().checkOpen(false);
    }

    public int getMaxResults() {
        this.getCheckOpen();
        return this.getQueryOptions().getLimit().getMaxRowsJpa();
    }

    public int getFirstResult() {
        this.getCheckOpen();
        return this.getQueryOptions().getLimit().getFirstRowJpa();
    }

    @Override
    public abstract ParameterMetadataImplementor getParameterMetadata();

    public Set<Parameter<?>> getParameters() {
        this.checkOpenNoRollback();
        return this.getParameterMetadata().getRegistrations();
    }

    public QueryParameterImplementor<?> getParameter(String name) {
        this.checkOpenNoRollback();
        try {
            return this.getParameterMetadata().getQueryParameter(name);
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public <T> QueryParameterImplementor<T> getParameter(String name, Class<T> type) {
        this.checkOpenNoRollback();
        try {
            QueryParameter parameter = this.getParameterMetadata().getQueryParameter(name);
            if (!type.isAssignableFrom(parameter.getParameterType())) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to name [" + name + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public QueryParameterImplementor<?> getParameter(int position) {
        this.checkOpenNoRollback();
        try {
            return this.getParameterMetadata().getQueryParameter(position);
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public <T> QueryParameterImplementor<T> getParameter(int position, Class<T> type) {
        this.checkOpenNoRollback();
        try {
            QueryParameter parameter = this.getParameterMetadata().getQueryParameter(position);
            if (!type.isAssignableFrom(parameter.getParameterType())) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to position [" + position + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Internal
    public abstract QueryParameterBindings getQueryParameterBindings();

    protected abstract boolean resolveJdbcParameterTypeIfNecessary();

    private <P> JavaType<P> getJavaType(Class<P> javaType) {
        return this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
    }

    protected <P> QueryParameterBinding<P> locateBinding(Parameter<P> parameter) {
        if (parameter instanceof QueryParameterImplementor) {
            QueryParameterImplementor parameterImplementor = (QueryParameterImplementor)parameter;
            return this.locateBinding(parameterImplementor);
        }
        if (parameter.getName() != null) {
            return this.locateBinding(parameter.getName());
        }
        if (parameter.getPosition() != null) {
            return this.locateBinding(parameter.getPosition());
        }
        throw this.getExceptionConverter().convert(new IllegalArgumentException("Could not resolve binding for given parameter reference [" + String.valueOf(parameter) + "]"));
    }

    protected <P> QueryParameterBinding<P> locateBinding(QueryParameterImplementor<P> parameter) {
        this.getCheckOpen();
        return this.getQueryParameterBindings().getBinding(parameter);
    }

    protected <P> QueryParameterBinding<P> locateBinding(String name) {
        this.getCheckOpen();
        return this.getQueryParameterBindings().getBinding(name);
    }

    protected <P> QueryParameterBinding<P> locateBinding(int position) {
        this.getCheckOpen();
        return this.getQueryParameterBindings().getBinding(position);
    }

    public boolean isBound(Parameter<?> param) {
        this.getCheckOpen();
        QueryParameter parameter = this.getParameterMetadata().resolve((Parameter)param);
        return parameter != null && this.getQueryParameterBindings().isBound((QueryParameterImplementor<?>)parameter);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        this.checkOpenNoRollback();
        QueryParameter parameter = this.getParameterMetadata().resolve((Parameter)param);
        if (parameter == null) {
            throw new IllegalArgumentException("The parameter [" + String.valueOf(param) + "] is not part of this Query");
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(parameter);
        if (binding == null || !binding.isBound()) {
            throw new IllegalStateException("Parameter value not yet bound : " + param.toString());
        }
        if (binding.isMultiValued()) {
            return (T)binding.getBindValues();
        }
        return (T)binding.getBindValue();
    }

    public Object getParameterValue(String name) {
        this.checkOpenNoRollback();
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(name);
        if (!binding.isBound()) {
            throw new IllegalStateException("The parameter [" + name + "] has not yet been bound");
        }
        if (binding.isMultiValued()) {
            return binding.getBindValues();
        }
        return binding.getBindValue();
    }

    public Object getParameterValue(int position) {
        this.checkOpenNoRollback();
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(position);
        if (!binding.isBound()) {
            throw new IllegalStateException("The parameter [" + position + "] has not yet been bound");
        }
        return binding.isMultiValued() ? binding.getBindValues() : binding.getBindValue();
    }

    @Override
    public CommonQueryContract setParameter(String name, Object value) {
        this.checkOpenNoRollback();
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedParameterValue = (TypedParameterValue)value;
            this.setTypedParameter(name, typedParameterValue);
        } else {
            QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(name);
            if (this.multipleBinding(binding.getQueryParameter(), value) && value instanceof Collection) {
                Collection collectionValue = (Collection)value;
                if (!this.isRegisteredAsBasicType(value.getClass())) {
                    return this.setParameterList(name, collectionValue);
                }
            }
            binding.setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        }
        return this;
    }

    private boolean multipleBinding(QueryParameter<Object> param, Object value) {
        BindableType<Object> hibernateType;
        return param.allowsMultiValuedBinding() && ((hibernateType = param.getHibernateType()) == null || hibernateType instanceof NullSqmExpressible || this.isInstance(hibernateType, value));
    }

    private <T> void setTypedParameter(String name, TypedParameterValue<T> typedValue) {
        this.setParameter(name, typedValue.value(), typedValue.type());
    }

    private <T> void setTypedParameter(int position, TypedParameterValue<T> typedValue) {
        this.setParameter(position, typedValue.value(), typedValue.type());
    }

    private boolean isInstance(Type<?> parameterType, Object value) {
        SqmBindableType sqmExpressible = this.getNodeuilder().resolveExpressible(parameterType);
        assert (sqmExpressible != null);
        return sqmExpressible.getExpressibleJavaType().isInstance(value);
    }

    private NodeBuilder getNodeuilder() {
        return this.getSessionFactory().getQueryEngine().getCriteriaBuilder();
    }

    @Override
    public <P> CommonQueryContract setParameter(String name, P value, Class<P> javaType) {
        JavaType<P> javaDescriptor = this.getJavaType(javaType);
        if (javaDescriptor == null) {
            this.setParameter(name, value);
        } else {
            this.setParameter(name, value, this.getParamType(javaType));
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameter(String name, P value, Type<P> type) {
        this.locateBinding(name).setBindValue(value, (BindableType)type);
        return this;
    }

    @Override
    @Deprecated(since="7")
    public CommonQueryContract setParameter(String name, Instant value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public CommonQueryContract setParameter(int position, Object value) {
        this.checkOpenNoRollback();
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedParameterValue = (TypedParameterValue)value;
            this.setTypedParameter(position, typedParameterValue);
        } else {
            QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(position);
            if (this.multipleBinding(binding.getQueryParameter(), value) && value instanceof Collection) {
                Collection collectionValue = (Collection)value;
                if (!this.isRegisteredAsBasicType(value.getClass())) {
                    return this.setParameterList(position, collectionValue);
                }
            }
            binding.setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        }
        return this;
    }

    private boolean isRegisteredAsBasicType(Class<?> valueClass) {
        return this.getTypeConfiguration().getBasicTypeForJavaType(valueClass) != null;
    }

    @Override
    public <P> CommonQueryContract setParameter(int position, P value, Class<P> javaType) {
        JavaType<P> javaDescriptor = this.getJavaType(javaType);
        if (javaDescriptor == null) {
            this.setParameter(position, value);
        } else {
            this.setParameter(position, value, this.getParamType(javaType));
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameter(int position, P value, Type<P> type) {
        this.locateBinding(position).setBindValue(value, (BindableType)type);
        return this;
    }

    @Override
    @Deprecated(since="7")
    public CommonQueryContract setParameter(int position, Instant value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    public <P> CommonQueryContract setParameter(QueryParameter<P> parameter, P value) {
        this.locateBinding(parameter).setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        JavaType<P> javaDescriptor = this.getJavaType(javaType);
        if (javaDescriptor == null) {
            this.setParameter(parameter, value);
        } else {
            this.setParameter(parameter, value, this.getParamType(javaType));
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameter(QueryParameter<P> parameter, P value, Type<P> type) {
        this.locateBinding(parameter).setBindValue(value, (BindableType)type);
        return this;
    }

    public <P> CommonQueryContract setParameter(Parameter<P> parameter, P value) {
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedParameterValue = (TypedParameterValue)value;
            Class parameterType = parameter.getParameterType();
            BindableType type = typedParameterValue.type();
            if (type == null) {
                throw new IllegalArgumentException("TypedParameterValue has no type");
            }
            if (!parameterType.isAssignableFrom(type.getJavaType())) {
                throw new QueryArgumentException("Given TypedParameterValue is not assignable to given Parameter type", parameterType, typedParameterValue.value());
            }
            TypedParameterValue typedValue = (TypedParameterValue)value;
            this.setParameter(parameter, typedValue.value(), typedValue.type());
        } else {
            this.locateBinding(parameter).setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        }
        return this;
    }

    private <P> void setParameter(Parameter<P> parameter, P value, Type<P> type) {
        if (parameter instanceof QueryParameter) {
            QueryParameter queryParameter = (QueryParameter)parameter;
            this.setParameter(queryParameter, value, type);
        } else if (value == null) {
            this.locateBinding(parameter).setBindValue(null, (BindableType)type);
        } else if (value instanceof Collection) {
            this.locateBinding(parameter).setBindValues((Collection)value);
        } else {
            this.locateBinding(parameter).setBindValue(value, (BindableType)type);
        }
    }

    @Override
    @Deprecated
    public CommonQueryContract setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public CommonQueryContract setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public CommonQueryContract setParameter(String name, Calendar value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public CommonQueryContract setParameter(String name, Date value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public CommonQueryContract setParameter(int position, Calendar value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public CommonQueryContract setParameter(int position, Date value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public CommonQueryContract setParameterList(String name, Collection values) {
        this.locateBinding(name).setBindValues(values);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        JavaType<P> javaDescriptor = this.getJavaType(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(name, values);
        } else {
            this.setParameterList(name, values, this.getParamType(javaType));
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(String name, Collection<? extends P> values, Type<P> type) {
        this.locateBinding(name).setBindValues(values, (BindableType)type);
        return this;
    }

    @Override
    public CommonQueryContract setParameterList(String name, Object[] values) {
        this.locateBinding(name).setBindValues(Arrays.asList(values));
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(String name, P[] values, Class<P> javaType) {
        JavaType<P> javaDescriptor = this.getJavaType(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(name, (Object[])values);
        } else {
            this.setParameterList(name, values, this.getParamType(javaType));
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(String name, P[] values, Type<P> type) {
        this.locateBinding(name).setBindValues(Arrays.asList(values), (BindableType)type);
        return this;
    }

    @Override
    public CommonQueryContract setParameterList(int position, Collection values) {
        this.locateBinding(position).setBindValues(values);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        JavaType<P> javaDescriptor = this.getJavaType(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(position, values);
        } else {
            this.setParameterList(position, values, this.getParamType(javaType));
        }
        return this;
    }

    private <P> Type<P> getParamType(Class<P> javaType) {
        BasicType<P> basicType = this.getTypeConfiguration().standardBasicTypeForJavaType(javaType);
        if (basicType != null) {
            return basicType;
        }
        ManagedType managedDomainType = this.getSessionFactory().getJpaMetamodel().managedType(javaType);
        if (managedDomainType != null) {
            return managedDomainType;
        }
        throw new HibernateException("Unable to determine Type: " + javaType.getName());
    }

    @Override
    public <P> CommonQueryContract setParameterList(int position, Collection<? extends P> values, Type<P> type) {
        this.locateBinding(position).setBindValues(values, (BindableType)type);
        return this;
    }

    @Override
    public CommonQueryContract setParameterList(int position, Object[] values) {
        this.locateBinding(position).setBindValues(Arrays.asList(values));
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(int position, P[] values, Class<P> javaType) {
        JavaType<P> javaDescriptor = this.getJavaType(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(position, (Object[])values);
        } else {
            this.setParameterList(position, values, this.getParamType(javaType));
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(int position, P[] values, Type<P> type) {
        this.locateBinding(position).setBindValues(Arrays.asList(values), (BindableType)type);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        this.locateBinding(parameter).setBindValues(values);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        JavaType<P> javaDescriptor = this.getJavaType(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(parameter, values);
        } else {
            this.setParameterList(parameter, values, this.getParamType(javaType));
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Type<P> type) {
        this.locateBinding(parameter).setBindValues(values, (BindableType)type);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, P[] values) {
        this.locateBinding(parameter).setBindValues(values == null ? null : Arrays.asList(values));
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        JavaType<P> javaDescriptor = this.getJavaType(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(parameter, values);
        } else {
            this.setParameterList(parameter, values, this.getParamType(javaType));
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, P[] values, Type<P> type) {
        this.locateBinding(parameter).setBindValues(Arrays.asList(values), (BindableType)type);
        return this;
    }

    @Override
    public CommonQueryContract setProperties(Map map) {
        for (String paramName : this.getParameterMetadata().getNamedParameterNames()) {
            Object object = map.get(paramName);
            if (object == null) {
                if (!map.containsKey(paramName)) continue;
                this.setParameter(paramName, null, this.determineType(paramName, null));
                continue;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                this.setParameterList(paramName, collection);
                continue;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                this.setParameterList(paramName, array);
                continue;
            }
            this.setParameter(paramName, object, this.determineType(paramName, object.getClass()));
        }
        return this;
    }

    protected <T> Type<T> determineType(String namedParam, Class<? extends T> retType) {
        BindableType type = this.locateBinding(namedParam).getBindType();
        if (type == null) {
            type = this.getParameterMetadata().getQueryParameter(namedParam).getHibernateType();
        }
        if (type == null && retType != null) {
            type = this.getSessionFactory().getMappingMetamodel().resolveParameterBindType(retType);
        }
        if (retType != null && !retType.isAssignableFrom(type.getJavaType())) {
            throw new IllegalStateException("Parameter not of expected type: " + retType.getName());
        }
        return type;
    }

    @Override
    public CommonQueryContract setProperties(Object bean) {
        Class<?> clazz = bean.getClass();
        for (String paramName : this.getParameterMetadata().getNamedParameterNames()) {
            try {
                PropertyAccess propertyAccess = BuiltInPropertyAccessStrategies.BASIC.getStrategy().buildPropertyAccess(clazz, paramName, true);
                Getter getter = propertyAccess.getGetter();
                Class<?> retType = getter.getReturnTypeClass();
                Object object = getter.get(bean);
                if (Collection.class.isAssignableFrom(retType)) {
                    this.setParameterList(paramName, (Collection)object);
                    continue;
                }
                if (retType.isArray()) {
                    this.setParameterList(paramName, (Object[])object);
                    continue;
                }
                this.setParameter(paramName, object, this.determineType(paramName, retType));
            }
            catch (PropertyNotFoundException propertyNotFoundException) {}
        }
        return this;
    }
}

