/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import jakarta.persistence.metamodel.Type;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.jpa.AvailableHints;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.KeyedPage;
import org.hibernate.query.KeyedResultList;
import org.hibernate.query.QueryFlushMode;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.AbstractSelectionQuery;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryImplementor;

public abstract class AbstractQuery<R>
extends AbstractSelectionQuery<R>
implements QueryImplementor<R> {
    public AbstractQuery(SharedSessionContractImplementor session) {
        super(session);
    }

    @Override
    protected void applyOptions(NamedQueryMemento<?> memento) {
        if (memento.getHints() != null) {
            memento.getHints().forEach((string, object) -> this.setHint((String)string, object));
        }
        if (memento.getCacheable() != null) {
            this.setCacheable(memento.getCacheable());
        }
        if (memento.getCacheRegion() != null) {
            this.setCacheRegion(memento.getCacheRegion());
        }
        if (memento.getCacheMode() != null) {
            this.setCacheMode(memento.getCacheMode());
        }
        if (memento.getFlushMode() != null) {
            this.setHibernateFlushMode(memento.getFlushMode());
        }
        if (memento.getReadOnly() != null) {
            this.setReadOnly(memento.getReadOnly());
        }
        if (memento.getTimeout() != null) {
            this.setTimeout(memento.getTimeout());
        }
        if (memento.getFetchSize() != null) {
            this.setFetchSize(memento.getFetchSize());
        }
        if (memento.getComment() != null) {
            this.setComment(memento.getComment());
        }
    }

    @Override
    public QueryImplementor<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public QueryImplementor<R> setEntityGraph(EntityGraph<? super R> graph, GraphSemantic semantic) {
        super.setEntityGraph(graph, semantic);
        return this;
    }

    @Override
    public QueryImplementor<R> enableFetchProfile(String profileName) {
        super.enableFetchProfile(profileName);
        return this;
    }

    @Override
    public QueryImplementor<R> disableFetchProfile(String profileName) {
        super.disableFetchProfile(profileName);
        return this;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return super.getQueryOptions();
    }

    @Override
    public int getMaxResults() {
        return super.getMaxResults();
    }

    @Override
    public QueryImplementor<R> setMaxResults(int maxResults) {
        super.setMaxResults(maxResults);
        return this;
    }

    @Override
    public int getFirstResult() {
        return super.getFirstResult();
    }

    @Override
    public QueryImplementor<R> setFirstResult(int startPosition) {
        super.setFirstResult(startPosition);
        return this;
    }

    @Override
    public <T> QueryImplementor<T> setTupleTransformer(TupleTransformer<T> transformer) {
        this.getQueryOptions().setTupleTransformer(transformer);
        return this;
    }

    @Override
    public QueryImplementor<R> setResultListTransformer(ResultListTransformer<R> transformer) {
        this.getQueryOptions().setResultListTransformer(transformer);
        return this;
    }

    @Override
    public QueryImplementor<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public QueryImplementor<R> setQueryFlushMode(QueryFlushMode queryFlushMode) {
        super.setQueryFlushMode(queryFlushMode);
        return this;
    }

    @Override
    public QueryImplementor<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public QueryImplementor<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public QueryImplementor<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        super.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public QueryImplementor<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        super.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return super.isCacheable();
    }

    @Override
    public QueryImplementor<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public QueryImplementor<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public QueryImplementor<R> setQueryPlanCacheable(boolean queryPlanCacheable) {
        super.setQueryPlanCacheable(queryPlanCacheable);
        return this;
    }

    @Override
    public QueryImplementor<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public QueryImplementor<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public QueryImplementor<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    @Deprecated
    public LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        this.getQueryOptions().getLockOptions().overlay(lockOptions);
        return this;
    }

    @Override
    public LockModeType getLockMode() {
        this.getSession().checkOpen(false);
        return super.getLockMode();
    }

    @Override
    public QueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public QueryImplementor<R> setLockMode(LockModeType lockModeType) {
        this.getSession().checkOpen();
        super.setHibernateLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        return this;
    }

    @Override
    public QueryImplementor<R> setLockScope(PessimisticLockScope lockScope) {
        this.getSession().checkOpen();
        super.setLockScope(lockScope);
        return this;
    }

    @Override
    public QueryImplementor<R> setTimeout(Timeout timeout) {
        this.getSession().checkOpen();
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public String getComment() {
        return super.getComment();
    }

    @Override
    public QueryImplementor<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public QueryImplementor<R> addQueryHint(String hint) {
        this.getQueryOptions().addDatabaseHint(hint);
        return this;
    }

    public Set<String> getSupportedHints() {
        return AvailableHints.getDefinedHints();
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        if (this.getQueryOptions().getTimeout() != null) {
            hints.put("org.hibernate.timeout", this.getQueryOptions().getTimeout());
            hints.put("jakarta.persistence.query.timeout", this.getQueryOptions().getTimeout() * 1000);
            hints.put("javax.persistence.query.timeout", this.getQueryOptions().getTimeout() * 1000);
        }
        if (this.getLockOptions().getTimeOut() != -1) {
            hints.put("jakarta.persistence.lock.timeout", this.getLockOptions().getTimeOut());
            hints.put("javax.persistence.lock.timeout", this.getLockOptions().getTimeOut());
        }
        if (this.getLockOptions().getLockScope() == PessimisticLockScope.EXTENDED) {
            hints.put("jakarta.persistence.lock.scope", this.getLockOptions().getLockScope());
            hints.put("javax.persistence.lock.scope", this.getLockOptions().getLockScope());
        }
        if (this.getLockOptions().hasAliasSpecificLockModes()) {
            for (Map.Entry<String, LockMode> entry : this.getLockOptions().getAliasSpecificLocks()) {
                hints.put("org.hibernate.lockMode." + entry.getKey(), entry.getValue().name());
            }
        }
        this.putIfNotNull(hints, "org.hibernate.comment", this.getComment());
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getQueryOptions().getFetchSize());
        this.putIfNotNull(hints, "org.hibernate.flushMode", this.getQueryOptions().getFlushMode());
        if (this.getCacheMode() != null) {
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        }
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
        }
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
    }

    @Override
    protected boolean resolveJdbcParameterTypeIfNecessary() {
        return true;
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        return super.getParameters();
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(String name, P value, Class<P> javaTypeClass) {
        super.setParameter(name, (Object)value, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(String name, P value, Type<P> type) {
        super.setParameter(name, (Object)value, (Type)type);
        return this;
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(int position, P value, Class<P> javaTypeClass) {
        super.setParameter(position, (Object)value, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(int position, P value, Type<P> type) {
        super.setParameter(position, (Object)value, (Type)type);
        return this;
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaTypeClass) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, Type<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Type)type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaTypeClass) {
        super.setParameterList(name, (Collection)values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, Collection<? extends P> values, Type<P> type) {
        super.setParameterList(name, (Collection)values, (Type)type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, P[] values, Class<P> javaTypeClass) {
        super.setParameterList(name, (Object[])values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, P[] values, Type<P> type) {
        super.setParameterList(name, (Object[])values, (Type)type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaTypeClass) {
        super.setParameterList(position, (Collection)values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, Collection<? extends P> values, Type<P> type) {
        super.setParameterList(position, (Collection)values, (Type)type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, P[] values, Class<P> javaTypeClass) {
        super.setParameterList(position, (Object[])values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, P[] values, Type<P> type) {
        super.setParameterList(position, (Object[])values, (Type)type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList((QueryParameter)parameter, (Collection)values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaTypeClass) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Type<P> type) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Type)type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList((QueryParameter)parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaTypeClass) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, Type<P> type) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Type)type);
        return this;
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public QueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public QueryImplementor<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    protected void prepareForExecution() {
    }

    @Override
    public int executeUpdate() throws HibernateException {
        this.getSession().checkTransactionNeededForUpdateOperation("No active transaction for update or delete query");
        HashSet<String> fetchProfiles = this.beforeQueryHandlingFetchProfiles();
        boolean success = false;
        try {
            int result = this.doExecuteUpdate();
            success = true;
            int n = result;
            return n;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.afterQueryHandlingFetchProfiles(success, fetchProfiles);
        }
    }

    protected abstract int doExecuteUpdate();

    @Override
    public KeyedResultList<R> getKeyedResultList(KeyedPage<R> keyedPage) {
        throw new UnsupportedOperationException("Getting keyed result list is not supported by this query.");
    }
}

