/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.Incubating;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sql.spi.ParameterInterpretation;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.spi.InterpretationsKeySource;

@Incubating
public interface QueryInterpretationCache {
    public static Key createInterpretationsKey(InterpretationsKeySource keySource) {
        return SqmInterpretationsKey.createInterpretationsKey(keySource);
    }

    public int getNumberOfCachedHqlInterpretations();

    public int getNumberOfCachedQueryPlans();

    public <R> HqlInterpretation<R> resolveHqlInterpretation(String var1, Class<R> var2, HqlTranslator var3);

    public <R> void cacheHqlInterpretation(Object var1, HqlInterpretation<R> var2);

    public <R> SelectQueryPlan<R> resolveSelectQueryPlan(Key var1, Supplier<SelectQueryPlan<R>> var2);

    public NonSelectQueryPlan getNonSelectQueryPlan(Key var1);

    public void cacheNonSelectQueryPlan(Key var1, NonSelectQueryPlan var2);

    public ParameterInterpretation resolveNativeQueryParameters(String var1, Function<String, ParameterInterpretation> var2);

    public boolean isEnabled();

    public void close();

    public static interface Key {
        default public Key prepareForStore() {
            return this;
        }

        public String getQueryString();
    }
}

