/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.spi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;

public class SelectInterpretationsKey
implements QueryInterpretationCache.Key {
    private final String sql;
    private final JdbcValuesMappingProducer jdbcValuesMappingProducer;
    private final Collection<String> querySpaces;
    private final TupleTransformer<?> tupleTransformer;
    private final ResultListTransformer<?> resultListTransformer;
    private final int hash;

    public SelectInterpretationsKey(String sql, JdbcValuesMappingProducer jdbcValuesMappingProducer, Collection<String> querySpaces, TupleTransformer<?> tupleTransformer, ResultListTransformer<?> resultListTransformer) {
        this.sql = sql;
        this.jdbcValuesMappingProducer = jdbcValuesMappingProducer;
        this.querySpaces = querySpaces;
        this.tupleTransformer = tupleTransformer;
        this.resultListTransformer = resultListTransformer;
        this.hash = this.generateHashCode();
    }

    private SelectInterpretationsKey(String sql, JdbcValuesMappingProducer jdbcValuesMappingProducer, Collection<String> querySpaces, TupleTransformer<?> tupleTransformer, ResultListTransformer<?> resultListTransformer, int hash) {
        this.sql = sql;
        this.jdbcValuesMappingProducer = jdbcValuesMappingProducer;
        this.querySpaces = querySpaces;
        this.tupleTransformer = tupleTransformer;
        this.resultListTransformer = resultListTransformer;
        this.hash = hash;
    }

    @Override
    public String getQueryString() {
        return this.sql;
    }

    @Override
    public QueryInterpretationCache.Key prepareForStore() {
        return new SelectInterpretationsKey(this.sql, this.jdbcValuesMappingProducer.cacheKeyInstance(), new HashSet<String>(this.querySpaces), this.tupleTransformer, this.resultListTransformer, this.hash);
    }

    private int generateHashCode() {
        return this.sql.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectInterpretationsKey)) {
            return false;
        }
        SelectInterpretationsKey that = (SelectInterpretationsKey)o;
        return this.sql.equals(that.sql) && Objects.equals(this.jdbcValuesMappingProducer, that.jdbcValuesMappingProducer) && Objects.equals(this.querySpaces, that.querySpaces) && Objects.equals(this.tupleTransformer, that.tupleTransformer) && Objects.equals(this.resultListTransformer, that.resultListTransformer);
    }
}

