/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.Page;
import org.hibernate.query.Query;
import org.hibernate.query.QueryFlushMode;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaValues;
import org.hibernate.query.criteria.internal.NamedCriteriaQueryMementoImpl;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.hql.internal.QuerySplitter;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.internal.DelegatingDomainQueryExecutionContext;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.spi.DelegatingQueryOptions;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.internal.AbstractSqmSelectionQuery;
import org.hibernate.query.sqm.internal.AggregatedNonSelectQueryPlanImpl;
import org.hibernate.query.sqm.internal.AppliedGraphs;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.MultiTableDeleteQueryPlan;
import org.hibernate.query.sqm.internal.MultiTableInsertQueryPlan;
import org.hibernate.query.sqm.internal.MultiTableUpdateQueryPlan;
import org.hibernate.query.sqm.internal.SimpleDeleteQueryPlan;
import org.hibernate.query.sqm.internal.SimpleInsertQueryPlan;
import org.hibernate.query.sqm.internal.SimpleUpdateQueryPlan;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.spi.InterpretationsKeySource;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.AbstractSqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.SingleResultConsumer;

public class QuerySqmImpl<R>
extends AbstractSqmSelectionQuery<R>
implements SqmQueryImplementor<R>,
InterpretationsKeySource,
DomainQueryExecutionContext {
    private final String hql;
    private Object queryStringCacheKey;
    private SqmStatement<R> sqm;
    private ParameterMetadataImplementor parameterMetadata;
    private DomainParameterXref domainParameterXref;
    private QueryParameterBindings parameterBindings;
    private final Class<R> resultType;
    private final TupleMetadata tupleMetadata;

    public QuerySqmImpl(NamedSqmQueryMemento<?> memento, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        this(memento.getHqlString(), QuerySqmImpl.interpretation(memento, expectedResultType, session), expectedResultType, session);
        this.applySqmOptions(memento);
    }

    public QuerySqmImpl(NamedSqmQueryMemento<?> memento, SqmStatement<R> statement, Class<R> resultType, SharedSessionContractImplementor session) {
        this(statement, resultType, session);
        this.applySqmOptions(memento);
    }

    public QuerySqmImpl(String hql, HqlInterpretation<R> hqlInterpretation, Class<R> resultType, SharedSessionContractImplementor session) {
        super(session);
        this.hql = hql;
        this.queryStringCacheKey = hql;
        this.resultType = resultType;
        this.sqm = hqlInterpretation.getSqmStatement();
        this.parameterMetadata = hqlInterpretation.getParameterMetadata();
        this.domainParameterXref = hqlInterpretation.getDomainParameterXref();
        this.parameterBindings = this.parameterMetadata.createBindings(session.getFactory());
        if (this.sqm instanceof SqmSelectStatement) {
            hqlInterpretation.validateResultType(resultType);
        } else if (resultType != null) {
            throw new IllegalQueryOperationException("Result type given for a non-SELECT Query", hql, null);
        }
        this.setComment(hql);
        this.tupleMetadata = this.buildTupleMetadata(this.sqm, resultType);
    }

    public QuerySqmImpl(SqmStatement<R> criteria, Class<R> expectedResultType, SharedSessionContractImplementor producer) {
        this(criteria, producer.isCriteriaCopyTreeEnabled(), expectedResultType, producer);
    }

    public QuerySqmImpl(SqmStatement<R> criteria, boolean copyAst, Class<R> expectedResultType, SharedSessionContractImplementor producer) {
        super(producer);
        this.hql = "<criteria>";
        if (copyAst) {
            this.sqm = criteria.copy(SqmCopyContext.simpleContext());
            if (producer.isCriteriaPlanCacheEnabled()) {
                this.queryStringCacheKey = this.sqm.toHqlString();
                this.setQueryPlanCacheable(true);
            } else {
                this.queryStringCacheKey = this.sqm;
            }
        } else {
            this.sqm = criteria;
            this.queryStringCacheKey = producer.isCriteriaPlanCacheEnabled() ? this.sqm.toHqlString() : this.sqm;
            this.setQueryPlanCacheable(true);
        }
        this.setComment(this.hql);
        this.domainParameterXref = DomainParameterXref.from(this.sqm);
        this.parameterMetadata = !this.domainParameterXref.hasParameters() ? ParameterMetadataImpl.EMPTY : new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters());
        this.parameterBindings = this.parameterMetadata.createBindings(producer.getFactory());
        for (SqmParameter<?> sqmParameter : this.domainParameterXref.getParameterResolutions().getSqmParameters()) {
            if (!(sqmParameter instanceof SqmJpaCriteriaParameterWrapper)) continue;
            SqmJpaCriteriaParameterWrapper wrapper = (SqmJpaCriteriaParameterWrapper)sqmParameter;
            this.bindCriteriaParameter(wrapper);
        }
        QuerySqmImpl.validateQuery(expectedResultType, this.sqm, this.hql);
        this.resultType = expectedResultType;
        this.tupleMetadata = this.buildTupleMetadata(criteria, expectedResultType);
    }

    private static <R> void validateQuery(Class<R> expectedResultType, SqmStatement<R> sqm, String hql) {
        if (sqm instanceof SqmSelectStatement) {
            SqmSelectStatement selectStatement = (SqmSelectStatement)sqm;
            JpaQueryPart queryPart = selectStatement.getQueryPart();
            ((SqmQueryPart)queryPart).validateQueryStructureAndFetchOwners();
            SqmUtil.validateCriteriaQuery(queryPart);
            selectStatement.validateResultType(expectedResultType);
        } else if (sqm instanceof AbstractSqmDmlStatement) {
            AbstractSqmDmlStatement update = (AbstractSqmDmlStatement)sqm;
            if (expectedResultType != null) {
                throw new IllegalQueryOperationException("Result type given for a non-SELECT Query", hql, null);
            }
            update.validate(hql);
        }
    }

    @Override
    public TupleMetadata getTupleMetadata() {
        return this.tupleMetadata;
    }

    @Override
    public String getQueryString() {
        return this.hql;
    }

    @Override
    public Object getQueryStringCacheKey() {
        return this.queryStringCacheKey;
    }

    @Override
    public SqmStatement<R> getSqmStatement() {
        return this.sqm;
    }

    @Override
    protected void setSqmStatement(SqmSelectStatement<R> sqm) {
        this.sqm = sqm;
        this.queryStringCacheKey = sqm;
        QueryParameterBindings oldParameterBindings = this.parameterBindings;
        this.domainParameterXref = DomainParameterXref.from(sqm);
        this.parameterMetadata = !this.domainParameterXref.hasParameters() ? ParameterMetadataImpl.EMPTY : new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters());
        this.parameterBindings = this.parameterMetadata.createBindings(this.getSessionFactory());
        this.copyParameterBindings(oldParameterBindings);
    }

    @Override
    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public QueryParameterBindings getParameterBindings() {
        return this.getQueryParameterBindings();
    }

    public Class<R> getResultType() {
        return this.resultType;
    }

    @Override
    public Class<R> getExpectedResultType() {
        return this.resultType;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.getSession().getLoadQueryInfluencers();
    }

    @Override
    protected boolean resolveJdbcParameterTypeIfNecessary() {
        return false;
    }

    @Override
    public BooleanSupplier hasMultiValuedParameterBindingsChecker() {
        return this::hasMultiValuedParameterBindings;
    }

    protected boolean hasMultiValuedParameterBindings() {
        return this.getQueryParameterBindings().hasAnyMultiValuedBindings() || this.getParameterMetadata().hasAnyMatching(QueryParameter::allowsMultiValuedBinding);
    }

    @Override
    protected void prepareForExecution() {
        this.resetCallback();
    }

    protected void verifySelect() {
        try {
            SqmUtil.verifyIsSelectStatement(this.getSqmStatement(), this.hql);
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException("Query executed via 'getResultList()' or 'getSingleResult()' must be a 'select' query [" + this.hql + "]", (Throwable)((Object)e));
        }
    }

    @Override
    public long getResultCount() {
        this.verifySelect();
        DelegatingDomainQueryExecutionContext context = new DelegatingDomainQueryExecutionContext(this){

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }
        };
        SqmSelectStatement sqmStatement = (SqmSelectStatement)this.getSqmStatement();
        return (Long)this.buildConcreteQueryPlan(sqmStatement.createCountQuery(), Long.class, (TupleMetadata)null, this.getQueryOptions()).executeQuery(context, SingleResultConsumer.instance());
    }

    @Override
    protected List<R> doList() {
        this.verifySelect();
        SqmSelectStatement statement = (SqmSelectStatement)this.getSqmStatement();
        boolean containsCollectionFetches = statement.containsCollectionFetches() || AppliedGraphs.containsCollectionFetches(this.getQueryOptions());
        boolean hasLimit = QuerySqmImpl.hasLimit(statement, (MutableQueryOptions)this.getQueryOptions());
        boolean needsDistinct = this.needsDistinct(containsCollectionFetches, hasLimit, statement);
        List<R> list = this.resolveSelectQueryPlan().performList(this.executionContextForDoList(containsCollectionFetches, hasLimit, needsDistinct));
        return needsDistinct ? this.handleDistinct(hasLimit, statement, list) : list;
    }

    private List<R> handleDistinct(boolean hasLimit, SqmSelectStatement<?> statement, List<R> list) {
        int first = this.first(hasLimit, statement);
        int max = this.max(hasLimit, statement, list);
        if (first > 0 || max != -1) {
            int resultSize = list.size();
            if (first > resultSize) {
                return new ArrayList(0);
            }
            int toIndex = max != -1 ? first + max : resultSize;
            return list.subList(first, Math.min(toIndex, resultSize));
        }
        return list;
    }

    protected DomainQueryExecutionContext executionContextForDoList(boolean containsCollectionFetches, boolean hasLimit, boolean needsDistinct) {
        QueryOptions normalizedQueryOptions;
        QueryOptions originalQueryOptions;
        if (hasLimit && containsCollectionFetches) {
            this.errorOrLogForPaginationWithCollectionFetch();
            originalQueryOptions = this.getQueryOptions();
            normalizedQueryOptions = needsDistinct ? SqlOmittingQueryOptions.omitSqlQueryOptionsWithUniqueSemanticFilter(originalQueryOptions, true, false) : SqlOmittingQueryOptions.omitSqlQueryOptions(originalQueryOptions, true, false);
        } else if (needsDistinct) {
            originalQueryOptions = this.getQueryOptions();
            normalizedQueryOptions = QuerySqmImpl.uniqueSemanticQueryOptions(originalQueryOptions);
        } else {
            return this;
        }
        if (originalQueryOptions == normalizedQueryOptions) {
            return this;
        }
        return new DelegatingDomainQueryExecutionContext(this){

            @Override
            public QueryOptions getQueryOptions() {
                return normalizedQueryOptions;
            }
        };
    }

    public static QueryOptions uniqueSemanticQueryOptions(QueryOptions originalOptions) {
        return originalOptions.getUniqueSemantic() == ListResultsConsumer.UniqueSemantic.FILTER ? originalOptions : new UniqueSemanticFilterQueryOption(originalOptions);
    }

    @Override
    protected ScrollableResultsImplementor<R> doScroll(ScrollMode scrollMode) {
        return this.resolveSelectQueryPlan().performScroll(scrollMode, this);
    }

    @Override
    public boolean isQueryPlanCacheable() {
        return "<criteria>".equals(this.hql) ? this.getQueryOptions().getQueryPlanCachingEnabled() == Boolean.TRUE : super.isQueryPlanCacheable();
    }

    private SelectQueryPlan<R> resolveSelectQueryPlan() {
        SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey(this);
        return cacheKey != null ? this.interpretationCache().resolveSelectQueryPlan(cacheKey, this::buildSelectQueryPlan) : this.buildSelectQueryPlan();
    }

    private QueryInterpretationCache interpretationCache() {
        return this.getSessionFactory().getQueryEngine().getInterpretationCache();
    }

    @Override
    public int executeUpdate() {
        this.verifyUpdate();
        this.getSession().checkTransactionNeededForUpdateOperation("No active transaction for update or delete query");
        HashSet<String> fetchProfiles = this.beforeQueryHandlingFetchProfiles();
        boolean success = false;
        try {
            int result = this.doExecuteUpdate();
            success = true;
            int n = result;
            return n;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.afterQueryHandlingFetchProfiles(success, fetchProfiles);
        }
    }

    protected void verifyUpdate() {
        try {
            SqmUtil.verifyIsNonSelectStatement(this.getSqmStatement(), this.hql);
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException("Query executed via 'executeUpdate()' must be an 'insert', 'update', or 'delete' statement [" + this.hql + "]", (Throwable)((Object)e));
        }
    }

    protected int doExecuteUpdate() {
        try {
            int n = this.resolveNonSelectQueryPlan().executeUpdate(this);
            return n;
        }
        finally {
            this.domainParameterXref.clearExpansions();
        }
    }

    private NonSelectQueryPlan resolveNonSelectQueryPlan() {
        NonSelectQueryPlan queryPlan = null;
        QueryInterpretationCache.Key cacheKey = SqmInterpretationsKey.generateNonSelectKey(this);
        QueryInterpretationCache interpretationCache = this.interpretationCache();
        if (cacheKey != null) {
            queryPlan = interpretationCache.getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = this.buildNonSelectQueryPlan();
            if (cacheKey != null) {
                interpretationCache.cacheNonSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    private NonSelectQueryPlan buildNonSelectQueryPlan() {
        SqmStatement<R> sqmStatement = this.getSqmStatement();
        if (sqmStatement instanceof SqmDeleteStatement) {
            return this.buildDeleteQueryPlan();
        }
        if (sqmStatement instanceof SqmUpdateStatement) {
            return this.buildUpdateQueryPlan();
        }
        if (sqmStatement instanceof SqmInsertStatement) {
            return this.buildInsertQueryPlan();
        }
        throw new UnsupportedOperationException("Query#executeUpdate for Statements of type [" + String.valueOf(sqmStatement) + "] not supported");
    }

    private NonSelectQueryPlan buildDeleteQueryPlan() {
        SqmDeleteStatement<R>[] concreteSqmStatements = QuerySplitter.split((SqmDeleteStatement)this.getSqmStatement());
        return concreteSqmStatements.length > 1 ? this.buildAggregatedDeleteQueryPlan(concreteSqmStatements) : this.buildConcreteDeleteQueryPlan(concreteSqmStatements[0]);
    }

    private NonSelectQueryPlan buildConcreteDeleteQueryPlan(SqmDeleteStatement<?> sqmDelete) {
        Bindable entityDomainType = ((SqmRoot)sqmDelete.getTarget()).getModel();
        EntityPersister persister = this.getSessionFactory().getMappingMetamodel().getEntityDescriptor(entityDomainType.getHibernateEntityName());
        SqmMultiTableMutationStrategy multiTableStrategy = persister.getSqmMultiTableMutationStrategy();
        if (multiTableStrategy != null) {
            return new MultiTableDeleteQueryPlan(sqmDelete, this.domainParameterXref, multiTableStrategy);
        }
        return new SimpleDeleteQueryPlan(persister, sqmDelete, this.domainParameterXref);
    }

    private NonSelectQueryPlan buildAggregatedDeleteQueryPlan(SqmDeleteStatement<?>[] concreteSqmStatements) {
        NonSelectQueryPlan[] aggregatedQueryPlans = new NonSelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteDeleteQueryPlan(concreteSqmStatements[i]);
        }
        return new AggregatedNonSelectQueryPlanImpl(aggregatedQueryPlans);
    }

    private NonSelectQueryPlan buildUpdateQueryPlan() {
        SqmUpdateStatement sqmUpdate = (SqmUpdateStatement)this.getSqmStatement();
        EntityPersister persister = this.getSessionFactory().getMappingMetamodel().getEntityDescriptor(((SqmRoot)sqmUpdate.getTarget()).getModel().getHibernateEntityName());
        SqmMultiTableMutationStrategy multiTableStrategy = persister.getSqmMultiTableMutationStrategy();
        return multiTableStrategy == null ? new SimpleUpdateQueryPlan(sqmUpdate, this.domainParameterXref) : new MultiTableUpdateQueryPlan(sqmUpdate, this.domainParameterXref, multiTableStrategy);
    }

    private NonSelectQueryPlan buildInsertQueryPlan() {
        SqmInsertValuesStatement insertValues;
        OptimizableGenerator optimizableGenerator;
        Optimizer optimizer;
        Generator identifierGenerator;
        SqmInsertStatement sqmInsert = (SqmInsertStatement)this.getSqmStatement();
        EntityPersister persister = this.getSessionFactory().getMappingMetamodel().getEntityDescriptor(((SqmRoot)sqmInsert.getTarget()).getModel().getHibernateEntityName());
        boolean useMultiTableInsert = persister.hasMultipleTables();
        if (!useMultiTableInsert && !this.isSimpleValuesInsert(sqmInsert, persister) && (identifierGenerator = persister.getGenerator()) instanceof BulkInsertionCapableIdentifierGenerator && identifierGenerator instanceof OptimizableGenerator && (optimizer = (optimizableGenerator = (OptimizableGenerator)identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1) {
            boolean bl = useMultiTableInsert = !this.hasIdentifierAssigned(sqmInsert, persister);
        }
        if (useMultiTableInsert) {
            return new MultiTableInsertQueryPlan(sqmInsert, this.domainParameterXref, persister.getSqmMultiTableInsertStrategy());
        }
        if (sqmInsert instanceof SqmInsertValuesStatement && (insertValues = (SqmInsertValuesStatement)sqmInsert).getValuesList().size() != 1 && !this.getSessionFactory().getJdbcServices().getDialect().supportsValuesListForInsert()) {
            List<SqmValues> valuesList = insertValues.getValuesList();
            NonSelectQueryPlan[] planParts = new NonSelectQueryPlan[valuesList.size()];
            for (int i = 0; i < valuesList.size(); ++i) {
                SqmInsertValuesStatement subInsert = insertValues.copyWithoutValues(SqmCopyContext.simpleContext());
                subInsert.values(new JpaValues[]{valuesList.get(i)});
                planParts[i] = new SimpleInsertQueryPlan(subInsert, this.domainParameterXref);
            }
            return new AggregatedNonSelectQueryPlanImpl(planParts);
        }
        return new SimpleInsertQueryPlan(sqmInsert, this.domainParameterXref);
    }

    protected boolean hasIdentifierAssigned(SqmInsertStatement<?> sqmInsert, EntityPersister entityDescriptor) {
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        String partName = identifierMapping instanceof SingleAttributeIdentifierMapping ? identifierMapping.getAttributeName() : "{id}";
        for (SqmPath<?> insertionTargetPath : sqmInsert.getInsertionTargetPaths()) {
            if (!(insertionTargetPath.getLhs() instanceof SqmRoot) || !insertionTargetPath.getReferencedPathSource().getPathName().equals(partName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSimpleValuesInsert(SqmInsertStatement<?> sqmInsert, EntityPersister entityDescriptor) {
        return sqmInsert instanceof SqmInsertValuesStatement && entityDescriptor.getSqmMultiTableMutationStrategy() == null;
    }

    @Override
    public SqmQueryImplementor<R> addQueryHint(String hint) {
        this.getQueryOptions().addDatabaseHint(hint);
        return this;
    }

    @Override
    @Deprecated
    public SqmQueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        this.getQueryOptions().getLockOptions().overlay(lockOptions);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public <T> SqmQueryImplementor<T> setTupleTransformer(TupleTransformer<T> transformer) {
        this.getQueryOptions().setTupleTransformer(transformer);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setResultListTransformer(ResultListTransformer<R> transformer) {
        this.getQueryOptions().setResultListTransformer(transformer);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setMaxResults(int maxResults) {
        super.setMaxResults(maxResults);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setFirstResult(int startPosition) {
        super.setFirstResult(startPosition);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setQueryFlushMode(QueryFlushMode queryFlushMode) {
        super.setQueryFlushMode(queryFlushMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setFlushMode(FlushModeType flushMode) {
        super.setFlushMode(flushMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setLockMode(LockModeType lockMode) {
        if (lockMode != LockModeType.NONE) {
            this.verifySelect();
        }
        this.getSession().checkOpen(false);
        this.getQueryOptions().getLockOptions().setLockMode(LockMode.fromJpaLockMode(lockMode));
        return this;
    }

    @Override
    public LockModeType getLockMode() {
        this.verifySelect();
        this.getSession().checkOpen(false);
        return this.getLockOptions().getLockMode().toJpaLockMode();
    }

    @Override
    public SqmQueryImplementor<R> setLockScope(PessimisticLockScope lockScope) {
        this.getSession().checkOpen(false);
        this.getQueryOptions().getLockOptions().setLockScope(lockScope);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setTimeout(Timeout timeout) {
        this.getSession().checkOpen(false);
        this.getQueryOptions().getLockOptions().setTimeOut(timeout.milliseconds());
        return this;
    }

    @Override
    public Query<R> setPage(Page page) {
        super.setPage(page);
        return this;
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        AppliedGraph appliedGraph;
        super.collectHints(hints);
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getFetchSize());
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        }
        if ((appliedGraph = this.getQueryOptions().getAppliedGraph()) != null && appliedGraph.getSemantic() != null) {
            hints.put(appliedGraph.getSemantic().getJakartaHintName(), appliedGraph);
            hints.put(appliedGraph.getSemantic().getJpaHintName(), appliedGraph);
        }
        this.putIfNotNull(hints, "hibernate.query.followOnLocking", this.getQueryOptions().getLockOptions().getFollowOnLocking());
    }

    @Override
    public SqmQueryImplementor<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public Query<R> setEntityGraph(EntityGraph<? super R> graph, GraphSemantic semantic) {
        super.setEntityGraph(graph, semantic);
        return this;
    }

    @Override
    public Query<R> enableFetchProfile(String profileName) {
        super.enableFetchProfile(profileName);
        return this;
    }

    @Override
    public Query<R> disableFetchProfile(String profileName) {
        super.disableFetchProfile(profileName);
        return this;
    }

    @Override
    protected void applyLockTimeoutHint(Integer timeout) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyLockTimeoutHint(timeout);
        }
    }

    @Override
    protected void applyLockTimeoutHint(int timeout) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyLockTimeoutHint(timeout);
        }
    }

    @Override
    protected void applyHibernateLockMode(LockMode value) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyHibernateLockMode(value);
        }
    }

    @Override
    protected void applyLockModeType(LockModeType value) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyLockModeType(value);
        }
    }

    @Override
    protected void applyAliasSpecificLockModeHint(String hintName, Object value) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyAliasSpecificLockModeHint(hintName, value);
        }
    }

    @Override
    protected void applyFollowOnLockingHint(Boolean followOnLocking) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyFollowOnLockingHint(followOnLocking);
        }
    }

    @Override
    public SqmQueryImplementor<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        this.getQueryOptions().applyGraph((RootGraphImplementor)graph, semantic);
        return this;
    }

    @Override
    public NamedSqmQueryMemento<R> toMemento(String name) {
        if ("<criteria>".equals(this.getQueryString())) {
            return new NamedCriteriaQueryMementoImpl<R>(name, this.getResultType(), this.getSession().isCriteriaCopyTreeEnabled() ? this.getSqmStatement() : this.getSqmStatement().copy(SqmCopyContext.simpleContext()), this.getQueryOptions().getLimit().getFirstRow(), this.getQueryOptions().getLimit().getMaxRows(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getQueryOptions().getFlushMode(), this.isReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), Collections.emptyMap(), this.getHints());
        }
        return new NamedHqlQueryMementoImpl<R>(name, this.getResultType(), this.getQueryString(), this.getQueryOptions().getLimit().getFirstRow(), this.getQueryOptions().getLimit().getMaxRows(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getQueryOptions().getFlushMode(), this.isReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), Collections.emptyMap(), this.getHints());
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        if (type.isInstance(this.parameterMetadata)) {
            return type.cast(this.parameterMetadata);
        }
        if (type.isInstance(this.parameterBindings)) {
            return type.cast(this.parameterBindings);
        }
        if (type.isInstance(this.sqm)) {
            return type.cast(this.sqm);
        }
        if (type.isInstance(this.getQueryOptions())) {
            return type.cast(this.getQueryOptions());
        }
        if (type.isInstance(this.getQueryOptions().getAppliedGraph())) {
            return type.cast(this.getQueryOptions().getAppliedGraph());
        }
        if (type.isInstance(this.getSession())) {
            return type.cast(this.getSession());
        }
        throw new PersistenceException("Unrecognized unwrap type [" + type.getName() + "]");
    }

    @Override
    public SqmQueryImplementor<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        super.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        super.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    public SqmQueryImplementor<R> setTimeout(Integer timeout) {
        if (timeout == null) {
            timeout = -1;
        }
        this.setTimeout((int)timeout);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setQueryPlanCacheable(boolean queryPlanCacheable) {
        super.setQueryPlanCacheable(queryPlanCacheable);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setProperties(Map bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(String name, P value, Class<P> javaType) {
        super.setParameter(name, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(String name, P value, Type<P> type) {
        super.setParameter(name, (Object)value, (Type)type);
        return this;
    }

    @Override
    @Deprecated
    public SqmQueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(int position, P value, Class<P> javaType) {
        super.setParameter(position, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(int position, P value, Type<P> type) {
        super.setParameter(position, (Object)value, (Type)type);
        return this;
    }

    @Override
    @Deprecated
    public SqmQueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, Type<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Type)type);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    @Deprecated
    public SqmQueryImplementor<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmQueryImplementor<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmQueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmQueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmQueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmQueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(name, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(String name, Collection<? extends P> values, Type<P> type) {
        super.setParameterList(name, (Collection)values, (Type)type);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(String name, P[] values, Class<P> javaType) {
        super.setParameterList(name, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(String name, P[] values, Type<P> type) {
        super.setParameterList(name, (Object[])values, (Type)type);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(position, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(int position, Collection<? extends P> values, Type<P> type) {
        super.setParameterList(position, (Collection)values, (Type)type);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(int position, P[] values, Class<P> javaType) {
        super.setParameterList(position, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(int position, P[] values, Type<P> type) {
        super.setParameterList(position, (Object[])values, (Type)type);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList((QueryParameter)parameter, (Collection)values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Type<P> type) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Type)type);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList((QueryParameter)parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, Type<P> type) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Type)type);
        return this;
    }

    private static class UniqueSemanticFilterQueryOption
    extends DelegatingQueryOptions {
        private UniqueSemanticFilterQueryOption(QueryOptions queryOptions) {
            super(queryOptions);
        }

        @Override
        public ListResultsConsumer.UniqueSemantic getUniqueSemantic() {
            return ListResultsConsumer.UniqueSemantic.FILTER;
        }
    }
}

