/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class SimpleInsertQueryPlan
implements NonSelectQueryPlan {
    private final SqmInsertStatement<?> sqmInsert;
    private final DomainParameterXref domainParameterXref;
    private Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions;
    private JdbcOperationQueryMutation jdbcInsert;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;

    public SimpleInsertQueryPlan(SqmInsertStatement<?> sqmInsert, DomainParameterXref domainParameterXref) {
        this.sqmInsert = sqmInsert;
        this.domainParameterXref = domainParameterXref;
    }

    private SqlAstTranslator<? extends JdbcOperationQueryMutation> createInsertTranslator(DomainQueryExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        SqmTranslation<? extends MutationStatement> sqmInterpretation = factory.getQueryEngine().getSqmTranslatorFactory().createMutationTranslator(this.sqmInsert, executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), factory.getSqlTranslationEngine()).translate();
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
        this.paramTypeResolutions = sqmInterpretation.getSqmParameterMappingModelTypeResolutions();
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, sqmInterpretation.getSqlAst());
    }

    @Override
    public int executeUpdate(DomainQueryExecutionContext executionContext) {
        BulkOperationCleanupAction.schedule(executionContext.getSession(), this.sqmInsert);
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<? extends JdbcOperationQueryMutation> insertTranslator = null;
        if (this.jdbcInsert == null) {
            insertTranslator = this.createInsertTranslator(executionContext);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return SimpleInsertQueryPlan.this.paramTypeResolutions.get(parameter);
            }
        }, session);
        if (this.jdbcInsert != null && !this.jdbcInsert.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
            insertTranslator = this.createInsertTranslator(executionContext);
        }
        if (insertTranslator != null) {
            this.jdbcInsert = insertTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        }
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcInsert, jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext));
    }
}

