/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.hibernate.LockOptions;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sqm.spi.InterpretationsKeySource;

public final class SqmInterpretationsKey
implements QueryInterpretationCache.Key {
    private final Object query;
    private final Class<?> resultType;
    private final LockOptions lockOptions;
    private final TupleTransformer<?> tupleTransformer;
    private final ResultListTransformer<?> resultListTransformer;
    private final Collection<String> enabledFetchProfiles;
    private final int hashCode;

    public static SqmInterpretationsKey createInterpretationsKey(InterpretationsKeySource keySource) {
        if (SqmInterpretationsKey.isCacheable(keySource)) {
            Object query = keySource.getQueryStringCacheKey();
            return new SqmInterpretationsKey(query, query.hashCode(), keySource.getResultType(), keySource.getQueryOptions().getLockOptions(), keySource.getQueryOptions().getTupleTransformer(), keySource.getQueryOptions().getResultListTransformer(), SqmInterpretationsKey.memoryEfficientDefensiveSetCopy(keySource.getLoadQueryInfluencers().getEnabledFetchProfileNames()));
        }
        return null;
    }

    private static Collection<String> memoryEfficientDefensiveSetCopy(Set<String> set) {
        if (set == null) {
            return null;
        }
        return switch (set.size()) {
            case 0 -> null;
            case 1 -> Set.of(set.iterator().next());
            case 2 -> {
                Iterator<String> iterator = set.iterator();
                yield Set.of(iterator.next(), iterator.next());
            }
            default -> Set.copyOf(set);
        };
    }

    private static boolean isCacheable(InterpretationsKeySource keySource) {
        assert (keySource.getQueryOptions().getAppliedGraph() != null);
        return keySource.isQueryPlanCacheable() && !keySource.getLoadQueryInfluencers().hasEnabledFilters() && keySource.getQueryOptions().getAppliedGraph().getSemantic() == null && !keySource.hasMultiValuedParameterBindingsChecker().getAsBoolean();
    }

    public static QueryInterpretationCache.Key generateNonSelectKey(InterpretationsKeySource keyDetails) {
        return null;
    }

    private SqmInterpretationsKey(Object query, int hash, Class<?> resultType, LockOptions lockOptions, TupleTransformer<?> tupleTransformer, ResultListTransformer<?> resultListTransformer, Collection<String> enabledFetchProfiles) {
        this.query = query;
        this.hashCode = hash;
        this.resultType = resultType;
        this.lockOptions = lockOptions;
        this.tupleTransformer = tupleTransformer;
        this.resultListTransformer = resultListTransformer;
        this.enabledFetchProfiles = enabledFetchProfiles;
    }

    @Override
    public QueryInterpretationCache.Key prepareForStore() {
        return new SqmInterpretationsKey(this.query, this.hashCode, this.resultType, this.lockOptions.makeDefensiveCopy(), this.tupleTransformer, this.resultListTransformer, this.enabledFetchProfiles);
    }

    @Override
    public String getQueryString() {
        return this.query instanceof String ? (String)this.query : null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SqmInterpretationsKey)) {
            return false;
        }
        SqmInterpretationsKey that = (SqmInterpretationsKey)other;
        return this.hashCode == that.hashCode && this.query.equals(that.query) && Objects.equals(this.resultType, that.resultType) && Objects.equals(this.lockOptions, that.lockOptions) && Objects.equals(this.tupleTransformer, that.tupleTransformer) && Objects.equals(this.resultListTransformer, that.resultListTransformer) && Objects.equals(this.enabledFetchProfiles, that.enabledFetchProfiles);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

