/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import jakarta.persistence.metamodel.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.query.KeyedPage;
import org.hibernate.query.Order;
import org.hibernate.query.Page;
import org.hibernate.query.QueryFlushMode;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.internal.NamedCriteriaQueryMementoImpl;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.internal.DelegatingDomainQueryExecutionContext;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.SqmSelectionQuery;
import org.hibernate.query.sqm.internal.AbstractSqmSelectionQuery;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.KeyBasedPagination;
import org.hibernate.query.sqm.internal.KeyedResult;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.InterpretationsKeySource;
import org.hibernate.query.sqm.spi.SqmSelectionQueryImplementor;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.SingleResultConsumer;
import org.hibernate.type.BindableType;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmSelectionQueryImpl<R>
extends AbstractSqmSelectionQuery<R>
implements SqmSelectionQueryImplementor<R>,
InterpretationsKeySource {
    private final String hql;
    private Object queryStringCacheKey;
    private SqmSelectStatement<R> sqm;
    private ParameterMetadataImplementor parameterMetadata;
    private DomainParameterXref domainParameterXref;
    private QueryParameterBindings parameterBindings;
    private final Class<R> expectedResultType;
    private final Class<?> resultType;
    private final TupleMetadata tupleMetadata;

    public SqmSelectionQueryImpl(String hql, HqlInterpretation<R> hqlInterpretation, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        super(session);
        this.hql = hql;
        this.queryStringCacheKey = hql;
        SqmUtil.verifyIsSelectStatement(hqlInterpretation.getSqmStatement(), hql);
        this.sqm = (SqmSelectStatement)hqlInterpretation.getSqmStatement();
        this.parameterMetadata = hqlInterpretation.getParameterMetadata();
        this.domainParameterXref = hqlInterpretation.getDomainParameterXref();
        this.parameterBindings = this.parameterMetadata.createBindings(session.getFactory());
        this.expectedResultType = expectedResultType;
        this.resultType = SqmSelectionQueryImpl.determineResultType(this.sqm, expectedResultType);
        this.tupleMetadata = this.buildTupleMetadata(this.sqm, expectedResultType);
        hqlInterpretation.validateResultType(this.resultType);
        this.setComment(hql);
    }

    public SqmSelectionQueryImpl(NamedHqlQueryMementoImpl<?> memento, Class<R> resultType, SharedSessionContractImplementor session) {
        this(memento.getHqlString(), SqmSelectionQueryImpl.interpretation(memento, resultType, session), resultType, session);
        this.applySqmOptions(memento);
    }

    public SqmSelectionQueryImpl(NamedCriteriaQueryMementoImpl<?> memento, SqmSelectStatement<R> selectStatement, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        this(selectStatement, expectedResultType, session);
        this.applySqmOptions(memento);
    }

    public SqmSelectionQueryImpl(SqmSelectStatement<R> criteria, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        this(criteria, session.isCriteriaCopyTreeEnabled(), expectedResultType, session);
    }

    public SqmSelectionQueryImpl(SqmSelectStatement<R> criteria, boolean copyAst, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        super(session);
        this.expectedResultType = expectedResultType;
        this.hql = "<criteria>";
        if (copyAst) {
            this.sqm = criteria.copy(SqmCopyContext.simpleContext());
            if (session.isCriteriaPlanCacheEnabled()) {
                this.queryStringCacheKey = this.sqm.toHqlString();
                this.setQueryPlanCacheable(true);
            } else {
                this.queryStringCacheKey = this.sqm;
            }
        } else {
            this.sqm = criteria;
            this.queryStringCacheKey = session.isCriteriaPlanCacheEnabled() ? this.sqm.toHqlString() : this.sqm;
            this.setQueryPlanCacheable(true);
        }
        this.domainParameterXref = DomainParameterXref.from(this.sqm);
        this.parameterMetadata = this.domainParameterXref.hasParameters() ? new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters()) : ParameterMetadataImpl.EMPTY;
        this.parameterBindings = this.parameterMetadata.createBindings(session.getFactory());
        for (SqmParameter<?> sqmParameter : this.domainParameterXref.getParameterResolutions().getSqmParameters()) {
            if (!(sqmParameter instanceof SqmJpaCriteriaParameterWrapper)) continue;
            SqmJpaCriteriaParameterWrapper wrapper = (SqmJpaCriteriaParameterWrapper)sqmParameter;
            this.bindCriteriaParameter(wrapper);
        }
        this.resultType = SqmSelectionQueryImpl.determineResultType(this.sqm, expectedResultType);
        JpaQueryPart queryPart = this.sqm.getQueryPart();
        ((SqmQueryPart)queryPart).validateQueryStructureAndFetchOwners();
        SqmUtil.validateCriteriaQuery(queryPart);
        this.sqm.validateResultType(this.resultType);
        this.setComment(this.hql);
        this.tupleMetadata = this.buildTupleMetadata(this.sqm, expectedResultType);
    }

    <E> SqmSelectionQueryImpl(AbstractSqmSelectionQuery<?> original, KeyedPage<E> keyedPage) {
        super(original);
        Page page = keyedPage.getPage();
        List<Comparable<?>> key = keyedPage.getKey();
        List keyDefinition = keyedPage.getKeyDefinition();
        List appliedKeyDefinition = keyedPage.getKeyInterpretation() == KeyedPage.KeyInterpretation.KEY_OF_FIRST_ON_NEXT_PAGE ? Order.reverse(keyDefinition) : keyDefinition;
        this.sqm = KeyBasedPagination.paginate(appliedKeyDefinition, key, (SqmSelectStatement)original.getSqmStatement().copy(SqmCopyContext.noParamCopyContext(SqmQuerySource.CRITERIA)), original.getSqmStatement().nodeBuilder());
        if (this.getSession().isCriteriaPlanCacheEnabled()) {
            this.queryStringCacheKey = this.sqm.toHqlString();
            this.setQueryPlanCacheable(true);
        } else {
            this.queryStringCacheKey = this.sqm;
        }
        this.hql = "<criteria>";
        this.domainParameterXref = DomainParameterXref.from(this.sqm);
        this.parameterMetadata = this.domainParameterXref.hasParameters() ? new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters()) : ParameterMetadataImpl.EMPTY;
        this.parameterBindings = this.parameterMetadata.createBindings(original.getSession().getSessionFactory());
        original.getQueryParameterBindings().visitBindings(this::setBindValues);
        for (SqmParameter<?> sqmParameter : this.domainParameterXref.getParameterResolutions().getSqmParameters()) {
            if (!(sqmParameter instanceof SqmJpaCriteriaParameterWrapper)) continue;
            SqmJpaCriteriaParameterWrapper parameterWrapper = (SqmJpaCriteriaParameterWrapper)sqmParameter;
            this.bindCriteriaParameter(parameterWrapper);
        }
        this.expectedResultType = KeyedResult.class;
        this.resultType = SqmSelectionQueryImpl.determineResultType(this.sqm, this.expectedResultType);
        this.tupleMetadata = null;
        this.setMaxResults(page.getMaxResults() + 1);
        if (key == null) {
            this.setFirstResult(page.getFirstResult());
        }
    }

    private <T> void setBindValues(QueryParameter<?> parameter, QueryParameterBinding<T> binding) {
        QueryParameterBinding<T> parameterBinding = this.parameterBindings.getBinding(binding.getQueryParameter());
        TemporalType explicitTemporalPrecision = binding.getExplicitTemporalPrecision();
        if (explicitTemporalPrecision != null) {
            if (binding.isMultiValued()) {
                parameterBinding.setBindValues(binding.getBindValues(), explicitTemporalPrecision, this.getSessionFactory().getTypeConfiguration());
            } else {
                parameterBinding.setBindValue(binding.getBindValue(), explicitTemporalPrecision);
            }
        } else {
            BindableType<T> bindType = binding.getBindType();
            if (binding.isMultiValued()) {
                parameterBinding.setBindValues(binding.getBindValues(), bindType);
            } else {
                parameterBinding.setBindValue(binding.getBindValue(), bindType);
            }
        }
        parameterBinding.setType(binding.getType());
    }

    private static Class<?> determineResultType(SqmSelectStatement<?> sqm, Class<?> expectedResultType) {
        List<SqmSelection<?>> selections = ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections();
        if (selections.size() == 1) {
            JavaType<?> nodeJavaType;
            if (Object[].class.equals(expectedResultType)) {
                return Object[].class;
            }
            SqmSelection<?> selection = selections.get(0);
            if (SqmUtil.isSelectionAssignableToResultType(selection, expectedResultType) && (nodeJavaType = selection.getNodeJavaType()) != null) {
                return nodeJavaType.getJavaTypeClass();
            }
            return expectedResultType;
        }
        if (expectedResultType != null) {
            return expectedResultType;
        }
        return Object[].class;
    }

    @Override
    public TupleMetadata getTupleMetadata() {
        return this.tupleMetadata;
    }

    @Override
    public SqmSelectStatement<R> getSqmStatement() {
        return this.sqm;
    }

    @Override
    protected void setSqmStatement(SqmSelectStatement<R> sqm) {
        this.sqm = sqm;
        this.queryStringCacheKey = sqm;
        QueryParameterBindings oldParameterBindings = this.parameterBindings;
        this.domainParameterXref = DomainParameterXref.from(sqm);
        this.parameterMetadata = !this.domainParameterXref.hasParameters() ? ParameterMetadataImpl.EMPTY : new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters());
        this.parameterBindings = this.parameterMetadata.createBindings(this.getSessionFactory());
        this.copyParameterBindings(oldParameterBindings);
    }

    @Override
    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public String getQueryString() {
        return this.hql;
    }

    @Override
    public Object getQueryStringCacheKey() {
        return this.queryStringCacheKey;
    }

    @Override
    public <T> SqmSelectionQuery<T> setTupleTransformer(TupleTransformer<T> transformer) {
        this.getQueryOptions().setTupleTransformer(transformer);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setResultListTransformer(ResultListTransformer<R> transformer) {
        this.getQueryOptions().setResultListTransformer(transformer);
        return this;
    }

    @Override
    protected void prepareForExecution() {
        this.resetCallback();
    }

    @Override
    public long getResultCount() {
        DelegatingDomainQueryExecutionContext context = new DelegatingDomainQueryExecutionContext(this){

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }
        };
        return (Long)this.buildConcreteQueryPlan(((SqmSelectStatement)this.getSqmStatement()).createCountQuery(), Long.class, (TupleMetadata)null, this.getQueryOptions()).executeQuery(context, SingleResultConsumer.instance());
    }

    @Override
    protected List<R> doList() {
        SqmStatement statement = this.getSqmStatement();
        boolean containsCollectionFetches = ((SqmSelectStatement)statement).containsCollectionFetches();
        boolean hasLimit = SqmSelectionQueryImpl.hasLimit(statement, (MutableQueryOptions)this.getQueryOptions());
        boolean needsDistinct = this.needsDistinct(containsCollectionFetches, hasLimit, (SqmSelectStatement<?>)statement);
        List<R> list = this.resolveQueryPlan().performList(this.executionContext(hasLimit, containsCollectionFetches));
        return needsDistinct ? this.handleDistinct(hasLimit, (SqmSelectStatement<?>)statement, list) : list;
    }

    private List<R> handleDistinct(boolean hasLimit, SqmSelectStatement<?> statement, List<R> list) {
        int includedCount = -1;
        int first = this.first(hasLimit, statement);
        int max = this.max(hasLimit, statement, list);
        ArrayList<R> distinctList = new ArrayList<R>(list.size());
        IdentitySet<R> distinction = new IdentitySet<R>(list.size());
        for (R result : list) {
            if (!distinction.add(result) || ++includedCount < first) continue;
            distinctList.add(result);
            if (max < 0 || includedCount - first < max - 1) continue;
            break;
        }
        return distinctList;
    }

    private DomainQueryExecutionContext executionContext(boolean hasLimit, boolean containsCollectionFetches) {
        if (hasLimit && containsCollectionFetches) {
            this.errorOrLogForPaginationWithCollectionFetch();
            QueryOptions originalQueryOptions = this.getQueryOptions();
            final QueryOptions normalizedQueryOptions = SqlOmittingQueryOptions.omitSqlQueryOptions(originalQueryOptions, true, false);
            if (originalQueryOptions == normalizedQueryOptions) {
                return this;
            }
            return new DelegatingDomainQueryExecutionContext(this){

                @Override
                public QueryOptions getQueryOptions() {
                    return normalizedQueryOptions;
                }
            };
        }
        return this;
    }

    @Override
    protected ScrollableResultsImplementor<R> doScroll(ScrollMode scrollMode) {
        return this.resolveQueryPlan().performScroll(scrollMode, this);
    }

    @Override
    public <T> T executeQuery(ResultsConsumer<T, R> resultsConsumer) {
        return this.resolveQueryPlan().executeQuery(this, resultsConsumer);
    }

    @Override
    public Class<R> getExpectedResultType() {
        return this.expectedResultType;
    }

    private SelectQueryPlan<R> resolveQueryPlan() {
        SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey(this);
        if (cacheKey != null) {
            return this.getSessionFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan(cacheKey, this::buildSelectQueryPlan);
        }
        return this.buildSelectQueryPlan();
    }

    @Override
    public Class<?> getResultType() {
        return this.resultType;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.getSession().getLoadQueryInfluencers();
    }

    @Override
    public BooleanSupplier hasMultiValuedParameterBindingsChecker() {
        return this::hasMultiValuedParameterBindings;
    }

    protected boolean hasMultiValuedParameterBindings() {
        return this.getQueryParameterBindings().hasAnyMultiValuedBindings() || this.getParameterMetadata().hasAnyMatching(QueryParameter::allowsMultiValuedBinding);
    }

    @Override
    protected boolean resolveJdbcParameterTypeIfNecessary() {
        return false;
    }

    @Override
    public SqmSelectionQuery<R> setFlushMode(FlushModeType flushMode) {
        super.setFlushMode(flushMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setLockMode(LockModeType lockMode) {
        super.setLockMode(lockMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setHibernateLockMode(LockMode lockMode) {
        super.setHibernateLockMode(lockMode);
        return this;
    }

    @Override
    public SelectionQuery<R> setTimeout(Timeout timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public SelectionQuery<R> setLockScope(PessimisticLockScope lockScope) {
        super.setLockScope(lockScope);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setFollowOnLocking(boolean enable) {
        this.getLockOptions().setFollowOnLocking(enable);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        super.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        super.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setCacheRegion(String regionName) {
        super.setCacheRegion(regionName);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setQueryPlanCacheable(boolean queryPlanCacheable) {
        super.setQueryPlanCacheable(queryPlanCacheable);
        return this;
    }

    @Override
    public boolean isQueryPlanCacheable() {
        return "<criteria>".equals(this.hql) ? this.getQueryOptions().getQueryPlanCachingEnabled() == Boolean.TRUE : super.isQueryPlanCacheable();
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        AppliedGraph appliedGraph;
        super.collectHints(hints);
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getFetchSize());
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        }
        if ((appliedGraph = this.getQueryOptions().getAppliedGraph()) != null && appliedGraph.getSemantic() != null) {
            hints.put(appliedGraph.getSemantic().getJakartaHintName(), appliedGraph);
            hints.put(appliedGraph.getSemantic().getJpaHintName(), appliedGraph);
        }
        this.putIfNotNull(hints, "hibernate.query.followOnLocking", this.getQueryOptions().getLockOptions().getFollowOnLocking());
    }

    @Override
    public SqmSelectionQuery<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setQueryFlushMode(QueryFlushMode queryFlushMode) {
        super.setQueryFlushMode(queryFlushMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(String name, P value, Class<P> javaType) {
        super.setParameter(name, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(String name, P value, Type<P> type) {
        super.setParameter(name, (Object)value, (Type)type);
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectionQuery<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(int position, P value, Class<P> javaType) {
        super.setParameter(position, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(int position, P value, Type<P> type) {
        super.setParameter(position, (Object)value, (Type)type);
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectionQuery<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(QueryParameter<P> parameter, P value, Type<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Type)type);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectionQuery<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectionQuery<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectionQuery<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectionQuery<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectionQuery<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectionQuery<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(name, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(String name, Collection<? extends P> values, Type<P> type) {
        super.setParameterList(name, (Collection)values, (Type)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(String name, P[] values, Class<P> javaType) {
        super.setParameterList(name, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(String name, P[] values, Type<P> type) {
        super.setParameterList(name, (Object[])values, (Type)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(position, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(int position, Collection<? extends P> values, Type<P> type) {
        super.setParameterList(position, (Collection)values, (Type)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(int position, P[] values, Class<P> javaType) {
        super.setParameterList(position, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(int position, P[] values, Type<P> type) {
        super.setParameterList(position, (Object[])values, (Type)type);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList((QueryParameter)parameter, (Collection)values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Type<P> type) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Type)type);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList((QueryParameter)parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values, Type<P> type) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Type)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }
}

