/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SortDirection;
import org.hibernate.query.criteria.JpaConflictClause;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.results.internal.TableGroupImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.InsertHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SqmInsertStrategyHelper;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmConflictClause;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableGroup;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.BasicType;

public class CteInsertHandler
implements InsertHandler {
    public static final String DML_RESULT_TABLE_NAME_PREFIX = "dml_cte_";
    public static final String CTE_TABLE_IDENTIFIER = "id";
    public static final String ROW_NUMBERS_WITH_SEQUENCE_VALUE = "rows_with_next_val";
    private final SqmInsertStatement<?> sqmStatement;
    private final SessionFactoryImplementor sessionFactory;
    private final EntityMappingType entityDescriptor;
    private final CteTable cteTable;
    private final DomainParameterXref domainParameterXref;

    public CteInsertHandler(CteTable cteTable, SqmInsertStatement<?> sqmStatement, DomainParameterXref domainParameterXref, SessionFactoryImplementor sessionFactory) {
        this.sqmStatement = sqmStatement;
        this.sessionFactory = sessionFactory;
        String entityName = ((SqmRoot)this.sqmStatement.getTarget()).getModel().getHibernateEntityName();
        this.entityDescriptor = sessionFactory.getMappingMetamodel().getEntityDescriptor(entityName);
        this.cteTable = cteTable;
        this.domainParameterXref = domainParameterXref;
    }

    public static CteTable createCteTable(CteTable sqmCteTable, List<CteColumn> sqmCteColumns) {
        return new CteTable(sqmCteTable.getTableExpression(), sqmCteColumns);
    }

    public SqmInsertStatement<?> getSqmStatement() {
        return this.sqmStatement;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public CteTable getCteTable() {
        return this.cteTable;
    }

    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    private NodeBuilder getCriteriaBuilder() {
        return this.sessionFactory.getQueryEngine().getCriteriaBuilder();
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        CteStatement entityCte;
        SelectStatement queryStatement;
        SqmInsertStatement<?> sqmInsertStatement = this.getSqmStatement();
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        EntityPersister entityDescriptor = this.getEntityDescriptor().getEntityPersister();
        JpaRoot target = sqmInsertStatement.getTarget();
        String explicitDmlTargetAlias = ((AbstractSqmFrom)((Object)target)).getExplicitAlias() == null ? "dml_target" : ((AbstractSqmFrom)((Object)target)).getExplicitAlias();
        final MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)sqmInsertStatement, (SqmRoot<?>)target, explicitDmlTargetAlias, this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), factory.getSqlTranslationEngine());
        TableGroup insertingTableGroup = sqmConverter.getMutatingTableGroup();
        int size = this.sqmStatement.getInsertionTargetPaths().size();
        ArrayList<Map.Entry<List<CteColumn>, Assignment>> targetPathColumns = new ArrayList<Map.Entry<List<CteColumn>, Assignment>>(size);
        ArrayList<CteColumn> targetPathCteColumns = new ArrayList<CteColumn>(size);
        BaseSqmToSqlAstConverter.AdditionalInsertValues additionalInsertValues = sqmConverter.visitInsertionTargetPaths((assignable, columnReferences) -> {
            SqmPathInterpretation pathInterpretation = (SqmPathInterpretation)((Object)assignable);
            int offset = CteTable.determineModelPartStartIndex(entityDescriptor, pathInterpretation.getExpressionType());
            if (offset == -1) {
                throw new IllegalStateException("Couldn't find matching cte column for: " + String.valueOf(((Expression)((Object)assignable)).getExpressionType()));
            }
            int end = offset + pathInterpretation.getExpressionType().getJdbcTypeCount();
            List<CteColumn> columns = this.cteTable.getCteColumns().subList(offset, end);
            targetPathCteColumns.addAll(columns);
            targetPathColumns.add(new AbstractMap.SimpleEntry<List<CteColumn>, Assignment>(columns, new Assignment((Assignable)assignable, (Expression)((Object)assignable))));
        }, sqmInsertStatement, entityDescriptor, insertingTableGroup);
        boolean assignsId = targetPathCteColumns.contains(this.cteTable.getCteColumns().get(0));
        Stack<SqlAstProcessingState> processingStateStack = sqmConverter.getProcessingStateStack();
        SqlAstProcessingState oldState = processingStateStack.pop();
        if (sqmInsertStatement instanceof SqmInsertSelectStatement) {
            Object queryPart = sqmConverter.visitQueryPart((SqmQueryPart)((SqmInsertSelectStatement)sqmInsertStatement).getSelectQueryPart());
            ((QueryPart)queryPart).visitQuerySpecs(querySpec -> {
                if (additionalInsertValues.applySelections((QuerySpec)querySpec, this.sessionFactory)) {
                    CteColumn rowNumberColumn = this.cteTable.getCteColumns().get(this.cteTable.getCteColumns().size() - 1);
                    targetPathCteColumns.set(targetPathCteColumns.size() - 1, rowNumberColumn);
                }
                if (!assignsId && entityDescriptor.getGenerator().generatedOnExecution()) {
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, SqmInsertStrategyHelper.createRowNumberingExpression(querySpec, this.sessionFactory)));
                }
            });
            queryStatement = new SelectStatement((QueryPart)queryPart);
        } else {
            List<SqmValues> sqmValuesList = ((SqmInsertValuesStatement)sqmInsertStatement).getValuesList();
            ArrayList<Values> valuesList = new ArrayList<Values>(sqmValuesList.size());
            for (SqmValues sqmValues : sqmValuesList) {
                Values values = sqmConverter.visitValues(sqmValues);
                additionalInsertValues.applyValues(values);
                valuesList.add(values);
            }
            QuerySpec querySpec2 = new QuerySpec(true);
            NavigablePath navigablePath = new NavigablePath(entityDescriptor.getRootPathName());
            ArrayList<String> columnNames = new ArrayList<String>(targetPathColumns.size());
            String valuesAlias = insertingTableGroup.getPrimaryTableReference().getIdentificationVariable();
            for (Map.Entry entry : targetPathColumns) {
                for (ColumnReference columnReference : ((Assignment)entry.getValue()).getAssignable().getColumnReferences()) {
                    columnNames.add(columnReference.getColumnExpression());
                    querySpec2.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, columnReference.getQualifier().equals(valuesAlias) ? columnReference : new ColumnReference(valuesAlias, columnReference.getColumnExpression(), false, null, columnReference.getJdbcMapping())));
                }
            }
            ValuesTableGroup valuesTableGroup = new ValuesTableGroup(navigablePath, entityDescriptor.getEntityPersister(), valuesList, insertingTableGroup.getPrimaryTableReference().getIdentificationVariable(), columnNames, true, factory);
            querySpec2.getFromClause().addRoot(valuesTableGroup);
            queryStatement = new SelectStatement(querySpec2);
        }
        processingStateStack.push(oldState);
        sqmConverter.pruneTableGroupJoins();
        if (!assignsId && entityDescriptor.getGenerator().generatedOnExecution()) {
            CteColumn rowNumberColumn = this.cteTable.getCteColumns().get(this.cteTable.getCteColumns().size() - 1);
            targetPathCteColumns.add(rowNumberColumn);
        }
        CteTable entityCteTable = CteInsertHandler.createCteTable(this.getCteTable(), targetPathCteColumns);
        QuerySpec querySpec3 = new QuerySpec(true, 1);
        ArrayList domainResults = new ArrayList(1);
        SelectStatement statement = new SelectStatement(querySpec3, domainResults);
        if (additionalInsertValues.requiresRowNumberIntermediate()) {
            CteTable finalEntityCteTable;
            CteTable fullEntityCteTable = this.getCteTable();
            String baseTableName = "base_" + entityCteTable.getTableExpression();
            CteStatement cteStatement = new CteStatement(entityCteTable.withName(baseTableName), queryStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(cteStatement);
            CteColumn rowNumberColumn = fullEntityCteTable.getCteColumns().get(fullEntityCteTable.getCteColumns().size() - 1);
            ColumnReference rowNumberColumnReference = new ColumnReference("e", rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping());
            CteColumn idColumn = fullEntityCteTable.getCteColumns().get(0);
            BasicValuedMapping idType = (BasicValuedMapping)((Object)idColumn.getJdbcMapping());
            Optimizer optimizer = ((OptimizableGenerator)entityDescriptor.getGenerator()).getOptimizer();
            BasicValuedMapping integerType = (BasicValuedMapping)((Object)rowNumberColumn.getJdbcMapping());
            BinaryArithmeticExpression rowNumberMinusOneModuloIncrement = new BinaryArithmeticExpression(new BinaryArithmeticExpression(rowNumberColumnReference, BinaryArithmeticOperator.SUBTRACT, new QueryLiteral<Integer>(1, (BasicValuedMapping)((Object)rowNumberColumn.getJdbcMapping())), integerType), BinaryArithmeticOperator.MODULO, new QueryLiteral<Integer>(optimizer.getIncrementSize(), integerType), integerType);
            QuerySpec rowsWithSequenceQuery = new QuerySpec(true);
            rowsWithSequenceQuery.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(baseTableName, "e")));
            rowsWithSequenceQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, rowNumberColumnReference));
            BulkInsertionCapableIdentifierGenerator generator = (BulkInsertionCapableIdentifierGenerator)entityDescriptor.getGenerator();
            String fragment = generator.determineBulkInsertionIdentifierGenerationSelectFragment(this.sessionFactory.getSqlStringGenerationContext());
            rowsWithSequenceQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, new SelfRenderingSqlFragmentExpression(fragment)));
            rowsWithSequenceQuery.applyPredicate(new ComparisonPredicate(rowNumberMinusOneModuloIncrement, ComparisonOperator.EQUAL, new QueryLiteral<Integer>(0, integerType)));
            CteTable rowsWithSequenceCteTable = new CteTable(ROW_NUMBERS_WITH_SEQUENCE_VALUE, List.of(rowNumberColumn, idColumn));
            SelectStatement rowsWithSequenceStatement = new SelectStatement(rowsWithSequenceQuery);
            CteStatement rowsWithSequenceCte = new CteStatement(rowsWithSequenceCteTable, rowsWithSequenceStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(rowsWithSequenceCte);
            QuerySpec entityQuery = new QuerySpec(true);
            NavigablePath navigablePath = new NavigablePath(baseTableName);
            TableGroupImpl baseTableGroup = new TableGroupImpl(navigablePath, null, new NamedTableReference(baseTableName, "e"), null);
            CteTableGroup rowsWithSequenceTableGroup = new CteTableGroup(new NamedTableReference(ROW_NUMBERS_WITH_SEQUENCE_VALUE, "t"));
            baseTableGroup.addTableGroupJoin(new TableGroupJoin(rowsWithSequenceTableGroup.getNavigablePath(), SqlAstJoinType.LEFT, rowsWithSequenceTableGroup, new ComparisonPredicate(new BinaryArithmeticExpression(rowNumberColumnReference, BinaryArithmeticOperator.SUBTRACT, rowNumberMinusOneModuloIncrement, integerType), ComparisonOperator.EQUAL, new ColumnReference("t", rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping()))));
            entityQuery.getFromClause().addRoot(baseTableGroup);
            entityQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, new BinaryArithmeticExpression(new ColumnReference("t", idColumn.getColumnExpression(), false, null, idColumn.getJdbcMapping()), BinaryArithmeticOperator.ADD, new BinaryArithmeticExpression(rowNumberColumnReference, BinaryArithmeticOperator.SUBTRACT, new ColumnReference("t", rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping()), integerType), idType)));
            if (targetPathCteColumns.contains(this.getCteTable().getCteColumns().get(0))) {
                finalEntityCteTable = entityCteTable;
            } else {
                targetPathCteColumns.add(0, this.getCteTable().getCteColumns().get(0));
                finalEntityCteTable = CteInsertHandler.createCteTable(this.getCteTable(), targetPathCteColumns);
            }
            List<CteColumn> cteColumns = finalEntityCteTable.getCteColumns();
            for (int i = 1; i < cteColumns.size(); ++i) {
                CteColumn cteColumn = cteColumns.get(i);
                entityQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(i, new ColumnReference("e", cteColumn.getColumnExpression(), false, null, cteColumn.getJdbcMapping())));
            }
            SelectStatement entityStatement = new SelectStatement(entityQuery);
            entityCte = new CteStatement(finalEntityCteTable, entityStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(entityCte);
        } else if (!assignsId && entityDescriptor.getGenerator().generatedOnExecution()) {
            String baseTableName = "base_" + entityCteTable.getTableExpression();
            CteStatement baseEntityCte = new CteStatement(entityCteTable.withName(baseTableName), queryStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(baseEntityCte);
            targetPathCteColumns.add(0, this.cteTable.getCteColumns().get(0));
            CteTable cteTable = CteInsertHandler.createCteTable(this.getCteTable(), targetPathCteColumns);
            QuerySpec finalQuerySpec = new QuerySpec(true);
            SelectStatement finalQueryStatement = new SelectStatement(finalQuerySpec);
            entityCte = new CteStatement(cteTable, finalQueryStatement, CteMaterialization.MATERIALIZED);
        } else {
            entityCte = new CteStatement(entityCteTable, queryStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(entityCte);
        }
        String baseInsertCte = this.addDmlCtes(statement, entityCte, targetPathColumns, assignsId, sqmConverter, factory);
        Expression count = this.createCountStar(factory, sqmConverter);
        domainResults.add(new BasicResult(0, null, ((SqlExpressible)((Object)count)).getJdbcMapping()));
        querySpec3.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, count));
        querySpec3.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(baseInsertCte, CTE_TABLE_IDENTIFIER)));
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<JdbcOperationQuerySelect> translator = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, statement);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, SqmUtil.generateJdbcParamsXref(this.domainParameterXref, sqmConverter), new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmConverter.getSqmParameterMappingModelExpressibleResolutions().get(parameter);
            }
        }, executionContext.getSession());
        JdbcOperationQuerySelect select = translator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        executionContext.getSession().autoFlushIfRequired(select.getAffectedTableNames());
        List list = jdbcServices.getJdbcSelectExecutor().list(select, jdbcParameterBindings, SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext), RowTransformerSingularReturnImpl.instance(), null, ListResultsConsumer.UniqueSemantic.NONE, 1);
        return ((Number)list.get(0)).intValue();
    }

    protected Expression createCountStar(SessionFactoryImplementor factory, MultiTableSqmMutationConverter sqmConverter) {
        SqmStar arg = new SqmStar(this.getCriteriaBuilder());
        return factory.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("count").generateSqmExpression(arg, null, factory.getQueryEngine()).convertToSqlAst(sqmConverter);
    }

    protected String addDmlCtes(CteContainer statement, CteStatement queryCte, List<Map.Entry<List<CteColumn>, Assignment>> assignments, boolean assignsId, MultiTableSqmMutationConverter sqmConverter, SessionFactoryImplementor factory) {
        TableGroup updatingTableGroup = sqmConverter.getMutatingTableGroup();
        EntityMappingType entityDescriptor = this.getEntityDescriptor();
        EntityPersister entityPersister = entityDescriptor.getEntityPersister();
        String rootEntityName = entityPersister.getRootEntityName();
        EntityPersister rootEntityDescriptor = factory.getMappingMetamodel().getEntityDescriptor(rootEntityName);
        String hierarchyRootTableName = rootEntityDescriptor.getTableName();
        TableReference hierarchyRootTableReference = updatingTableGroup.resolveTableReference(updatingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(updatingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < updatingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(updatingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        HashMap assignmentsByTable = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        for (int i = 0; i < assignments.size(); ++i) {
            Map.Entry<List<CteColumn>, Assignment> entry = assignments.get(i);
            Assignment assignment = entry.getValue();
            List<ColumnReference> assignmentColumnRefs = assignment.getAssignable().getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, tableReferenceByAlias);
                if (assignmentTableReference != null && !assignmentTableReference.equals(tableReference)) {
                    throw new IllegalStateException("Assignment referred to columns from multiple tables");
                }
                assignmentTableReference = tableReference;
            }
            assert (assignmentTableReference != null);
            ArrayList<Map.Entry<List<CteColumn>, Assignment>> assignmentsForTable = (ArrayList<Map.Entry<List<CteColumn>, Assignment>>)assignmentsByTable.get(assignmentTableReference);
            if (assignmentsForTable == null) {
                assignmentsForTable = new ArrayList<Map.Entry<List<CteColumn>, Assignment>>();
                assignmentsByTable.put(assignmentTableReference, assignmentsForTable);
            }
            assignmentsForTable.add(entry);
        }
        EntityPersister persister = entityDescriptor.getEntityPersister();
        String rootTableName = persister.getTableName(0);
        TableReference rootTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), rootTableName, true);
        Generator identifierGenerator = entityDescriptor.getEntityPersister().getGenerator();
        List tableAssignments = (List)assignmentsByTable.get(rootTableReference);
        if ((tableAssignments == null || tableAssignments.isEmpty()) && !identifierGenerator.generatedOnExecution()) {
            throw new IllegalStateException("There must be at least a single root table assignment");
        }
        Object conflictClause = sqmConverter.visitConflictClause((SqmConflictClause)this.sqmStatement.getConflictClause());
        int tableSpan = persister.getTableSpan();
        String[] rootKeyColumns = persister.getKeyColumns(0);
        List<CteColumn> keyCteColumns = queryCte.getCteTable().getCteColumns().subList(0, rootKeyColumns.length);
        for (int tableIndex = 0; tableIndex < tableSpan; ++tableIndex) {
            List<ColumnReference> insertColumnReferences;
            CteTable dmlResultCte;
            String tableExpression = persister.getTableName(tableIndex);
            TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), tableExpression, true);
            List assignmentList = (List)assignmentsByTable.get(updatingTableReference);
            NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
            String[] keyColumns = persister.getKeyColumns(tableIndex);
            ArrayList<ColumnReference> returningColumnReferences = new ArrayList<ColumnReference>(keyColumns.length + (assignmentList == null ? 0 : assignmentList.size()));
            QuerySpec insertSelectSpec = new QuerySpec(true);
            CteStatement finalCteStatement = null;
            if (tableIndex == 0 && !assignsId && identifierGenerator.generatedOnExecution()) {
                cteTableName = this.getCteTableName(tableExpression, "base_");
                if (statement.getCteStatement(cteTableName) != null) continue;
                String baseTableName = "base_" + queryCte.getCteTable().getTableExpression();
                insertSelectSpec.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(baseTableName, "e")));
                CteColumn rowNumberColumn = queryCte.getCteTable().getCteColumns().get(queryCte.getCteTable().getCteColumns().size() - 1);
                ColumnReference rowNumberColumnReference = new ColumnReference("e", rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping());
                insertSelectSpec.addSortSpecification(new SortSpecification(rowNumberColumnReference, SortDirection.ASCENDING));
                dmlResultCte = new CteTable(cteTableName, keyCteColumns);
                for (int j = 0; j < keyColumns.length; ++j) {
                    returningColumnReferences.add(new ColumnReference(dmlTableReference, keyColumns[j], false, null, null));
                }
                insertColumnReferences = Collections.emptyList();
                SelectStatement queryStatement = (SelectStatement)queryCte.getCteDefinition();
                QuerySpec querySpec = queryStatement.getQuerySpec();
                NavigablePath navigablePath = new NavigablePath(baseTableName);
                TableGroupImpl baseTableGroup = new TableGroupImpl(navigablePath, null, new NamedTableReference(baseTableName, "e"), null);
                CteTableGroup rootInsertCteTableGroup = new CteTableGroup(new NamedTableReference(this.getCteTableName(tableExpression), "t"));
                baseTableGroup.addTableGroupJoin(new TableGroupJoin(rootInsertCteTableGroup.getNavigablePath(), SqlAstJoinType.INNER, rootInsertCteTableGroup, new ComparisonPredicate(rowNumberColumnReference, ComparisonOperator.EQUAL, new ColumnReference("t", rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping()))));
                querySpec.getFromClause().addRoot(baseTableGroup);
                List<CteColumn> cteColumns = queryCte.getCteTable().getCteColumns();
                CteColumn idCteColumn = cteColumns.get(0);
                querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(new ColumnReference("t", idCteColumn.getColumnExpression(), false, null, idCteColumn.getJdbcMapping())));
                for (int j = 1; j < cteColumns.size(); ++j) {
                    CteColumn cteColumn = cteColumns.get(j);
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(new ColumnReference("e", cteColumn.getColumnExpression(), false, null, cteColumn.getJdbcMapping())));
                }
                ArrayList<CteColumn> finalReturningColumns = new ArrayList<CteColumn>(keyCteColumns.size() + 1);
                finalReturningColumns.addAll(keyCteColumns);
                finalReturningColumns.add(rowNumberColumn);
                CteTable finalResultCte = new CteTable(this.getCteTableName(tableExpression), finalReturningColumns);
                QuerySpec finalResultQuery = new QuerySpec(true);
                finalResultQuery.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(dmlResultCte.getTableExpression(), "e")));
                ColumnReference idColumnReference = new ColumnReference("e", idCteColumn.getColumnExpression(), false, null, idCteColumn.getJdbcMapping());
                finalResultQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(idColumnReference));
                finalResultQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(SqmInsertStrategyHelper.createRowNumberingExpression(querySpec, this.sessionFactory)));
                finalResultQuery.addSortSpecification(new SortSpecification(idColumnReference, SortDirection.ASCENDING));
                SelectStatement finalResultStatement = new SelectStatement(finalResultQuery);
                finalCteStatement = new CteStatement(finalResultCte, finalResultStatement);
            } else {
                cteTableName = this.getCteTableName(tableExpression);
                if (statement.getCteStatement(cteTableName) != null) continue;
                insertSelectSpec.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(queryCte.getCteTable().getTableExpression(), "e")));
                dmlResultCte = new CteTable(cteTableName, keyCteColumns);
                for (int j = 0; j < keyColumns.length; ++j) {
                    returningColumnReferences.add(new ColumnReference(dmlTableReference, keyColumns[j], false, null, null));
                    insertSelectSpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(new ColumnReference("e", rootKeyColumns[j], false, null, null)));
                }
                insertColumnReferences = returningColumnReferences;
            }
            InsertSelectStatement dmlStatement = new InsertSelectStatement(dmlTableReference, returningColumnReferences);
            dmlStatement.addTargetColumnReferences(insertColumnReferences);
            if (assignmentList != null) {
                for (Map.Entry entry : assignmentList) {
                    Assignment assignment = (Assignment)entry.getValue();
                    if (assignment.getAssignedValue().getExpressionType() instanceof EntityIdentifierMapping) continue;
                    List<ColumnReference> assignmentReferences = assignment.getAssignable().getColumnReferences();
                    dmlStatement.addTargetColumnReferences(assignmentReferences);
                    int size = assignmentReferences.size();
                    for (int j = 0; j < size; ++j) {
                        ColumnReference columnReference = assignmentReferences.get(j);
                        insertSelectSpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(new ColumnReference("e", ((CteColumn)((List)entry.getKey()).get(j)).getColumnExpression(), columnReference.isColumnExpressionFormula(), null, columnReference.getJdbcMapping())));
                    }
                }
            }
            dmlStatement.setSourceSelectStatement(insertSelectSpec);
            if (conflictClause != null) {
                if (((ConflictClause)conflictClause).isDoNothing() && ((ConflictClause)conflictClause).getConstraintColumnNames().isEmpty()) {
                    this.handleConflictClause(dmlResultCte, dmlStatement, queryCte, tableIndex, (ConflictClause)conflictClause, statement);
                } else {
                    List<Assignment> compatibleAssignments = this.getCompatibleAssignments(dmlStatement, (ConflictClause)conflictClause);
                    if (this.isIdentifierConflictClause(this.sqmStatement)) {
                        this.handleConflictClause(dmlResultCte, dmlStatement, queryCte, tableIndex, new ConflictClause(((ConflictClause)conflictClause).getConstraintName(), Arrays.asList(keyColumns), compatibleAssignments, compatibleAssignments.isEmpty() ? null : ((ConflictClause)conflictClause).getPredicate()), statement);
                    } else if (this.targetColumnsContainAllConstraintColumns(dmlStatement, (ConflictClause)conflictClause)) {
                        this.handleConflictClause(dmlResultCte, dmlStatement, queryCte, tableIndex, new ConflictClause(((ConflictClause)conflictClause).getConstraintName(), ((ConflictClause)conflictClause).getConstraintColumnNames(), compatibleAssignments, compatibleAssignments.isEmpty() ? null : ((ConflictClause)conflictClause).getPredicate()), statement);
                    } else {
                        statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
                    }
                }
            } else {
                statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
            }
            if (finalCteStatement != null) {
                statement.addCteStatement(finalCteStatement);
            }
            if (tableIndex != 0 || assignsId || !identifierGenerator.generatedOnExecution()) continue;
            statement.addCteStatement(queryCte);
        }
        return this.getCteTableName(rootTableName);
    }

    private void handleConflictClause(CteTable dmlResultCte, InsertSelectStatement insertStatement, CteStatement queryCte, int tableIndex, ConflictClause conflictClause, CteContainer statement) {
        if (this.sessionFactory.getJdbcServices().getDialect().supportsConflictClauseForInsertCTE()) {
            insertStatement.setConflictClause(conflictClause);
            statement.addCteStatement(new CteStatement(dmlResultCte, insertStatement));
        } else {
            List<String> columnsToMatch;
            NodeBuilder nodeBuilder = this.getCriteriaBuilder();
            BasicType<Boolean> booleanType = nodeBuilder.getBooleanType();
            List<String> constraintColumnNames = conflictClause.getConstraintColumnNames();
            QuerySpec insertQuerySpec = (QuerySpec)insertStatement.getSourceSelectStatement();
            QuerySpec subquery = new QuerySpec(false, 1);
            StandardTableGroup tableGroup = new StandardTableGroup(false, new NavigablePath("excluded"), this.entityDescriptor, null, new NamedTableReference(insertStatement.getTargetTable().getTableExpression(), "excluded"), null, this.sessionFactory);
            subquery.getSelectClause().addSqlSelection(new SqlSelectionImpl(new QueryLiteral<Integer>(1, nodeBuilder.getIntegerType())));
            subquery.getFromClause().addRoot(tableGroup);
            if (constraintColumnNames.isEmpty()) {
                columnsToMatch = Arrays.asList(((EntityPersister)this.entityDescriptor).getKeyColumns(tableIndex));
                Predicate predicate = this.buildColumnMatchPredicate(columnsToMatch, insertStatement, false, true);
                if (predicate == null) {
                    throw new IllegalArgumentException("Couldn't infer conflict constraint columns");
                }
                subquery.applyPredicate(predicate);
            } else {
                columnsToMatch = constraintColumnNames;
                subquery.applyPredicate(this.buildColumnMatchPredicate(constraintColumnNames, insertStatement, true, true));
            }
            insertQuerySpec.applyPredicate(new ExistsPredicate(subquery, true, booleanType));
            if (conflictClause.isDoUpdate()) {
                UpdateStatement updateStatement;
                TableGroup temporaryTableGroup = insertQuerySpec.getFromClause().getRoots().get(0);
                QuerySpec renamingSubquery = new QuerySpec(false, 1);
                List<String> columnNames = this.buildCteRenaming(renamingSubquery, temporaryTableGroup, queryCte);
                renamingSubquery.getFromClause().addRoot(temporaryTableGroup);
                QueryPartTableGroup excludedTableGroup = new QueryPartTableGroup(new NavigablePath("excluded"), null, new SelectStatement(renamingSubquery), "excluded", columnNames, false, false, this.sessionFactory);
                if (this.sessionFactory.getJdbcServices().getDialect().supportsFromClauseInUpdate()) {
                    FromClause fromClause = new FromClause(1);
                    StandardTableGroup updateTableGroup = new StandardTableGroup(false, new NavigablePath("updated"), this.entityDescriptor, null, insertStatement.getTargetTable(), null, this.sessionFactory);
                    fromClause.addRoot(updateTableGroup);
                    updateStatement = new UpdateStatement(insertStatement.getTargetTable(), fromClause, conflictClause.getAssignments(), conflictClause.getPredicate(), insertStatement.getReturningColumns());
                    updateTableGroup.addTableGroupJoin(new TableGroupJoin(excludedTableGroup.getNavigablePath(), SqlAstJoinType.INNER, excludedTableGroup, this.buildColumnMatchPredicate(columnsToMatch, insertStatement, true, false)));
                } else {
                    List<Assignment> assignments = conflictClause.getAssignments();
                    ArrayList<ColumnReference> assignmentColumns = new ArrayList<ColumnReference>(assignments.size());
                    QuerySpec updateSubquery = new QuerySpec(false, 1);
                    for (Assignment assignment : assignments) {
                        assignmentColumns.add((ColumnReference)assignment.getAssignable());
                        updateSubquery.getSelectClause().addSqlSelection(new SqlSelectionImpl(assignment.getAssignedValue()));
                    }
                    updateSubquery.getFromClause().addRoot(excludedTableGroup);
                    updateSubquery.applyPredicate(this.buildColumnMatchPredicate(columnsToMatch, insertStatement, true, false));
                    QuerySpec matchCteSubquery = new QuerySpec(false, 1);
                    matchCteSubquery.getSelectClause().addSqlSelection(new SqlSelectionImpl(new QueryLiteral<Integer>(1, this.getCriteriaBuilder().getIntegerType())));
                    matchCteSubquery.getFromClause().addRoot(updateSubquery.getFromClause().getRoots().get(0));
                    matchCteSubquery.applyPredicate(updateSubquery.getWhereClauseRestrictions());
                    updateStatement = new UpdateStatement(insertStatement.getTargetTable(), List.of(new Assignment(new SqlTuple(assignmentColumns, null), new SelectStatement(updateSubquery))), Predicate.combinePredicates(new ExistsPredicate(matchCteSubquery, false, booleanType), conflictClause.getPredicate()), insertStatement.getReturningColumns());
                }
                CteTable updateCte = dmlResultCte.withName(dmlResultCte.getTableExpression() + "_upd");
                statement.addCteStatement(new CteStatement(updateCte, updateStatement));
                CteTable insertCte = dmlResultCte.withName(dmlResultCte.getTableExpression() + "_ins");
                statement.addCteStatement(new CteStatement(insertCte, insertStatement));
                ArrayList<QueryPart> queryParts = new ArrayList<QueryPart>(2);
                QuerySpec dmlCombinationQ1 = new QuerySpec(false, 1);
                QuerySpec dmlCombinationQ2 = new QuerySpec(false, 1);
                dmlCombinationQ1.getSelectClause().addSqlSelection(new SqlSelectionImpl(new Star()));
                dmlCombinationQ2.getSelectClause().addSqlSelection(new SqlSelectionImpl(new Star()));
                dmlCombinationQ1.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(updateCte.getTableExpression(), "t")));
                dmlCombinationQ2.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(insertCte.getTableExpression(), "t")));
                queryParts.add(dmlCombinationQ1);
                queryParts.add(dmlCombinationQ2);
                SelectStatement dmlCombinationStatement = new SelectStatement(new QueryGroup(true, SetOperator.UNION_ALL, queryParts));
                statement.addCteStatement(new CteStatement(dmlResultCte, dmlCombinationStatement));
            } else {
                statement.addCteStatement(new CteStatement(dmlResultCte, insertStatement));
            }
        }
    }

    private List<String> buildCteRenaming(QuerySpec renamingSubquery, TableGroup temporaryTableGroup, CteStatement queryCte) {
        List<CteColumn> cteColumns = queryCte.getCteTable().getCteColumns();
        for (CteColumn cteColumn : cteColumns) {
            renamingSubquery.getSelectClause().addSqlSelection(new SqlSelectionImpl(new ColumnReference(temporaryTableGroup.getPrimaryTableReference(), cteColumn.getColumnExpression(), cteColumn.getJdbcMapping())));
        }
        SelectStatement selectStatement = (SelectStatement)queryCte.getCteDefinition();
        QuerySpec querySpec = (QuerySpec)selectStatement.getQueryPart();
        DerivedTableReference tableReference = (DerivedTableReference)querySpec.getFromClause().getRoots().get(0).getPrimaryTableReference();
        return tableReference.getColumnNames();
    }

    private Predicate buildColumnMatchPredicate(List<String> constraintColumnNames, InsertSelectStatement dmlStatement, boolean errorIfMissing, boolean compareAgainstSelectItems) {
        BasicType<Boolean> booleanType = this.getCriteriaBuilder().getBooleanType();
        QuerySpec insertQuerySpec = (QuerySpec)dmlStatement.getSourceSelectStatement();
        Predicate predicate = null;
        block0: for (String constraintColumnName : constraintColumnNames) {
            List<ColumnReference> targetColumns = dmlStatement.getTargetColumns();
            for (int i = 0; i < targetColumns.size(); ++i) {
                ColumnReference columnReference = targetColumns.get(i);
                if (!columnReference.getColumnExpression().equals(constraintColumnName)) continue;
                if (compareAgainstSelectItems) {
                    predicate = Predicate.combinePredicates(predicate, new ComparisonPredicate(new ColumnReference("excluded", columnReference.getColumnExpression(), false, null, columnReference.getJdbcMapping()), ComparisonOperator.EQUAL, insertQuerySpec.getSelectClause().getSqlSelections().get(i).getExpression(), booleanType));
                    continue block0;
                }
                predicate = Predicate.combinePredicates(predicate, new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, new ColumnReference("excluded", columnReference.getColumnExpression(), false, null, columnReference.getJdbcMapping()), booleanType));
                continue block0;
            }
            if (errorIfMissing) {
                List targetColumnNames = targetColumns.stream().map(ColumnReference::getColumnExpression).collect(Collectors.toList());
                throw new IllegalArgumentException("Couldn't find conflict constraint column [" + constraintColumnName + "] in insert target columns: " + String.valueOf(targetColumnNames));
            }
            return null;
        }
        return predicate;
    }

    private List<Assignment> getCompatibleAssignments(InsertSelectStatement dmlStatement, ConflictClause conflictClause) {
        if (conflictClause.isDoNothing()) {
            return Collections.emptyList();
        }
        ArrayList<Assignment> compatibleAssignments = null;
        List<Assignment> assignments = conflictClause.getAssignments();
        block0: for (Assignment assignment : assignments) {
            for (ColumnReference targetColumn : dmlStatement.getTargetColumns()) {
                if (!assignment.getAssignable().getColumnReferences().contains(targetColumn)) continue;
                if (compatibleAssignments == null) {
                    compatibleAssignments = new ArrayList<Assignment>(assignments.size());
                }
                compatibleAssignments.add(assignment);
                continue block0;
            }
        }
        return compatibleAssignments == null ? Collections.emptyList() : compatibleAssignments;
    }

    private boolean isIdentifierConflictClause(SqmInsertStatement<?> sqmStatement) {
        JpaConflictClause conflictClause = sqmStatement.getConflictClause();
        assert (conflictClause != null);
        List<SqmPath<?>> constraintPaths = ((SqmConflictClause)conflictClause).getConstraintPaths();
        return constraintPaths.size() == 1 && constraintPaths.get(0).getReferencedPathSource() == ((SqmRoot)sqmStatement.getTarget()).getModel().getIdentifierDescriptor();
    }

    private boolean targetColumnsContainAllConstraintColumns(InsertSelectStatement statement, ConflictClause conflictClause) {
        block0: for (String constraintColumnName : conflictClause.getConstraintColumnNames()) {
            for (ColumnReference targetColumn : statement.getTargetColumns()) {
                if (!targetColumn.getColumnExpression().equals(constraintColumnName)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    protected NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional());
        }
        return (NamedTableReference)tableReference;
    }

    private void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    private void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    private TableReference resolveTableReference(ColumnReference columnReference, Map<String, TableReference> tableReferenceByAlias) {
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + String.valueOf(columnReference));
    }

    protected String getCteTableName(String tableExpression) {
        return this.getCteTableName(tableExpression, "");
    }

    protected String getCteTableName(String tableExpression, String subPrefix) {
        Dialect dialect = this.sessionFactory.getJdbcServices().getDialect();
        if (Identifier.isQuoted(tableExpression)) {
            tableExpression = tableExpression.substring(1, tableExpression.length() - 1);
        }
        return Identifier.toIdentifier(DML_RESULT_TABLE_NAME_PREFIX + subPrefix + tableExpression).render(dialect);
    }
}

