/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.ArrayList;
import java.util.Collections;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.cte.CteDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;

public class CteSoftDeleteHandler
extends CteDeleteHandler {
    protected CteSoftDeleteHandler(CteTable cteTable, SqmDeleteStatement<?> sqmDeleteStatement, DomainParameterXref domainParameterXref, CteMutationStrategy strategy, SessionFactoryImplementor sessionFactory) {
        super(cteTable, sqmDeleteStatement, domainParameterXref, strategy, sessionFactory);
    }

    @Override
    protected void applyDmlOperations(CteContainer statement, CteStatement idSelectCte, SessionFactoryImplementor factory, TableGroup updatingTableGroup) {
        SoftDeleteMapping softDeleteMapping = this.getEntityDescriptor().getSoftDeleteMapping();
        TableDetails softDeleteTable = this.getEntityDescriptor().getSoftDeleteTableDetails();
        CteTable dmlResultCte = new CteTable(this.getCteTableName(softDeleteTable.getTableName()), idSelectCte.getCteTable().getCteColumns());
        TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), softDeleteTable.getTableName(), true);
        NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, softDeleteTable.getTableName());
        ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
        TableDetails.KeyDetails keyDetails = softDeleteTable.getKeyDetails();
        keyDetails.forEachKeyColumn((position, selectable) -> columnReferences.add(new ColumnReference(dmlTableReference, (SelectableMapping)selectable)));
        Assignment assignment = softDeleteMapping.createSoftDeleteAssignment(dmlTableReference);
        UpdateStatement dmlStatement = new UpdateStatement(dmlTableReference, Collections.singletonList(assignment), this.createIdSubQueryPredicate(columnReferences, idSelectCte, factory), columnReferences);
        statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
    }
}

