/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.AbstractDeleteExecutionDelegate;
import org.hibernate.query.sqm.mutation.internal.temptable.ColumnReferenceCheckingSqlAstWalker;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class SoftDeleteExecutionDelegate
extends AbstractDeleteExecutionDelegate {
    public SoftDeleteExecutionDelegate(EntityMappingType entityDescriptor, TemporaryTable idTable, AfterUseAction afterUseAction, SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, QueryParameterBindings queryParameterBindings, Function<SharedSessionContractImplementor, String> sessionUidAccess, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, idTable, afterUseAction, sqmDelete, domainParameterXref, queryOptions, loadQueryInfluencers, queryParameterBindings, sessionUidAccess, sessionFactory);
    }

    @Override
    public int execute(DomainQueryExecutionContext domainQueryExecutionContext) {
        boolean needsSubQuery;
        String targetEntityName = ((SqmRoot)this.getSqmDelete().getTarget()).getEntityName();
        EntityPersister targetEntityDescriptor = this.getSessionFactory().getMappingMetamodel().getEntityDescriptor(targetEntityName);
        EntityMappingType rootEntityDescriptor = targetEntityDescriptor.getRootEntityDescriptor();
        SqmJdbcExecutionContextAdapter executionContext = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(domainQueryExecutionContext);
        TableGroup deletingTableGroup = this.getConverter().getMutatingTableGroup();
        TableDetails softDeleteTable = rootEntityDescriptor.getSoftDeleteTableDetails();
        NamedTableReference rootTableReference = (NamedTableReference)deletingTableGroup.resolveTableReference(deletingTableGroup.getNavigablePath(), softDeleteTable.getTableName());
        assert (rootTableReference != null);
        Predicate specifiedRestriction = this.getConverter().visitWhereClause(this.getSqmDelete().getWhereClause());
        PredicateCollector predicateCollector = new PredicateCollector(specifiedRestriction);
        targetEntityDescriptor.applyBaseRestrictions(predicateCollector, deletingTableGroup, true, executionContext.getSession().getLoadQueryInfluencers().getEnabledFilters(), false, null, this.getConverter());
        this.getConverter().pruneTableGroupJoins();
        ColumnReferenceCheckingSqlAstWalker walker = new ColumnReferenceCheckingSqlAstWalker(rootTableReference.getIdentificationVariable());
        if (predicateCollector.getPredicate() != null) {
            predicateCollector.getPredicate().accept(walker);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.getDomainParameterXref(), SqmUtil.generateJdbcParamsXref(this.getDomainParameterXref(), this.getConverter()), new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return SoftDeleteExecutionDelegate.this.getConverter().getSqmParameterMappingModelExpressibleResolutions().get(parameter);
            }
        }, executionContext.getSession());
        boolean bl = needsSubQuery = !walker.isAllColumnReferencesFromIdentificationVariable() || targetEntityDescriptor != rootEntityDescriptor;
        if (needsSubQuery) {
            if (this.getSessionFactory().getJdbcServices().getDialect().supportsSubqueryOnMutatingTable()) {
                return this.performDeleteWithSubQuery(rootEntityDescriptor, deletingTableGroup, rootTableReference, predicateCollector, jdbcParameterBindings, this.getConverter(), executionContext);
            }
            return this.performDeleteWithIdTable(rootEntityDescriptor, rootTableReference, predicateCollector, jdbcParameterBindings, executionContext);
        }
        return this.performDirectDelete(rootEntityDescriptor, rootTableReference, predicateCollector, jdbcParameterBindings, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performDeleteWithIdTable(EntityMappingType rootEntityDescriptor, NamedTableReference targetTableReference, PredicateCollector predicateCollector, JdbcParameterBindings jdbcParameterBindings, SqmJdbcExecutionContextAdapter executionContext) {
        ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.getIdTable(), executionContext);
        try {
            int n = this.deleteUsingIdTable(rootEntityDescriptor, targetTableReference, predicateCollector, jdbcParameterBindings, executionContext);
            return n;
        }
        finally {
            ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.getIdTable(), this.getSessionUidAccess(), this.getAfterUseAction(), executionContext);
        }
    }

    private int deleteUsingIdTable(EntityMappingType rootEntityDescriptor, NamedTableReference targetTableReference, PredicateCollector predicateCollector, JdbcParameterBindings jdbcParameterBindings, SqmJdbcExecutionContextAdapter executionContext) {
        int rows = ExecuteWithTemporaryTableHelper.saveMatchingIdsIntoIdTable(this.getConverter(), predicateCollector.getPredicate(), this.getIdTable(), this.getSessionUidAccess(), jdbcParameterBindings, executionContext);
        QuerySpec idTableIdentifierSubQuery = ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.getIdTable(), this.getSessionUidAccess(), this.getEntityDescriptor(), executionContext);
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.getEntityDescriptor(), (tableReference, attributeMapping) -> {
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            QuerySpec idTableFkSubQuery = fkDescriptor.getTargetPart().isEntityIdentifierMapping() ? idTableIdentifierSubQuery : ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.getIdTable(), fkDescriptor.getTargetPart(), this.getSessionUidAccess(), this.getEntityDescriptor(), executionContext);
            return new InSubQueryPredicate(MappingModelCreationHelper.buildColumnReferenceExpression(new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference), fkDescriptor, null, this.getSessionFactory()), idTableFkSubQuery, false);
        }, JdbcParameterBindings.NO_BINDINGS, executionContext);
        Assignment softDeleteAssignment = rootEntityDescriptor.getSoftDeleteMapping().createSoftDeleteAssignment(targetTableReference);
        Expression idExpression = SoftDeleteExecutionDelegate.createIdExpression(rootEntityDescriptor, targetTableReference);
        UpdateStatement updateStatement = new UpdateStatement(targetTableReference, Collections.singletonList(softDeleteAssignment), (Predicate)new InSubQueryPredicate(idExpression, idTableIdentifierSubQuery, false));
        this.executeUpdate(updateStatement, jdbcParameterBindings, executionContext);
        return rows;
    }

    private static Expression createIdExpression(EntityMappingType rootEntityDescriptor, NamedTableReference targetTableReference) {
        TableDetails softDeleteTable = rootEntityDescriptor.getSoftDeleteTableDetails();
        TableDetails.KeyDetails keyDetails = softDeleteTable.getKeyDetails();
        ArrayList idExpressions = new ArrayList(keyDetails.getColumnCount());
        keyDetails.forEachKeyColumn((position, column) -> idExpressions.add(new ColumnReference(targetTableReference, (SelectableMapping)column)));
        Expression idExpression = idExpressions.size() == 1 ? (Expression)idExpressions.get(0) : new SqlTuple(idExpressions, rootEntityDescriptor.getIdentifierMapping());
        return idExpression;
    }

    private int performDeleteWithSubQuery(EntityMappingType rootEntityDescriptor, TableGroup deletingTableGroup, NamedTableReference rootTableReference, PredicateCollector predicateCollector, JdbcParameterBindings jdbcParameterBindings, MultiTableSqmMutationConverter converter, SqmJdbcExecutionContextAdapter executionContext) {
        QuerySpec matchingIdSubQuery = new QuerySpec(false, 1);
        matchingIdSubQuery.getFromClause().addRoot(deletingTableGroup);
        TableDetails identifierTableDetails = rootEntityDescriptor.getIdentifierTableDetails();
        TableDetails.KeyDetails keyDetails = identifierTableDetails.getKeyDetails();
        NamedTableReference targetTable = new NamedTableReference(identifierTableDetails.getTableName(), "to_delete_", false);
        ArrayList idExpressions = new ArrayList(keyDetails.getColumnCount());
        keyDetails.forEachKeyColumn((position, column) -> {
            Expression columnReference = converter.getSqlExpressionResolver().resolveSqlExpression(rootTableReference, column);
            matchingIdSubQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(position, columnReference));
            idExpressions.add(new ColumnReference(targetTable, (SelectableMapping)column));
        });
        matchingIdSubQuery.applyPredicate(predicateCollector.getPredicate());
        Expression idExpression = idExpressions.size() == 1 ? (Expression)idExpressions.get(0) : new SqlTuple(idExpressions, rootEntityDescriptor.getIdentifierMapping());
        Assignment softDeleteAssignment = rootEntityDescriptor.getSoftDeleteMapping().createSoftDeleteAssignment(targetTable);
        UpdateStatement updateStatement = new UpdateStatement(targetTable, Collections.singletonList(softDeleteAssignment), (Predicate)new InSubQueryPredicate(idExpression, matchingIdSubQuery, false));
        return this.executeUpdate(updateStatement, jdbcParameterBindings, executionContext);
    }

    private int performDirectDelete(EntityMappingType rootEntityDescriptor, NamedTableReference rootTableReference, PredicateCollector predicateCollector, JdbcParameterBindings jdbcParameterBindings, SqmJdbcExecutionContextAdapter executionContext) {
        Assignment softDeleteAssignment = rootEntityDescriptor.getSoftDeleteMapping().createSoftDeleteAssignment(rootTableReference);
        UpdateStatement updateStatement = new UpdateStatement(rootTableReference, Collections.singletonList(softDeleteAssignment), predicateCollector.getPredicate());
        return this.executeUpdate(updateStatement, jdbcParameterBindings, executionContext);
    }

    private int executeUpdate(UpdateStatement updateStatement, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcOperationQueryMutation jdbcUpdate = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, updateStatement).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return jdbcServices.getJdbcMutationExecutor().execute(jdbcUpdate, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

