/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.dialect.temptable.TemporaryTableSessionUidColumn;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.mutation.internal.InsertHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SqmInsertStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.InsertExecutionDelegate;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmConflictClause;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.BasicType;
import org.jboss.logging.Logger;

public class TableBasedInsertHandler
implements InsertHandler {
    private static final Logger log = Logger.getLogger(TableBasedInsertHandler.class);
    private final SqmInsertStatement<?> sqmInsertStatement;
    private final SessionFactoryImplementor sessionFactory;
    private final TemporaryTable entityTable;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;
    private final JdbcParameter sessionUidParameter;

    public TableBasedInsertHandler(SqmInsertStatement<?> sqmInsert, DomainParameterXref domainParameterXref, TemporaryTable entityTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, SessionFactoryImplementor sessionFactory) {
        this.sqmInsertStatement = sqmInsert;
        this.afterUseAction = afterUseAction;
        this.sessionFactory = sessionFactory;
        this.entityTable = entityTable;
        this.sessionUidAccess = sessionUidAccess;
        this.domainParameterXref = domainParameterXref;
        TemporaryTableSessionUidColumn sessionUidColumn = entityTable.getSessionUidColumn();
        this.sessionUidParameter = sessionUidColumn == null ? null : new JdbcParameterImpl(sessionUidColumn.getJdbcMapping());
    }

    public SqmInsertStatement<?> getSqmInsertStatement() {
        return this.sqmInsertStatement;
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table insert execution - %s", (Object)((SqmRoot)this.getSqmInsertStatement().getTarget()).getModel().getName());
        }
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        return this.resolveDelegate(executionContext).execute(executionContextAdapter);
    }

    protected ExecutionDelegate resolveDelegate(DomainQueryExecutionContext executionContext) {
        EntityPersister entityDescriptor = this.sessionFactory.getMappingMetamodel().getEntityDescriptor(((SqmRoot)this.getSqmInsertStatement().getTarget()).getEntityName());
        MultiTableSqmMutationConverter converterDelegate = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)this.getSqmInsertStatement(), (SqmRoot<?>)this.getSqmInsertStatement().getTarget(), this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), this.sessionFactory.getSqlTranslationEngine());
        TableGroup insertingTableGroup = converterDelegate.getMutatingTableGroup();
        ArrayList<Assignment> targetPathColumns = new ArrayList<Assignment>();
        NamedTableReference entityTableReference = new NamedTableReference(this.entityTable.getTableExpression(), "temptable_", true);
        InsertSelectStatement insertStatement = new InsertSelectStatement(entityTableReference);
        BaseSqmToSqlAstConverter.AdditionalInsertValues additionalInsertValues = converterDelegate.visitInsertionTargetPaths((assigable, columnReferences) -> {
            insertStatement.addTargetColumnReferences((List<ColumnReference>)columnReferences);
            targetPathColumns.add(new Assignment((Assignable)assigable, (Expression)((Object)assigable)));
        }, this.sqmInsertStatement, entityDescriptor, insertingTableGroup);
        TemporaryTableSessionUidColumn sessionUidColumn = this.entityTable.getSessionUidColumn();
        if (this.sqmInsertStatement instanceof SqmInsertSelectStatement) {
            Object queryPart = converterDelegate.visitQueryPart((SqmQueryPart)((SqmInsertSelectStatement)this.sqmInsertStatement).getSelectQueryPart());
            ((QueryPart)queryPart).visitQuerySpecs(querySpec -> {
                Optimizer optimizer;
                if (additionalInsertValues.applySelections((QuerySpec)querySpec, this.sessionFactory)) {
                    TemporaryTableColumn rowNumberColumn = this.entityTable.getColumns().get(this.entityTable.getColumns().size() - (sessionUidColumn == null ? 1 : 2));
                    ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, rowNumberColumn.getJdbcMapping());
                    insertStatement.getTargetColumns().set(insertStatement.getTargetColumns().size() - 1, columnReference);
                    targetPathColumns.set(targetPathColumns.size() - 1, new Assignment(columnReference, columnReference));
                } else if (entityDescriptor.getGenerator() instanceof OptimizableGenerator && (optimizer = ((OptimizableGenerator)entityDescriptor.getGenerator()).getOptimizer()) != null && optimizer.getIncrementSize() > 1) {
                    if (!this.sessionFactory.getJdbcServices().getDialect().supportsWindowFunctions()) {
                        return;
                    }
                    TemporaryTableColumn rowNumberColumn = this.entityTable.getColumns().get(this.entityTable.getColumns().size() - (sessionUidColumn == null ? 1 : 2));
                    ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, rowNumberColumn.getJdbcMapping());
                    insertStatement.getTargetColumns().add(columnReference);
                    targetPathColumns.add(new Assignment(columnReference, columnReference));
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, SqmInsertStrategyHelper.createRowNumberingExpression(querySpec, this.sessionFactory)));
                }
                if (sessionUidColumn != null) {
                    ColumnReference sessionUidColumnReference = new ColumnReference((String)null, sessionUidColumn.getColumnName(), false, null, sessionUidColumn.getJdbcMapping());
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(insertStatement.getTargetColumns().size(), this.sessionUidParameter));
                    insertStatement.getTargetColumns().add(sessionUidColumnReference);
                    targetPathColumns.add(new Assignment(sessionUidColumnReference, this.sessionUidParameter));
                }
            });
            insertStatement.setSourceSelectStatement((QueryPart)queryPart);
        } else {
            BasicType rowNumberType;
            Generator generator = entityDescriptor.getGenerator();
            if (generator instanceof OptimizableGenerator) {
                Optimizer optimizer = ((OptimizableGenerator)generator).getOptimizer();
                if (optimizer != null && optimizer.getIncrementSize() > 1) {
                    TemporaryTableColumn rowNumberColumn = this.entityTable.getColumns().get(this.entityTable.getColumns().size() - (sessionUidColumn == null ? 1 : 2));
                    rowNumberType = (BasicType)rowNumberColumn.getJdbcMapping();
                    ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, rowNumberColumn.getJdbcMapping());
                    insertStatement.getTargetColumns().add(columnReference);
                    targetPathColumns.add(new Assignment(columnReference, columnReference));
                } else {
                    rowNumberType = null;
                }
            } else {
                rowNumberType = null;
            }
            if (sessionUidColumn != null) {
                ColumnReference sessionUidColumnReference = new ColumnReference((String)null, sessionUidColumn.getColumnName(), false, null, sessionUidColumn.getJdbcMapping());
                insertStatement.getTargetColumns().add(sessionUidColumnReference);
                targetPathColumns.add(new Assignment(sessionUidColumnReference, this.sessionUidParameter));
            }
            List<SqmValues> sqmValuesList = ((SqmInsertValuesStatement)this.sqmInsertStatement).getValuesList();
            ArrayList<Values> valuesList = new ArrayList<Values>(sqmValuesList.size());
            for (int i = 0; i < sqmValuesList.size(); ++i) {
                Values values = converterDelegate.visitValues(sqmValuesList.get(i));
                additionalInsertValues.applyValues(values);
                if (rowNumberType != null) {
                    values.getExpressions().add(new QueryLiteral(rowNumberType.getJavaTypeDescriptor().wrap(i + 1, this.sessionFactory.getWrapperOptions()), rowNumberType));
                }
                if (this.sessionUidParameter != null) {
                    values.getExpressions().add(this.sessionUidParameter);
                }
                valuesList.add(values);
            }
            insertStatement.setValuesList(valuesList);
        }
        Object conflictClause = converterDelegate.visitConflictClause((SqmConflictClause)this.sqmInsertStatement.getConflictClause());
        converterDelegate.pruneTableGroupJoins();
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(insertingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(insertingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < insertingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(insertingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        return this.buildExecutionDelegate(this.sqmInsertStatement, converterDelegate, this.entityTable, this.afterUseAction, this.sessionUidAccess, this.domainParameterXref, insertingTableGroup, tableReferenceByAlias, targetPathColumns, insertStatement, (ConflictClause)conflictClause, this.sessionUidParameter, executionContext);
    }

    protected ExecutionDelegate buildExecutionDelegate(SqmInsertStatement<?> sqmInsert, MultiTableSqmMutationConverter sqmConverter, TemporaryTable entityTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainParameterXref domainParameterXref, TableGroup insertingTableGroup, Map<String, TableReference> tableReferenceByAlias, List<Assignment> assignments, InsertSelectStatement insertStatement, ConflictClause conflictClause, JdbcParameter sessionUidParameter, DomainQueryExecutionContext executionContext) {
        return new InsertExecutionDelegate(sqmConverter, entityTable, afterUseAction, sessionUidAccess, domainParameterXref, insertingTableGroup, tableReferenceByAlias, assignments, insertStatement, conflictClause, sessionUidParameter, executionContext);
    }

    private void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    private void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    public static interface ExecutionDelegate {
        public int execute(ExecutionContext var1);
    }
}

