/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.lang.reflect.Type;
import java.util.List;
import java.util.UUID;
import org.hibernate.Internal;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tuple.TupleType;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindingContext;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class ArgumentTypesValidator
implements ArgumentsValidator {
    final ArgumentsValidator delegate;
    private final FunctionParameterType[] types;

    public ArgumentTypesValidator(ArgumentsValidator delegate, FunctionParameterType ... types) {
        this.types = types;
        if (delegate == null) {
            delegate = StandardArgumentsValidators.exactly(types.length);
        }
        this.delegate = delegate;
    }

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
        this.delegate.validate(arguments, functionName, bindingContext);
        int count = 0;
        for (SqmTypedNode<?> argument : arguments) {
            JavaType<?> javaType;
            FunctionParameterType type;
            SqmBindableType<?> nodeType = argument.getNodeType();
            FunctionParameterType functionParameterType = type = count < this.types.length ? this.types[count++] : this.types[this.types.length - 1];
            if (nodeType == null || type == FunctionParameterType.ANY) continue;
            if (nodeType instanceof TupleType) {
                ArgumentTypesValidator.throwTupleError(type, functionName, count);
            }
            if ((javaType = nodeType.getRelationalJavaType()) != null) {
                this.checkArgumentType(functionName, count, argument, type, javaType);
            }
            switch (type) {
                case TEMPORAL_UNIT: {
                    if (argument instanceof SqmExtractUnit || argument instanceof SqmDurationUnit) break;
                    ArgumentTypesValidator.throwError(type, Object.class, null, functionName, count);
                    break;
                }
                case TRIM_SPEC: {
                    if (argument instanceof SqmTrimSpecification) break;
                    ArgumentTypesValidator.throwError(type, Object.class, null, functionName, count);
                    break;
                }
                case COLLATION: {
                    if (argument instanceof SqmCollation) break;
                    ArgumentTypesValidator.throwError(type, Object.class, null, functionName, count);
                    break;
                }
                case NO_UNTYPED: {
                    if (!(argument instanceof SqmLiteralNull)) break;
                    throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' does not permit untyped expressions like null literals. Please cast the expression to a type", count, functionName));
                }
            }
        }
    }

    private void checkArgumentType(String functionName, int count, SqmTypedNode<?> argument, FunctionParameterType type, JavaType<?> javaType) {
        SqmDomainType sqmDomainType;
        if (!JavaTypeHelper.isUnknown(javaType) && (sqmDomainType = argument.getExpressible().getSqmType()) instanceof JdbcMapping) {
            JdbcMapping jdbcMapping = (JdbcMapping)((Object)sqmDomainType);
            ArgumentTypesValidator.checkArgumentType(count, functionName, type, jdbcMapping.getJdbcType(), javaType.getJavaTypeClass());
        }
    }

    @Override
    public void validateSqlTypes(List<? extends SqlAstNode> arguments, String functionName) {
        int count = 0;
        for (SqlAstNode sqlAstNode : arguments) {
            Expression expression;
            JdbcMappingContainer expressionType;
            if (!(sqlAstNode instanceof Expression) || (expressionType = (expression = (Expression)sqlAstNode).getExpressionType()) == null) continue;
            if (ArgumentTypesValidator.isUnknownExpressionType(expressionType)) {
                count += expressionType.getJdbcTypeCount();
                continue;
            }
            count = this.validateArgument(count, expressionType, functionName);
        }
    }

    public static boolean isUnknownExpressionType(JdbcMappingContainer expressionType) {
        return expressionType instanceof JavaObjectType || expressionType instanceof BasicType && JavaTypeHelper.isUnknown(((BasicType)expressionType).getJavaTypeDescriptor());
    }

    private int validateArgument(int paramNumber, JdbcMappingContainer expressionType, String functionName) {
        int jdbcTypeCount = expressionType.getJdbcTypeCount();
        for (int i = 0; i < jdbcTypeCount; ++i) {
            FunctionParameterType type;
            JdbcMapping mapping = expressionType.getJdbcMapping(i);
            FunctionParameterType functionParameterType = type = paramNumber < this.types.length ? this.types[paramNumber++] : this.types[this.types.length - 1];
            if (type == null) continue;
            ArgumentTypesValidator.checkArgumentType(paramNumber, functionName, type, mapping.getJdbcType(), mapping.getJavaTypeDescriptor().getJavaType());
        }
        return paramNumber;
    }

    @Internal
    public static void checkArgumentType(int paramNumber, String functionName, FunctionParameterType type, JdbcType jdbcType, Type javaType) {
        if (!(ArgumentTypesValidator.isCompatible(type, jdbcType, javaType) || type == FunctionParameterType.COMPARABLE && ArgumentTypesValidator.isBinaryUuid(jdbcType, javaType))) {
            ArgumentTypesValidator.throwError(type, javaType, jdbcType.getFriendlyName(), functionName, paramNumber);
        }
    }

    private static boolean isBinaryUuid(JdbcType jdbcType, Type javaType) {
        return javaType == UUID.class && jdbcType.isBinary();
    }

    @Internal
    private static boolean isCompatible(FunctionParameterType type, JdbcType jdbcType, Type javaType) {
        return switch (type) {
            case FunctionParameterType.COMPARABLE -> jdbcType.isComparable();
            case FunctionParameterType.STRING -> jdbcType.isStringLikeExcludingClob();
            case FunctionParameterType.STRING_OR_CLOB -> jdbcType.isString();
            case FunctionParameterType.NUMERIC -> jdbcType.isNumber();
            case FunctionParameterType.INTEGER -> jdbcType.isInteger();
            case FunctionParameterType.BOOLEAN -> {
                if (jdbcType.isBoolean() || jdbcType.isSmallInteger()) {
                    yield true;
                }
                yield false;
            }
            case FunctionParameterType.TEMPORAL -> jdbcType.isTemporal();
            case FunctionParameterType.DATE -> jdbcType.hasDatePart();
            case FunctionParameterType.TIME -> jdbcType.hasTimePart();
            case FunctionParameterType.BINARY -> jdbcType.isBinary();
            case FunctionParameterType.SPATIAL -> jdbcType.isSpatial();
            case FunctionParameterType.JSON -> jdbcType.isJson();
            case FunctionParameterType.IMPLICIT_JSON -> jdbcType.isImplicitJson();
            case FunctionParameterType.XML -> jdbcType.isXml();
            case FunctionParameterType.IMPLICIT_XML -> jdbcType.isImplicitXml();
            case FunctionParameterType.ENUM -> {
                Class clz;
                if (javaType instanceof Class && (clz = (Class)javaType).isEnum()) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private static void throwError(FunctionParameterType type, Type javaType, String sqlType, String functionName, int paramNumber) {
        if (sqlType == null) {
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' has type '%s', but argument is of type '%s'", new Object[]{paramNumber, functionName, type, javaType.getTypeName()}));
        }
        throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' has type '%s', but argument is of type '%s' mapped to '%s'", new Object[]{paramNumber, functionName, type, javaType.getTypeName(), sqlType}));
    }

    private static void throwTupleError(FunctionParameterType type, String functionName, int paramNumber) {
        throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' has type '%s', but argument is a tuple", new Object[]{paramNumber, functionName, type}));
    }

    @Override
    public String getSignature() {
        String sig = this.delegate.getSignature();
        for (int i = 0; i < this.types.length; ++i) {
            Object argName = this.types.length == 1 ? "arg" : "arg" + i;
            sig = sig.replace((CharSequence)argName, String.valueOf((Object)this.types[i]) + " " + (String)argName);
        }
        return sig;
    }
}

