/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.TreatableDomainType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatableDomainType;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmTreatedAttributeJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedListJoin<O, T, S extends T>
extends SqmListJoin<O, S>
implements SqmTreatedAttributeJoin<O, T, S> {
    private final SqmListJoin<O, T> wrappedPath;
    private final SqmTreatableDomainType<S> treatTarget;

    public SqmTreatedListJoin(SqmListJoin<O, T> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias) {
        this(wrappedPath, treatTarget, alias, false);
    }

    public SqmTreatedListJoin(SqmListJoin<O, T> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()).treatAs(treatTarget.getTypeName(), alias), wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedListJoin(NavigablePath navigablePath, SqmListJoin<O, T> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), navigablePath, wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedListJoin<O, T, S> copy(SqmCopyContext context) {
        SqmTreatedListJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedListJoin<O, T, S> path = context.registerCopy(this, new SqmTreatedListJoin<O, T, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias(), this.isFetched()));
        this.copyTo(path, context);
        return path;
    }

    public SqmListJoin<O, T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public TreatableDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmBindableType<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public SqmTreatableDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        return this.getWrappedPath().resolveIndexedAccess(selector, isTerminal, creationState);
    }

    @Override
    public SqmTreatedListJoin<O, T, S> on(JpaExpression<Boolean> restriction) {
        return (SqmTreatedListJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmTreatedListJoin<O, T, S> on(Expression<Boolean> restriction) {
        return (SqmTreatedListJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmTreatedListJoin<O, T, S> on(JpaPredicate ... restrictions) {
        return (SqmTreatedListJoin)super.on(restrictions);
    }

    @Override
    public SqmTreatedListJoin<O, T, S> on(Predicate ... restrictions) {
        return (SqmTreatedListJoin)super.on(restrictions);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("treat(");
        this.wrappedPath.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.treatTarget.getTypeName());
        hql.append(')');
    }
}

