/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.BasicType;

public class AsWrapperSqmExpression<T>
extends AbstractSqmExpression<T> {
    private final SqmExpression<?> expression;

    AsWrapperSqmExpression(SqmBindableType<T> type, SqmExpression<?> expression) {
        super(type, expression.nodeBuilder());
        this.expression = expression;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitAsWrapperExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("wrap(");
        this.expression.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.getNodeType().getReturnedClassName());
        hql.append(")");
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        return this.expression.as((Class)type);
    }

    @Override
    public SqmExpression<T> copy(SqmCopyContext context) {
        return new AsWrapperSqmExpression<T>(this.getExpressible(), (SqmExpression<?>)this.expression.copy(context));
    }

    public SqmExpression<?> getExpression() {
        return this.expression;
    }

    @Override
    public BasicType<T> getNodeType() {
        return (BasicType)super.getNodeType();
    }
}

