/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.criteria.JpaSearchedCase;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public class SqmCaseSearched<R>
extends AbstractSqmExpression<R>
implements JpaSearchedCase<R> {
    private final List<WhenFragment<? extends R>> whenFragments;
    private SqmExpression<? extends R> otherwise;

    public SqmCaseSearched(NodeBuilder nodeBuilder) {
        this((SqmBindableType<R>)null, nodeBuilder);
    }

    public SqmCaseSearched(SqmBindableType<R> inherentType, NodeBuilder nodeBuilder) {
        this(inherentType, 10, nodeBuilder);
    }

    public SqmCaseSearched(int estimatedWhenSize, NodeBuilder nodeBuilder) {
        this(null, estimatedWhenSize, nodeBuilder);
    }

    private SqmCaseSearched(SqmBindableType<R> inherentType, int estimatedWhenSize, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.whenFragments = new ArrayList<WhenFragment<? extends R>>(estimatedWhenSize);
    }

    @Override
    public SqmCaseSearched<R> copy(SqmCopyContext context) {
        SqmCaseSearched existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCaseSearched caseSearched = context.registerCopy(this, new SqmCaseSearched(this.getNodeType(), this.whenFragments.size(), this.nodeBuilder()));
        for (WhenFragment<? extends R> whenFragment : this.whenFragments) {
            caseSearched.whenFragments.add(new WhenFragment(whenFragment.predicate.copy(context), whenFragment.result.copy(context)));
        }
        if (this.otherwise != null) {
            caseSearched.otherwise = this.otherwise.copy(context);
        }
        this.copyTo(caseSearched, context);
        return caseSearched;
    }

    public List<WhenFragment<? extends R>> getWhenFragments() {
        return this.whenFragments;
    }

    public SqmExpression<? extends R> getOtherwise() {
        return this.otherwise;
    }

    public SqmCaseSearched<R> when(SqmPredicate predicate, SqmExpression<? extends R> result) {
        this.whenFragments.add(new WhenFragment<R>(predicate, result));
        this.applyInferableResultType(result.getNodeType());
        return this;
    }

    @Override
    public SqmCaseSearched<R> otherwise(SqmExpression<? extends R> otherwiseExpression) {
        this.otherwise = otherwiseExpression;
        this.applyInferableResultType(otherwiseExpression.getNodeType());
        return this;
    }

    private void applyInferableResultType(SqmBindableType<?> type) {
        SqmBindableType oldType;
        SqmBindableType<?> newType;
        if (type != null && (newType = QueryHelper.highestPrecedenceType2(oldType = this.getExpressible(), type)) != null && newType != oldType) {
            this.internalApplyInferableType(newType);
        }
    }

    @Override
    protected void internalApplyInferableType(SqmBindableType<?> newType) {
        super.internalApplyInferableType(newType);
        if (this.otherwise != null) {
            this.otherwise.applyInferableType(newType);
        }
        if (this.whenFragments != null) {
            this.whenFragments.forEach(whenFragment -> whenFragment.getResult().applyInferableType(newType));
        }
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitSearchedCaseExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "<searched-case>";
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("case");
        for (WhenFragment<? extends R> whenFragment : this.whenFragments) {
            hql.append(" when ");
            whenFragment.predicate.appendHqlString(hql, context);
            hql.append(" then ");
            whenFragment.result.appendHqlString(hql, context);
        }
        if (this.otherwise != null) {
            hql.append(" else ");
            this.otherwise.appendHqlString(hql, context);
        }
        hql.append(" end");
    }

    @Override
    public SqmCaseSearched<R> when(Expression<Boolean> condition, R result) {
        this.when((SqmPredicate)this.nodeBuilder().wrap((Expression)condition), this.nodeBuilder().value(result, this.otherwise));
        return this;
    }

    @Override
    public SqmCaseSearched<R> when(Expression<Boolean> condition, Expression<? extends R> result) {
        this.when((SqmPredicate)this.nodeBuilder().wrap((Expression)condition), (SqmExpression)result);
        return this;
    }

    @Override
    public SqmExpression<R> otherwise(R result) {
        this.otherwise((SqmExpression<? extends R>)this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public SqmExpression<R> otherwise(Expression<? extends R> result) {
        this.otherwise((SqmExpression)result);
        return this;
    }

    public static class WhenFragment<R> {
        private final SqmPredicate predicate;
        private final SqmExpression<R> result;

        public WhenFragment(SqmPredicate predicate, SqmExpression<R> result) {
            this.predicate = predicate;
            this.result = result;
        }

        public SqmPredicate getPredicate() {
            return this.predicate;
        }

        public SqmExpression<R> getResult() {
            return this.result;
        }
    }
}

