/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.metamodel.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.type.descriptor.java.EnumJavaType;

public class SqmEnumLiteral<E extends Enum<E>>
extends SqmLiteral<E>
implements SqmBindableType<E>,
SemanticPathPart {
    private final E enumValue;
    private final EnumJavaType<E> referencedEnumTypeDescriptor;
    private final String enumValueName;

    public SqmEnumLiteral(E enumValue, EnumJavaType<E> referencedEnumTypeDescriptor, String enumValueName, NodeBuilder nodeBuilder) {
        super(null, nodeBuilder);
        this.enumValue = enumValue;
        this.referencedEnumTypeDescriptor = referencedEnumTypeDescriptor;
        this.enumValueName = enumValueName;
        this.setExpressibleType(this);
    }

    @Override
    public SqmEnumLiteral<E> copy(SqmCopyContext context) {
        SqmEnumLiteral existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmEnumLiteral<E> expression = context.registerCopy(this, new SqmEnumLiteral<E>(this.enumValue, this.referencedEnumTypeDescriptor, this.enumValueName, this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public SqmBindableType<E> getExpressible() {
        return this;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    @Override
    public SqmDomainType<E> getSqmType() {
        return null;
    }

    public E getEnumValue() {
        return this.enumValue;
    }

    @Override
    public EnumJavaType<E> getExpressibleJavaType() {
        return this.referencedEnumTypeDescriptor;
    }

    @Override
    public Class<E> getJavaType() {
        return this.getJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new UnknownPathException(String.format(Locale.ROOT, "Static enum reference [%s#%s] cannot be de-referenced", this.referencedEnumTypeDescriptor.getTypeName(), this.enumValueName));
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        throw new UnknownPathException(String.format(Locale.ROOT, "Static enum reference [%s#%s] cannot be de-referenced", this.referencedEnumTypeDescriptor.getTypeName(), this.enumValueName));
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.nodeBuilder().literal((Object)((EnumJavaType)this.getExpressibleJavaType()).toOrdinal(this.enumValue).longValue());
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.nodeBuilder().literal(((EnumJavaType)this.getExpressibleJavaType()).toOrdinal(this.enumValue));
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.nodeBuilder().literal(Float.valueOf(((EnumJavaType)this.getExpressibleJavaType()).toOrdinal(this.enumValue).floatValue()));
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.nodeBuilder().literal((Object)((EnumJavaType)this.getExpressibleJavaType()).toOrdinal(this.enumValue).doubleValue());
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        throw new UnsupportedOperationException("Enum literal cannot be cast to BigDecimal");
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        throw new UnsupportedOperationException("Enum literal cannot be cast to BigInteger");
    }

    @Override
    public SqmExpression<String> asString() {
        return this.nodeBuilder().literal(((EnumJavaType)this.getExpressibleJavaType()).toName(this.enumValue));
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEnumLiteral(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append(((Enum)this.enumValue).getDeclaringClass().getTypeName());
        hql.append('.');
        hql.append(this.enumValueName);
    }
}

