/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.criteria.JpaFunction;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmFunctionPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.expression.Expression;

public abstract class SqmFunction<T>
extends AbstractSqmExpression<T>
implements JpaFunction<T>,
SemanticPathPart {
    private final String functionName;
    private final SqmFunctionDescriptor functionDescriptor;
    private final List<? extends SqmTypedNode<?>> arguments;
    private SqmFunctionPath<T> functionPath;

    public SqmFunction(String functionName, SqmFunctionDescriptor functionDescriptor, @Nullable SqmBindableType<T> type, List<? extends SqmTypedNode<?>> arguments, NodeBuilder criteriaBuilder) {
        super(type, criteriaBuilder);
        this.functionName = functionName;
        this.functionDescriptor = functionDescriptor;
        this.arguments = arguments;
    }

    public SqmFunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public List<? extends SqmTypedNode<?>> getArguments() {
        return this.arguments;
    }

    public abstract Expression convertToSqlAst(SqmToSqlAstConverter var1);

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitFunction(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        switch (this.functionName) {
            case "cast": {
                hql.append("cast(");
                this.arguments.get(0).appendHqlString(hql, context);
                hql.append(" as ");
                this.arguments.get(1).appendHqlString(hql, context);
                hql.append(')');
                break;
            }
            case "extract": {
                hql.append("extract(");
                this.arguments.get(0).appendHqlString(hql, context);
                hql.append(" from ");
                this.arguments.get(1).appendHqlString(hql, context);
                hql.append(')');
                break;
            }
            case "format": {
                hql.append("format(");
                this.arguments.get(0).appendHqlString(hql, context);
                hql.append(" as ");
                this.arguments.get(1).appendHqlString(hql, context);
                hql.append(')');
                break;
            }
            case "overlay": {
                hql.append("overlay(");
                this.arguments.get(0).appendHqlString(hql, context);
                hql.append(" placing ");
                this.arguments.get(1).appendHqlString(hql, context);
                hql.append(" from ");
                this.arguments.get(2).appendHqlString(hql, context);
                if (this.arguments.size() == 4) {
                    hql.append(" for ");
                    this.arguments.get(3).appendHqlString(hql, context);
                }
                hql.append(')');
                break;
            }
            case "trim": {
                hql.append("trim(");
                switch (this.arguments.size()) {
                    case 1: {
                        this.arguments.get(0).appendHqlString(hql, context);
                        break;
                    }
                    case 2: {
                        this.arguments.get(0).appendHqlString(hql, context);
                        hql.append(" from ");
                        this.arguments.get(1).appendHqlString(hql, context);
                        break;
                    }
                    case 3: {
                        this.arguments.get(0).appendHqlString(hql, context);
                        hql.append(' ');
                        this.arguments.get(1).appendHqlString(hql, context);
                        hql.append(" from ");
                        this.arguments.get(3).appendHqlString(hql, context);
                    }
                }
                hql.append(')');
                break;
            }
            case "pad": {
                hql.append("pad(");
                this.arguments.get(0).appendHqlString(hql, context);
                hql.append(" with");
                for (int i = 1; i < this.arguments.size(); ++i) {
                    hql.append(' ');
                    this.arguments.get(i).appendHqlString(hql, context);
                }
                hql.append(')');
                break;
            }
            case "position": {
                hql.append("position(");
                this.arguments.get(0).appendHqlString(hql, context);
                hql.append(" in ");
                this.arguments.get(1).appendHqlString(hql, context);
                hql.append(')');
                break;
            }
            default: {
                hql.append(this.functionName);
                if (this.arguments.isEmpty()) {
                    if (this.functionDescriptor.alwaysIncludesParentheses()) {
                        hql.append("()");
                    }
                    return;
                }
                hql.append('(');
                this.arguments.get(0).appendHqlString(hql, context);
                for (int i = 1; i < this.arguments.size(); ++i) {
                    hql.append(", ");
                    this.arguments.get(i).appendHqlString(hql, context);
                }
                hql.append(')');
            }
        }
    }

    private SqmFunctionPath<T> getFunctionPath() {
        SqmFunctionPath<T> path = this.functionPath;
        if (path == null) {
            path = this.functionPath = new SqmFunctionPath(this);
        }
        return path;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        return this.getFunctionPath().resolvePathPart(name, isTerminal, creationState);
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        return this.getFunctionPath().resolveIndexedAccess(selector, isTerminal, creationState);
    }
}

