/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.NumericTypeCategory;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmHqlNumericLiteral<N extends Number>
extends SqmLiteral<N> {
    private final String literalValue;
    private final NumericTypeCategory typeCategory;
    private BasicDomainType<N> type;

    public SqmHqlNumericLiteral(String literalValue, BasicDomainType<N> type, NodeBuilder criteriaBuilder) {
        this(literalValue, SqmHqlNumericLiteral.interpretCategory(literalValue, criteriaBuilder.resolveExpressible(type)), type, criteriaBuilder);
        this.type = type;
    }

    public SqmHqlNumericLiteral(String literalValue, NumericTypeCategory typeCategory, BasicDomainType<N> type, NodeBuilder criteriaBuilder) {
        super(criteriaBuilder.resolveExpressible(type), criteriaBuilder);
        this.literalValue = literalValue;
        this.typeCategory = typeCategory;
        this.type = type;
    }

    public String getUnparsedLiteralValue() {
        return this.literalValue;
    }

    @Override
    public N getLiteralValue() {
        return this.typeCategory.parseLiteralValue(this.literalValue);
    }

    public NumericTypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitHqlNumericLiteral(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append(this.literalValue);
        switch (this.typeCategory) {
            case BIG_DECIMAL: {
                hql.append("bd");
                break;
            }
            case FLOAT: {
                hql.append("f");
                break;
            }
            case BIG_INTEGER: {
                hql.append("bi");
                break;
            }
            case LONG: {
                hql.append("l");
                break;
            }
        }
    }

    @Override
    public String asLoggableText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendHqlString(stringBuilder, SqmRenderContext.simpleContext());
        return stringBuilder.toString();
    }

    @Override
    public SqmHqlNumericLiteral<N> copy(SqmCopyContext context) {
        return new SqmHqlNumericLiteral<N>(this.literalValue, this.typeCategory, this.type, this.nodeBuilder());
    }

    private static <N extends Number> NumericTypeCategory interpretCategory(String literalValue, SqmExpressible<N> type) {
        assert (type != null);
        JavaType<N> javaTypeDescriptor = type.getExpressibleJavaType();
        assert (javaTypeDescriptor != null);
        Class<N> javaTypeClass = javaTypeDescriptor.getJavaTypeClass();
        if (BigDecimal.class.equals(javaTypeClass)) {
            return NumericTypeCategory.BIG_DECIMAL;
        }
        if (Double.class.equals(javaTypeClass)) {
            return NumericTypeCategory.DOUBLE;
        }
        if (Float.class.equals(javaTypeClass)) {
            return NumericTypeCategory.FLOAT;
        }
        if (BigInteger.class.equals(javaTypeClass)) {
            return NumericTypeCategory.BIG_INTEGER;
        }
        if (Long.class.equals(javaTypeClass)) {
            return NumericTypeCategory.LONG;
        }
        if (Short.class.equals(javaTypeClass) || Integer.class.equals(javaTypeClass)) {
            return NumericTypeCategory.INTEGER;
        }
        throw new TypeException(literalValue, javaTypeClass);
    }

    public static class TypeException
    extends HibernateException {
        public TypeException(String literalValue, Class<?> javaType) {
            super(String.format(Locale.ROOT, "Unexpected Java type [%s] for numeric literal - %s", javaType.getTypeName(), literalValue));
        }
    }
}

