/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.criteria.JpaJsonExistsExpression;
import org.hibernate.query.criteria.JpaJsonExistsNode;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.AbstractSqmJsonPathExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;

@Incubating
public class SqmJsonExistsExpression
extends AbstractSqmJsonPathExpression<Boolean>
implements JpaJsonExistsExpression {
    private JpaJsonExistsNode.ErrorBehavior errorBehavior = JpaJsonExistsNode.ErrorBehavior.UNSPECIFIED;

    public SqmJsonExistsExpression(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<Boolean> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
    }

    private SqmJsonExistsExpression(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<Boolean> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name, @Nullable Map<String, SqmExpression<?>> passingExpressions, JpaJsonExistsNode.ErrorBehavior errorBehavior) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name, passingExpressions);
        this.errorBehavior = errorBehavior;
    }

    @Override
    public SqmJsonExistsExpression copy(SqmCopyContext context) {
        SqmJsonExistsExpression existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        return context.registerCopy(this, new SqmJsonExistsExpression(this.getFunctionDescriptor(), this.getFunctionRenderer(), arguments, this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), this.nodeBuilder(), this.getFunctionName(), this.copyPassingExpressions(context), this.errorBehavior));
    }

    @Override
    public JpaJsonExistsNode.ErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    @Override
    public SqmJsonExistsExpression unspecifiedOnError() {
        this.errorBehavior = JpaJsonExistsNode.ErrorBehavior.UNSPECIFIED;
        return this;
    }

    @Override
    public SqmJsonExistsExpression errorOnError() {
        this.errorBehavior = JpaJsonExistsNode.ErrorBehavior.ERROR;
        return this;
    }

    @Override
    public SqmJsonExistsExpression trueOnError() {
        this.errorBehavior = JpaJsonExistsNode.ErrorBehavior.TRUE;
        return this;
    }

    @Override
    public SqmJsonExistsExpression falseOnError() {
        this.errorBehavior = JpaJsonExistsNode.ErrorBehavior.FALSE;
        return this;
    }

    @Override
    public SqmJsonExistsExpression passing(String parameterName, jakarta.persistence.criteria.Expression<?> expression) {
        this.addPassingExpression(parameterName, (SqmExpression)expression);
        return this;
    }

    @Override
    public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
        JsonPathPassingClause jsonPathPassingClause;
        @Nullable ReturnableType<?> resultType = this.resolveResultType(walker);
        List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
        ArgumentsValidator validator = this.getArgumentsValidator();
        if (validator != null) {
            validator.validateSqlTypes(arguments, this.getFunctionName());
        }
        if ((jsonPathPassingClause = this.createJsonPathPassingClause(walker)) != null) {
            arguments.add(jsonPathPassingClause);
        }
        switch (this.errorBehavior) {
            case ERROR: {
                arguments.add(JsonExistsErrorBehavior.ERROR);
                break;
            }
            case TRUE: {
                arguments.add(JsonExistsErrorBehavior.TRUE);
                break;
            }
            case FALSE: {
                arguments.add(JsonExistsErrorBehavior.FALSE);
            }
        }
        return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getFunctionRenderer(), arguments, resultType, resultType == null ? null : this.getMappingModelExpressible(walker, resultType, arguments));
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("json_exists(");
        this.getArguments().get(0).appendHqlString(hql, context);
        hql.append(',');
        this.getArguments().get(1).appendHqlString(hql, context);
        this.appendPassingExpressionHqlString(hql, context);
        switch (this.errorBehavior) {
            case ERROR: {
                hql.append(" error on error");
                break;
            }
            case TRUE: {
                hql.append(" true on error");
                break;
            }
            case FALSE: {
                hql.append(" false on error");
            }
        }
        hql.append(')');
    }
}

