/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.query.hql.HqlInterpretationException;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmEntityDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class SqmLiteralEntityType<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T>,
SemanticPathPart {
    private final SqmEntityDomainType<T> entityType;

    public SqmLiteralEntityType(SqmEntityDomainType<T> entityType, NodeBuilder nodeBuilder) {
        super(DiscriminatorHelper.getDiscriminatorType(entityType, nodeBuilder), nodeBuilder);
        this.entityType = entityType;
    }

    @Override
    public SqmLiteralEntityType<T> copy(SqmCopyContext context) {
        SqmLiteralEntityType existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmLiteralEntityType<T> expression = context.registerCopy(this, new SqmLiteralEntityType<T>(this.entityType, (NodeBuilder)this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public SqmEntityDomainType<T> getNodeType() {
        return this.entityType;
    }

    @Override
    public void internalApplyInferableType(SqmBindableType<?> type) {
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEntityTypeLiteralExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "TYPE(" + String.valueOf(this.entityType) + ")";
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new HqlInterpretationException("Cannot dereference an entity name");
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        throw new HqlInterpretationException("Cannot dereference an entity name");
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append(this.entityType.getName());
    }
}

