/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class SqmModifiedSubQueryExpression<T>
extends AbstractSqmExpression<T> {
    private final SqmSubQuery<T> subQuery;
    private final Modifier modifier;

    public SqmModifiedSubQueryExpression(SqmSubQuery<T> subquery, Modifier modifier, NodeBuilder builder) {
        this(subquery, modifier, subquery.getNodeType(), builder);
    }

    public SqmModifiedSubQueryExpression(SqmSubQuery<T> subQuery, Modifier modifier, SqmBindableType<T> resultType, NodeBuilder builder) {
        super(resultType, builder);
        this.subQuery = subQuery;
        this.modifier = modifier;
    }

    @Override
    public SqmModifiedSubQueryExpression<T> copy(SqmCopyContext context) {
        SqmModifiedSubQueryExpression existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmModifiedSubQueryExpression expression = context.registerCopy(this, new SqmModifiedSubQueryExpression(this.subQuery.copy(context), this.modifier, this.getNodeType(), this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public SqmSubQuery<T> getSubQuery() {
        return this.subQuery;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitModifiedSubQueryExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append((Object)this.modifier);
        hql.append(" (");
        this.subQuery.appendHqlString(hql, context);
        hql.append(')');
    }

    public static enum Modifier {
        ALL,
        ANY,
        SOME;

    }
}

