/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.common.FrameExclusion;
import org.hibernate.query.common.FrameKind;
import org.hibernate.query.common.FrameMode;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmWindow;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;

public class SqmOver<T>
extends AbstractSqmExpression<T> {
    private final SqmExpression<T> expression;
    private final SqmWindow window;

    public SqmOver(SqmExpression<T> expression, SqmWindow window) {
        super(expression.getNodeType(), expression.nodeBuilder());
        this.expression = expression;
        this.window = window;
    }

    public SqmOver(SqmExpression<T> expression, List<SqmExpression<?>> partitions, List<SqmSortSpecification> orderList, FrameMode mode, FrameKind startKind, SqmExpression<?> startExpression, FrameKind endKind, SqmExpression<?> endExpression, FrameExclusion exclusion) {
        this(expression, new SqmWindow(expression.nodeBuilder(), partitions, orderList, mode, startKind, startExpression, endKind, endExpression, exclusion));
    }

    @Override
    public SqmOver<T> copy(SqmCopyContext context) {
        SqmOver existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmOver<T> over = context.registerCopy(this, new SqmOver<T>(this.expression.copy(context), this.window.copy(context)));
        this.copyTo(over, context);
        return over;
    }

    public SqmExpression<T> getExpression() {
        return this.expression;
    }

    public SqmWindow getWindow() {
        return this.window;
    }

    @Override
    public @Nullable SqmBindableType<T> getNodeType() {
        return this.expression.getNodeType();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitOver(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.expression.appendHqlString(hql, context);
        hql.append(" over (");
        this.window.appendHqlString(hql, context);
        hql.append(')');
    }
}

