/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmOverflow<T>
extends AbstractSqmExpression<T> {
    private final SqmExpression<T> separatorExpression;
    private final SqmExpression<T> fillerExpression;
    private final boolean withCount;

    public SqmOverflow(SqmExpression<T> separatorExpression, SqmExpression<T> fillerExpression, boolean withCount) {
        super(separatorExpression.getNodeType(), separatorExpression.nodeBuilder());
        this.separatorExpression = separatorExpression;
        this.fillerExpression = fillerExpression;
        this.withCount = withCount;
    }

    @Override
    public SqmOverflow<T> copy(SqmCopyContext context) {
        SqmOverflow existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmOverflow<T> expression = context.registerCopy(this, new SqmOverflow<T>(this.separatorExpression.copy(context), this.fillerExpression == null ? null : this.fillerExpression.copy(context), this.withCount));
        this.copyTo(expression, context);
        return expression;
    }

    public SqmExpression<T> getSeparatorExpression() {
        return this.separatorExpression;
    }

    public SqmExpression<T> getFillerExpression() {
        return this.fillerExpression;
    }

    public boolean isWithCount() {
        return this.withCount;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitOverflow(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.separatorExpression.appendHqlString(hql, context);
        hql.append(" on overflow ");
        if (this.fillerExpression == null) {
            hql.append("error");
        } else {
            hql.append("truncate ");
            this.fillerExpression.appendHqlString(hql, context);
            if (this.withCount) {
                hql.append(" with count");
            } else {
                hql.append(" without count");
            }
        }
    }
}

