/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Internal;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.PathException;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.TreatException;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedRoot;
import org.hibernate.query.sqm.tree.domain.SqmEntityDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedFrom;
import org.hibernate.query.sqm.tree.domain.SqmTreatedRoot;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.spi.NavigablePath;

public class SqmRoot<E>
extends AbstractSqmFrom<E, E>
implements JpaRoot<E> {
    private final boolean allowJoins;
    private List<SqmJoin<?, ?>> orderedJoins;

    public SqmRoot(EntityDomainType<E> entityType, String alias, boolean allowJoins, NodeBuilder nodeBuilder) {
        super(entityType, alias, nodeBuilder);
        this.allowJoins = allowJoins;
    }

    protected SqmRoot(NavigablePath navigablePath, SqmPathSource<E> referencedNavigable, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, nodeBuilder);
        this.allowJoins = true;
    }

    public SqmRoot(NavigablePath navigablePath, EntityDomainType<E> entityType, String alias, NodeBuilder nodeBuilder) {
        super(navigablePath, (SqmEntityDomainType)entityType, alias, nodeBuilder);
        this.allowJoins = true;
    }

    protected SqmRoot(NavigablePath navigablePath, SqmPathSource<E> referencedNavigable, String alias, boolean allowJoins, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, alias, nodeBuilder);
        this.allowJoins = allowJoins;
    }

    @Override
    public SqmRoot<E> copy(SqmCopyContext context) {
        SqmRoot existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmRoot path = context.registerCopy(this, new SqmRoot(this.getNavigablePath(), this.getReferencedPathSource(), this.getExplicitAlias(), this.allowJoins, (NodeBuilder)this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    @Internal
    public void copyTo(SqmRoot<E> target, SqmCopyContext context) {
        super.copyTo(target, context);
        if (this.orderedJoins != null) {
            target.orderedJoins = new ArrayList(this.orderedJoins.size());
            for (SqmJoin<?, ?> orderedJoin : this.orderedJoins) {
                target.orderedJoins.add((SqmJoin<?, ?>)orderedJoin.copy(context));
            }
        }
    }

    @Override
    public SqmPath<?> getLhs() {
        return null;
    }

    public boolean isAllowJoins() {
        return this.allowJoins;
    }

    public List<SqmJoin<?, ?>> getOrderedJoins() {
        return this.orderedJoins;
    }

    public void addOrderedJoin(SqmJoin<?, ?> join) {
        if (this.orderedJoins == null) {
            if (!(join instanceof SqmAttributeJoin)) {
                this.orderedJoins = new ArrayList();
                this.visitSqmJoins(this::addOrderedJoinTransitive);
            }
        } else {
            this.orderedJoins.add(join);
        }
    }

    private void addOrderedJoinTransitive(SqmJoin<?, ?> join) {
        this.orderedJoins.add(join);
        join.visitSqmJoins(this::addOrderedJoinTransitive);
    }

    @Override
    public void addSqmJoin(SqmJoin<E, ?> join) {
        if (!this.allowJoins) {
            throw new IllegalArgumentException("The root node [" + String.valueOf(this) + "] does not allow join/fetch");
        }
        super.addSqmJoin(join);
    }

    @Override
    public SqmRoot<?> findRoot() {
        return this;
    }

    public String getEntityName() {
        return this.getModel().getHibernateEntityName();
    }

    @Override
    public String toString() {
        return this.getExplicitAlias() == null ? this.getEntityName() : this.getEntityName() + " as " + this.getExplicitAlias();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitRootPath(this);
    }

    @Override
    public SqmEntityDomainType<E> getModel() {
        return (SqmEntityDomainType)this.getReferencedPathSource();
    }

    @Override
    public EntityDomainType<E> getManagedType() {
        return this.getModel();
    }

    public SqmCorrelatedRoot<E> createCorrelation() {
        return new SqmCorrelatedRoot(this);
    }

    public boolean containsOnlyInnerJoins() {
        for (SqmJoin sqmJoin : this.getSqmJoins()) {
            if (sqmJoin.getSqmJoinType() == SqmJoinType.INNER) continue;
            return false;
        }
        return !this.hasTreats();
    }

    @Override
    public <S extends E> SqmTreatedFrom<E, E, S> treatAs(Class<S> treatJavaType) throws PathException {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    @Override
    public <S extends E> SqmTreatedFrom<E, E, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        Object treat = this.findTreat(treatTarget, null);
        if (treat == null) {
            return this.addTreat(new SqmTreatedRoot(this, (SqmEntityDomainType)treatTarget));
        }
        return treat;
    }

    public <S extends E> SqmTreatedRoot treatAs(Class<S> treatJavaType, String alias) {
        throw new UnsupportedOperationException("Root treats can not be aliased");
    }

    public <S extends E> SqmTreatedRoot treatAs(EntityDomainType<S> treatTarget, String alias) {
        throw new UnsupportedOperationException("Root treats can not be aliased");
    }

    public <S extends E> SqmTreatedRoot treatAs(Class<S> treatJavaType, String alias, boolean fetch) {
        throw new TreatException("Root paths cannot be aliased, nor fetched - " + this.getNavigablePath().getFullPath());
    }

    public <S extends E> SqmTreatedRoot treatAs(EntityDomainType<S> treatTarget, String alias, boolean fetch) {
        throw new TreatException("Root paths cannot be aliased, nor fetched - " + this.getNavigablePath().getFullPath());
    }
}

