/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.predicate.AbstractSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public class SqmGroupedPredicate
extends AbstractSqmPredicate {
    private final SqmPredicate subPredicate;

    public SqmGroupedPredicate(SqmPredicate subPredicate, NodeBuilder nodeBuilder) {
        super(subPredicate.getExpressible(), nodeBuilder);
        this.subPredicate = subPredicate;
    }

    @Override
    public SqmGroupedPredicate copy(SqmCopyContext context) {
        SqmGroupedPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmGroupedPredicate predicate = context.registerCopy(this, new SqmGroupedPredicate(this.subPredicate.copy(context), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmPredicate getSubPredicate() {
        return this.subPredicate;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitGroupedPredicate(this);
    }

    public boolean isNegated() {
        return false;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        ArrayList<Expression<Boolean>> expressions = new ArrayList<Expression<Boolean>>(1);
        expressions.add(this.subPredicate);
        return expressions;
    }

    @Override
    public SqmPredicate not() {
        return new SqmNegatedPredicate(this, (NodeBuilder)this.nodeBuilder());
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append('(');
        this.subPredicate.appendHqlString(hql, context);
        hql.append(')');
    }
}

