/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmLikePredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> matchExpression;
    private final SqmExpression<?> pattern;
    private final SqmExpression<?> escapeCharacter;
    private final boolean isCaseSensitive;

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, SqmExpression<?> escapeCharacter, NodeBuilder nodeBuilder) {
        this(matchExpression, pattern, escapeCharacter, false, nodeBuilder);
    }

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, SqmExpression<?> escapeCharacter, boolean negated, NodeBuilder nodeBuilder) {
        this(matchExpression, pattern, escapeCharacter, negated, true, nodeBuilder);
    }

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, SqmExpression<?> escapeCharacter, boolean negated, boolean isCaseSensitive, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.matchExpression = matchExpression;
        this.pattern = pattern;
        this.escapeCharacter = escapeCharacter;
        this.isCaseSensitive = isCaseSensitive;
        SqmBindableType expressibleType = QueryHelper.highestPrecedenceType(matchExpression.getExpressible(), pattern.getExpressible());
        TypecheckUtil.assertString(matchExpression);
        TypecheckUtil.assertString(pattern);
        matchExpression.applyInferableType(expressibleType);
        pattern.applyInferableType(expressibleType);
        if (escapeCharacter != null) {
            escapeCharacter.applyInferableType(nodeBuilder.getCharacterType());
        }
    }

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, NodeBuilder nodeBuilder) {
        this(matchExpression, pattern, null, nodeBuilder);
    }

    public SqmLikePredicate(SqmExpression<?> matchExpression, SqmExpression<?> pattern, boolean negated, boolean isCaseSensitive, NodeBuilder nodeBuilder) {
        this(matchExpression, pattern, null, negated, isCaseSensitive, nodeBuilder);
    }

    @Override
    public SqmLikePredicate copy(SqmCopyContext context) {
        SqmLikePredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmLikePredicate predicate = context.registerCopy(this, new SqmLikePredicate((SqmExpression<?>)this.matchExpression.copy(context), (SqmExpression<?>)this.pattern.copy(context), (SqmExpression<?>)(this.escapeCharacter == null ? null : this.escapeCharacter.copy(context)), this.isNegated(), this.isCaseSensitive, this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmExpression<?> getMatchExpression() {
        return this.matchExpression;
    }

    public SqmExpression<?> getPattern() {
        return this.pattern;
    }

    public SqmExpression<?> getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitLikePredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.matchExpression.appendHqlString(hql, context);
        if (this.isNegated()) {
            hql.append(" not");
        }
        hql.append(" like ");
        this.pattern.appendHqlString(hql, context);
        if (this.escapeCharacter != null) {
            hql.append(" escape ");
            this.escapeCharacter.appendHqlString(hql, context);
        }
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmLikePredicate(this.matchExpression, this.pattern, this.escapeCharacter, !this.isNegated(), this.isCaseSensitive, this.nodeBuilder());
    }
}

