/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.metamodel.Type;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmMemberOfPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> leftHandExpression;
    private final SqmPluralValuedSimplePath<?> pluralPath;

    public SqmMemberOfPredicate(SqmExpression<?> leftHandExpression, SqmPluralValuedSimplePath<?> pluralPath, NodeBuilder nodeBuilder) {
        this(leftHandExpression, pluralPath, false, nodeBuilder);
    }

    public SqmMemberOfPredicate(SqmExpression<?> leftHandExpression, SqmPluralValuedSimplePath<?> pluralPath, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.pluralPath = pluralPath;
        this.leftHandExpression = leftHandExpression;
        Type elementType = pluralPath.getPluralAttribute().getElementType();
        SqmBindableType simpleDomainType = nodeBuilder.resolveExpressible(elementType);
        if (!TypecheckUtil.areTypesComparable(leftHandExpression.getNodeType(), simpleDomainType, nodeBuilder)) {
            throw new SemanticException(String.format("Cannot compare left expression of type '%s' with right expression of type '%s'", leftHandExpression.getNodeType().getTypeName(), pluralPath.getNodeType().getTypeName()));
        }
        leftHandExpression.applyInferableType(simpleDomainType);
    }

    @Override
    public SqmMemberOfPredicate copy(SqmCopyContext context) {
        SqmMemberOfPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmMemberOfPredicate predicate = context.registerCopy(this, new SqmMemberOfPredicate((SqmExpression<?>)this.leftHandExpression.copy(context), (SqmPluralValuedSimplePath<?>)this.pluralPath.copy(context), this.isNegated(), this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmExpression<?> getLeftHandExpression() {
        return this.leftHandExpression;
    }

    public SqmPluralValuedSimplePath<?> getPluralPath() {
        return this.pluralPath;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitMemberOfPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.leftHandExpression.appendHqlString(hql, context);
        if (this.isNegated()) {
            hql.append(" not");
        }
        hql.append(" member of ");
        this.pluralPath.appendHqlString(hql, context);
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmMemberOfPredicate(this.leftHandExpression, this.pluralPath, !this.isNegated(), this.nodeBuilder());
    }
}

