/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmTruthnessPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> expression;
    private final boolean value;

    public SqmTruthnessPredicate(SqmExpression<?> expression, boolean value, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.expression = expression;
        this.value = value;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public SqmTruthnessPredicate copy(SqmCopyContext context) {
        SqmTruthnessPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTruthnessPredicate predicate = context.registerCopy(this, new SqmTruthnessPredicate((SqmExpression<?>)this.expression.copy(context), this.getBooleanValue(), this.isNegated(), this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmExpression<?> getExpression() {
        return this.expression;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitIsTruePredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.expression.appendHqlString(hql, context);
        hql.append(" is ");
        if (this.isNegated()) {
            hql.append("not ");
        }
        hql.append(this.getBooleanValue());
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmTruthnessPredicate(this.expression, this.getBooleanValue(), !this.isNegated(), this.nodeBuilder());
    }
}

